/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.miningsteps;

import java.util.Vector;
import oracle.dmt.dm4j.activity.AbstractActivity;
import oracle.dmt.dm4j.activity.steps.OClusterBuildStepOptions;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.minings.WizardStepState;
import oracle.dmt.dm4j.wizard.state.miningsteps.AlgorithmSettingState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ClusteringAlgorithmState;

public class OClusterAlgorithmState
extends AlgorithmSettingState {
    private AbstractActivity m_activity = null;
    private OClusterBuildStepOptions m_options = null;
    private OClusterBuildStepOptions m_savedOptions = null;
    private ClusteringAlgorithmState m_wizardStepState;

    public OClusterAlgorithmState(WizardStepState wizardStepState) {
        super(wizardStepState);
        this.m_wizardStepState = (ClusteringAlgorithmState)wizardStepState;
        this.initialize();
    }

    public OClusterAlgorithmState() {
        this.initialize();
    }

    private void initialize() {
        BrowserContext browserContext = this.m_wizardStepState.getparentWizardState().getBrowserContext();
        this.m_activity = browserContext.getActivity();
        this.m_options = (OClusterBuildStepOptions)browserContext.getOptions();
        this.m_savedOptions = new OClusterBuildStepOptions(this.m_options);
    }

    public void setSensitivity(Double d) {
        if (this.m_wizardStepState.getState() == StepStateType.VALIDATED) {
            this.m_wizardStepState.setState(StepStateType.DIRTY);
        }
        this.m_options.setSensitivity(d);
    }

    public Double getSensitivity() {
        return this.m_options.getSensitivity();
    }

    public void setMaximumBufferSize(Long l) {
        if (this.m_wizardStepState.getState() == StepStateType.VALIDATED) {
            this.m_wizardStepState.setState(StepStateType.DIRTY);
        }
        this.m_options.setMaximumBufferSize(l);
    }

    public Long getMaximumBufferSize() {
        return this.m_options.getMaximumBufferSize();
    }

    public void validate(Vector vector) throws Exception {
        this.m_options.validate(vector);
    }

    public Vector validate() throws Exception {
        Vector vector = new Vector();
        this.validate(vector);
        return vector;
    }

    public void restoreSettingsToDefault() {
        if (this.m_wizardStepState.getState() == StepStateType.VALIDATED) {
            this.m_wizardStepState.setState(StepStateType.DIRTY);
        }
        this.m_options.restoreToDefaultSettings(this.m_activity);
    }

    public void restoreSettings() {
        if (this.m_wizardStepState.getState() == StepStateType.DIRTY) {
            this.m_wizardStepState.setState(StepStateType.VALIDATED);
        }
        this.m_options.restoreSettings(this.m_savedOptions);
    }
}

