/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.miningsteps;

import java.util.Vector;
import oracle.dmt.dm4j.activity.steps.NaiveBayesBuildStepOptions;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.browser.LaunchPoint;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.minings.WizardStepState;
import oracle.dmt.dm4j.wizard.state.miningsteps.AlgorithmSettingState;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.miningsteps.NaiveBayesAlgorithmStateError;

public class NaiveBayesAlgorithmState
extends AlgorithmSettingState {
    private Double m_singletonThreshold;
    private Double m_defaultSingletonThreshold;
    private Double m_pairwiseThreshold;
    private Double m_defaultPairwiseThreshold;
    private NaiveBayesBuildStepOptions m_options = null;

    public NaiveBayesAlgorithmState(WizardStepState wizardStepState, Double d, Double d2) {
        super(wizardStepState);
        this.initialize(d, d2);
    }

    public NaiveBayesAlgorithmState(Double d, Double d2) {
        this.initialize(d, d2);
    }

    private void initialize(Double d, Double d2) {
        BrowserContext browserContext = this.m_wizardStepState.getparentWizardState().getBrowserContext();
        if (browserContext.getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE) && browserContext.getOptions() instanceof NaiveBayesBuildStepOptions) {
            this.m_options = (NaiveBayesBuildStepOptions)browserContext.getOptions();
        }
        if (this.m_options != null) {
            this.m_singletonThreshold = this.m_options.getSingletonThreshold();
            this.m_pairwiseThreshold = this.m_options.getPairwiseThreshold();
        } else {
            this.m_singletonThreshold = d;
            this.m_pairwiseThreshold = d2;
        }
        this.m_defaultSingletonThreshold = d;
        this.m_defaultPairwiseThreshold = d2;
    }

    public void setSingletonThreshold(Double d) {
        if (this.m_singletonThreshold == null || d == null || this.m_singletonThreshold.compareTo(d) != 0) {
            if (this.m_wizardStepState.getState() == StepStateType.VALIDATED) {
                this.m_wizardStepState.setState(StepStateType.DIRTY);
            }
            this.m_singletonThreshold = d;
            if (this.m_options != null) {
                this.m_options.setSingletonThreshold(d);
            }
        }
    }

    public Double getSingletonThreshold() {
        return this.m_singletonThreshold;
    }

    public void setPairwiseThreshold(Double d) {
        if (this.m_pairwiseThreshold == null || d == null || this.m_pairwiseThreshold.compareTo(d) != 0) {
            if (this.m_wizardStepState.getState() == StepStateType.VALIDATED) {
                this.m_wizardStepState.setState(StepStateType.DIRTY);
            }
            this.m_pairwiseThreshold = d;
            if (this.m_options != null) {
                this.m_options.setPairwiseThreshold(d);
            }
        }
    }

    public Double getPairwiseThreshold() {
        return this.m_pairwiseThreshold;
    }

    protected void validateSingletonThreshold(Vector vector) throws Exception {
        if (this.m_singletonThreshold == null) {
            String string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            String[] stringArray = new String[]{ResourceUtilities.getUILabel("ALGO_NB_SINGLETON_THRESHOLD")};
            vector.add(new StateValidation(NaiveBayesAlgorithmStateError.ALGO_NB_SINGLETON_THRESHOLD_EMPTY, string, stringArray));
        } else {
            double d = this.m_singletonThreshold;
            if (d < 0.0 || d > 1.0) {
                vector.add(new StateValidation(NaiveBayesAlgorithmStateError.ALGO_NB_SINGLETON_THRESHOLD_INVALID));
            }
        }
    }

    protected void validatePairwiseThreshold(Vector vector) throws Exception {
        if (this.m_pairwiseThreshold == null) {
            String string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            String[] stringArray = new String[]{ResourceUtilities.getUILabel("ALGO_NB_PAIRWISE_THRESHOLD")};
            vector.add(new StateValidation(NaiveBayesAlgorithmStateError.ALGO_NB_PAIRWISE_THRESHOLD_EMPTY, string, stringArray));
        } else {
            double d = this.m_pairwiseThreshold;
            if (d < 0.0 || d > 1.0) {
                vector.add(new StateValidation(NaiveBayesAlgorithmStateError.ALGO_NB_PAIRWISE_THRESHOLD_INVALID));
            }
        }
    }

    public void validate(Vector vector) throws Exception {
        this.validateSingletonThreshold(vector);
        this.validatePairwiseThreshold(vector);
    }

    public Vector validate() throws Exception {
        Vector vector = new Vector();
        this.validate(vector);
        return vector;
    }

    public void restoreSettingsToDefault() {
        this.setSingletonThreshold(this.m_defaultSingletonThreshold);
        this.setPairwiseThreshold(this.m_defaultPairwiseThreshold);
        if (this.m_wizardStepState.getState() == StepStateType.VALIDATED) {
            this.m_wizardStepState.setState(StepStateType.DIRTY);
        }
    }
}

