/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.miningsteps;

import java.util.Vector;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.ProgressBar;
import oracle.dmt.dm4j.wizard.director.minings.AttributeExtractProcess;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.minings.ClassificationModelBuildState;
import oracle.dmt.dm4j.wizard.state.minings.ExplainState;
import oracle.dmt.dm4j.wizard.state.minings.FeatureExtractionModelBuildState;
import oracle.dmt.dm4j.wizard.state.minings.PredictState;
import oracle.dmt.dm4j.wizard.state.minings.RegressionModelBuildState;
import oracle.dmt.dm4j.wizard.state.minings.WizardState;
import oracle.dmt.dm4j.wizard.state.minings.WizardStepState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ClassificationAlgorithmState;
import oracle.dmt.dm4j.wizard.state.miningsteps.DataState;
import oracle.dmt.dm4j.wizard.state.miningsteps.RegressionAlgorithmState;
import oracle.dmt.dm4j.wizard.steps.minings.DM4JPage;
import oracle.dmt.dm4j.wizard.steps.minings.StepType;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.dm4j.wizard.validation.miningsteps.DataUsageError;

public class ModelDataState
extends DataState {
    public ModelDataState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
    }

    public boolean preload() throws Exception {
        boolean bl = true;
        return bl;
    }

    protected void loadOld() throws Exception {
        super.loadOld();
    }

    protected void loadNew() throws Exception {
        super.loadNew();
        this.loadDefaultValues();
    }

    protected void refreshOld() throws Exception {
        super.loadOld();
    }

    protected void refreshNew() throws Exception {
        super.loadNew();
        this.loadDefaultValues();
    }

    private void validateSynchronizeModelBuildData(Vector vector) throws Exception {
        WizardState wizardState = (WizardState)this.getparentWizardState();
        wizardState.synchronize(vector, this);
    }

    private int getModelType() {
        WizardStepState wizardStepState = (WizardStepState)this.getparentWizardState().getStep(StepType.ALGORITHM_STEP);
        if (wizardStepState instanceof ClassificationAlgorithmState) {
            return 2;
        }
        if (wizardStepState instanceof RegressionAlgorithmState) {
            return 1;
        }
        return 2;
    }

    public void validate(Vector vector) throws Exception {
        super.validate(vector);
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        } else {
            this.setState(StepStateType.DIRTY);
        }
    }

    protected void loadDefaultValues() {
    }

    public Vector getInEligibleTargetAttributes() {
        return this.m_ldsDataSource.getInEligibleTargetAttributeIndexes(this.getModelType());
    }

    public String getFirstQualifyingTargetAttribute() {
        String[] stringArray = new String[]{"NUMBER", "VARCHAR2", "CHAR", "FLOAT"};
        return this.m_ldsDataSource.getFirstQualifyingAttributeWithDataType(stringArray);
    }

    public Vector getAttributesFromLDSDataSource(boolean bl, boolean bl2) {
        return this.m_ldsDataSource.getAttributes(bl, bl2, this.getModelType());
    }

    public int getActiveAttributeCountExcludingTargets() {
        return this.m_ldsDataSource.getActiveAttributeCountExcludingTargets();
    }

    public int getActiveAttributeCountIncludingTargets() {
        return this.m_ldsDataSource.getActiveAttributeCountIncludingTargets();
    }

    public boolean postValidate(Vector vector) throws Exception {
        boolean bl = true;
        AttributeExtractProcess attributeExtractProcess = null;
        try {
            WizardState wizardState = (WizardState)this.getparentWizardState();
            if (wizardState.isNew()) {
                boolean bl2 = wizardState instanceof ClassificationModelBuildState || wizardState instanceof RegressionModelBuildState || wizardState instanceof FeatureExtractionModelBuildState;
                attributeExtractProcess = new AttributeExtractProcess(this, false, bl2, true);
                ProgressBar progressBar = new ProgressBar(BrowserFrame.getMainFrame(), ResourceUtilities.getUILabel("ATTRIBUTE_EXTRACT_DIALOG_TITLE"), attributeExtractProcess, true);
                attributeExtractProcess.setProgressBar(progressBar);
                progressBar.start(ResourceUtilities.getUILabel("ATTRIBUTE_EXTRACT_DIALOG_TITLE"), ResourceUtilities.getUILabel("ATTRIBUTE_EXTRACT_DESCRIPTION"));
                if (attributeExtractProcess.getException() != null) {
                    this.getparentWizardState().doAbortCancel(attributeExtractProcess.getException());
                } else if (progressBar.hasUserCancelled()) {
                    bl = false;
                    this.setState(StepStateType.DIRTY);
                    return bl;
                }
            } else {
                bl = ((WizardState)this.getparentWizardState()).synchronize(vector, this);
                if (!bl) {
                    this.setState(StepStateType.DIRTY);
                }
                if (bl) {
                    int n = this.getparentWizardState().getWizard().getCurrentPageIndex();
                    for (int i = n + 1; i < this.getparentWizardState().getWizard().getPageCount(); ++i) {
                        DM4JPage dM4JPage = (DM4JPage)this.getparentWizardState().getWizard().getPageAt(i);
                        dM4JPage.refresh();
                    }
                }
            }
        }
        catch (Exception exception) {
            this.getparentWizardState().doAbortCancel(exception);
        }
        if (this.getparentWizardState() instanceof PredictState || this.getparentWizardState() instanceof ExplainState) {
            this.validateAttributeDataTypes(vector);
            if (!ValidationUtil.validationsContainsErrors(vector)) {
                this.setState(StepStateType.VALIDATED);
            } else {
                this.setState(StepStateType.DIRTY);
                bl = false;
            }
        }
        return bl;
    }

    public void validateAttributeDataTypes(Vector vector) throws Exception {
        boolean bl = true;
        if (this.getparentWizardState() instanceof PredictState || this.getparentWizardState() instanceof ExplainState) {
            bl = false;
            for (int i = 0; i < this.getLDSDataSource().getRowCount(); ++i) {
                Boolean bl2 = (Boolean)this.getLDSDataSource().getData(0, i);
                String string = (String)this.getLDSDataSource().getData(2, i);
                if (string.equals("FLOAT") || string.equals("NUMBER") || string.equals("DATE") || string.equals("CHAR") || string.equals("VARCHAR2") || string.equals("TIMESTAMP")) continue;
                if (bl) {
                    if (string.equals("DM_NESTED_NUMERICALS") || string.equals("DM_NESTED_CATEGORICALS")) continue;
                    vector.add(new StateValidation(DataUsageError.DATA_USAGE_DATA_TYPE_INVALID));
                    this.getLDSDataSource().setData(0, i, Boolean.FALSE);
                    this.getLDSDataSource().setData(8, i, Boolean.FALSE);
                    continue;
                }
                vector.add(new StateValidation(DataUsageError.DATA_USAGE_DATA_TYPE_INVALID3));
                this.getLDSDataSource().setData(0, i, Boolean.FALSE);
                this.getLDSDataSource().setData(8, i, Boolean.FALSE);
            }
        } else {
            for (int i = 0; i < this.getLDSDataSource().getRowCount(); ++i) {
                Boolean bl3 = (Boolean)this.getLDSDataSource().getData(0, i);
                String string = (String)this.getLDSDataSource().getData(2, i);
                if (!bl3.booleanValue() || string.equals("FLOAT") || string.equals("NUMBER") || string.equals("DATE") || string.equals("CHAR") || string.equals("VARCHAR2") || string.equals("TIMESTAMP")) continue;
                if (bl) {
                    if (string.equals("DM_NESTED_NUMERICALS") || string.equals("DM_NESTED_CATEGORICALS")) continue;
                    vector.add(new StateValidation(DataUsageError.DATA_USAGE_DATA_TYPE_INVALID));
                    this.getLDSDataSource().setData(0, i, Boolean.FALSE);
                    this.getLDSDataSource().setData(8, i, Boolean.FALSE);
                    continue;
                }
                vector.add(new StateValidation(DataUsageError.DATA_USAGE_DATA_TYPE_INVALID3));
                this.getLDSDataSource().setData(0, i, Boolean.FALSE);
                this.getLDSDataSource().setData(8, i, Boolean.FALSE);
            }
        }
    }
}

