/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.miningsteps;

import java.sql.SQLException;
import java.util.Vector;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.browser.LaunchPoint;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.minings.WizardState;
import oracle.dmt.dm4j.wizard.state.minings.WizardStepState;
import oracle.dmt.dm4j.wizard.steps.minings.StepType;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.dm4j.wizard.validation.miningsteps.NameStateError;

public class ModelApplyNameState
extends WizardStepState {
    private final int NAME_LENGTH_MAX = 25;
    private final String NAME_SUFFIX = "";
    protected StringBuffer m_modelApplyName = new StringBuffer(0);

    public ModelApplyNameState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
    }

    public String getModelApplyName() {
        return this.m_modelApplyName.toString();
    }

    public void setModelApplyName(String string) {
        String string2;
        if (string != null && !string.equals(string2 = this.m_modelApplyName.toString())) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_modelApplyName = new StringBuffer(string);
        }
    }

    protected void loadOld() throws Exception {
        this.loadNew();
    }

    protected void loadNew() throws Exception {
        this.loadDefaultModelApplyName();
    }

    public boolean preload() throws Exception {
        boolean bl = true;
        return bl;
    }

    public boolean postValidate(Vector vector) throws Exception {
        boolean bl = true;
        return bl;
    }

    protected void refreshOld() throws Exception {
    }

    protected void refreshNew() throws Exception {
    }

    public void validate(Vector vector) throws Exception {
        this.validateModelApplyName(vector);
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        }
    }

    private void validateModelApplyName(Vector vector) throws Exception {
        String[] stringArray;
        String string;
        if (this.m_modelApplyName.length() == 0) {
            string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            stringArray = new String[]{ResourceUtilities.getUILabel("MODEL_APPLY_NAME")};
            vector.add(new StateValidation(NameStateError.MODEL_APPLY_NAME_EMPTY, string, stringArray));
        }
        if (!ValidationUtil.checkStringLength(this.m_modelApplyName.toString(), 25)) {
            string = ResourceUtilities.getstateExceptionMessage("MAXIMUM_LENGTH_EXCEEDED");
            stringArray = new String[]{ResourceUtilities.getUILabel("MODEL_APPLY_NAME"), Integer.toString(25)};
            vector.add(new StateValidation(NameStateError.MODEL_APPLY_NAME_EXCEEDS_MAXIMUM_LENGTH, string, stringArray));
        }
        if (!ValidationUtil.containsOnlyValidDBNameCharacters(this.m_modelApplyName.toString())) {
            vector.add(new StateValidation(NameStateError.MODEL_NAME_INVALID));
        }
    }

    protected void loadDefaultModelApplyName() throws SQLException {
        String string;
        String string2 = ((WizardState)this.getparentWizardState()).getDefaultModelName();
        int n = 30;
        BrowserContext browserContext = this.getparentWizardState().getBrowserContext();
        String string3 = null;
        if (browserContext.getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE)) {
            string3 = browserContext.getActivity().getCaseTable().getName();
        }
        if (string3 == null) {
            string3 = string2;
        }
        if (ValidationUtil.isValidNonQuotedDBObjectName(string = ValidationUtil.createUniqueTableName(string3 = string3.length() > n ? string3.substring(0, n) : string3, ((WizardState)this.getparentWizardState()).getConnection(), "_A"))) {
            this.setModelApplyName(string);
        } else {
            this.setModelApplyName(DM4JStringUtils.addDoubleQuotes(string));
        }
    }
}

