/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.miningsteps;

import java.util.Vector;
import oracle.dmt.dm4j.activity.steps.GLMBuildStepOptions;
import oracle.dmt.dm4j.activity.steps.GLMCBuildStepOptions;
import oracle.dmt.dm4j.activity.steps.GLMRBuildStepOptions;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.browser.LaunchPoint;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.miningsteps.AlgorithmSettingState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ClassificationAlgorithmState;
import oracle.dmt.dm4j.wizard.state.miningsteps.RegressionAlgorithmState;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.miningsteps.GeneralizedLinearAlgorithmStateError;

public class GeneralizedLinearModelAlgorithmState
extends AlgorithmSettingState {
    private Double m_confidenceLevel;
    private Double m_defaultConfidenceLevel;
    private boolean m_diagnosticsTableEnabled;
    private boolean m_defaultDiagnosticsTableEnabled;
    private boolean m_ridgeRegressionEnabled;
    private boolean m_defaultRidgeRegressionEnabled;
    private Double m_ridgeValue;
    private Double m_defaultRidgeValue;
    private boolean m_ridgeVIFEnabled;
    private boolean m_defaultRidgeVIFEnabled;
    private Object m_referenceTargetClass;
    private Object m_defaultReferenceTargetClass;
    private GLMBuildStepOptions m_options = null;

    public GeneralizedLinearModelAlgorithmState(ClassificationAlgorithmState classificationAlgorithmState, Double d, boolean bl, boolean bl2, Double d2, Object object) {
        super(classificationAlgorithmState);
        this.initialize(d, bl, bl2, d2, false, object);
    }

    public GeneralizedLinearModelAlgorithmState(Double d, boolean bl, boolean bl2, Double d2, Object object) {
        this.initialize(d, bl, bl2, d2, false, object);
    }

    public GeneralizedLinearModelAlgorithmState(RegressionAlgorithmState regressionAlgorithmState, Double d, boolean bl, boolean bl2, Double d2, boolean bl3) {
        super(regressionAlgorithmState);
        this.initialize(d, bl, bl2, d2, bl3, null);
    }

    public GeneralizedLinearModelAlgorithmState(Double d, boolean bl, boolean bl2, Double d2, boolean bl3) {
        this.initialize(d, bl, bl2, d2, bl3, null);
    }

    private void initialize(Double d, boolean bl, boolean bl2, Double d2, boolean bl3, Object object) {
        BrowserContext browserContext = this.m_wizardStepState.getparentWizardState().getBrowserContext();
        if (browserContext.getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE) && browserContext.getOptions() instanceof GLMBuildStepOptions) {
            this.m_options = (GLMBuildStepOptions)browserContext.getOptions();
        }
        if (this.m_options != null) {
            this.m_confidenceLevel = this.m_options.getConfidenceLevel();
            this.m_diagnosticsTableEnabled = this.m_options.isDiagnosticsTableEnabled();
            this.m_ridgeValue = this.m_options.getRidgeValue();
            this.m_ridgeRegressionEnabled = this.m_options.isRidgeRegressionEnabled();
            if (this.m_options instanceof GLMRBuildStepOptions) {
                this.m_ridgeVIFEnabled = ((GLMRBuildStepOptions)this.m_options).isRidgeVIFEnabled();
            }
            if (this.m_options instanceof GLMCBuildStepOptions) {
                this.m_referenceTargetClass = ((GLMCBuildStepOptions)this.m_options).getReferenceTargetClass();
            }
        } else {
            this.m_confidenceLevel = d;
            this.m_diagnosticsTableEnabled = bl;
            this.m_ridgeValue = d2;
            this.m_ridgeRegressionEnabled = bl2;
            this.m_ridgeVIFEnabled = bl3;
        }
        this.m_defaultConfidenceLevel = d;
        this.m_defaultDiagnosticsTableEnabled = bl;
        this.m_defaultRidgeRegressionEnabled = bl2;
        this.m_defaultRidgeValue = d2;
        this.m_defaultRidgeVIFEnabled = bl3;
        this.m_defaultReferenceTargetClass = object;
    }

    public void setConfidenceLevel(Double d) {
        if (this.m_confidenceLevel == null || d == null || this.m_confidenceLevel.compareTo(d) != 0) {
            if (this.m_wizardStepState.getState() == StepStateType.VALIDATED) {
                this.m_wizardStepState.setState(StepStateType.DIRTY);
            }
            this.m_confidenceLevel = d;
            if (this.m_options != null) {
                this.m_options.setConfidenceLevel(d);
            }
        }
    }

    public Double getConfidenceLevel() {
        return this.m_confidenceLevel;
    }

    public boolean isDiagnosticsTableEnabled() {
        return this.m_diagnosticsTableEnabled;
    }

    public void setDiagnosticsTableEnabled(boolean bl) {
        if (this.m_diagnosticsTableEnabled != bl) {
            if (this.m_wizardStepState.getState() == StepStateType.VALIDATED) {
                this.m_wizardStepState.setState(StepStateType.DIRTY);
            }
            this.m_diagnosticsTableEnabled = bl;
            if (this.m_options != null) {
                this.m_options.setDiagnosticsTableEnabled(bl);
            }
        }
    }

    public void setRidgeValue(Double d) {
        if (this.m_ridgeValue == null || d == null || this.m_ridgeValue.compareTo(d) != 0) {
            if (this.m_wizardStepState.getState() == StepStateType.VALIDATED) {
                this.m_wizardStepState.setState(StepStateType.DIRTY);
            }
            this.m_ridgeValue = d;
            if (this.m_options != null) {
                this.m_options.setRidgeValue(d);
            }
        }
    }

    public Double getRidgeValue() {
        return this.m_ridgeValue;
    }

    public void setReferenceTargetClass(Object object) {
        if (this.m_referenceTargetClass == null || object == null || !this.m_referenceTargetClass.equals(object)) {
            if (this.m_wizardStepState.getState() == StepStateType.VALIDATED) {
                this.m_wizardStepState.setState(StepStateType.DIRTY);
            }
            this.m_referenceTargetClass = object;
            if (this.m_options != null) {
                ((GLMCBuildStepOptions)this.m_options).setReferenceTargetClass(object);
            }
        }
    }

    public Object getReferenceTargetClass() {
        return this.m_referenceTargetClass;
    }

    public boolean isRidgeRegressionEnabled() {
        return this.m_ridgeRegressionEnabled;
    }

    public void setRidgeRegressionEnabled(boolean bl) {
        if (this.m_ridgeRegressionEnabled != bl) {
            if (this.m_wizardStepState.getState() == StepStateType.VALIDATED) {
                this.m_wizardStepState.setState(StepStateType.DIRTY);
            }
            this.m_ridgeRegressionEnabled = bl;
            if (this.m_options != null) {
                this.m_options.setRidgeRegressionEnabled(bl);
            }
        }
    }

    public boolean isRidgeVIFEnabled() {
        return this.m_ridgeVIFEnabled;
    }

    public void setRidgeVIFEnabled(boolean bl) {
        if (this.m_ridgeVIFEnabled != bl) {
            if (this.m_wizardStepState.getState() == StepStateType.VALIDATED) {
                this.m_wizardStepState.setState(StepStateType.DIRTY);
            }
            this.m_ridgeVIFEnabled = bl;
            if (this.m_options != null) {
                ((GLMRBuildStepOptions)this.m_options).setRidgeVIFEnabled(bl);
            }
        }
    }

    protected void validateConfidenceLevel(Vector vector) throws Exception {
        if (this.m_confidenceLevel == null) {
            String string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            String[] stringArray = new String[]{ResourceUtilities.getUILabel("ALGO_GLM_CONFIDENCE_LEVEL")};
            vector.add(new StateValidation(GeneralizedLinearAlgorithmStateError.ALGO_GLM_CONFIDENCE_LEVEL_EMPTY, string, stringArray));
        } else if (this.m_confidenceLevel <= 0.0 || this.m_confidenceLevel >= 1.0) {
            vector.add(new StateValidation(GeneralizedLinearAlgorithmStateError.ALGO_GLM_CONFIDENCE_LEVEL_INVALID));
        }
    }

    protected void validateRidgeValue(Vector vector) throws Exception {
        if (this.m_ridgeValue != null && this.m_ridgeValue <= 0.0) {
            vector.add(new StateValidation(GeneralizedLinearAlgorithmStateError.ALGO_GLM_RIDGE_VALUE_INVALID));
        }
    }

    public void validate(Vector vector) throws Exception {
        if (this.isRidgeRegressionEnabled()) {
            this.validateRidgeValue(vector);
        }
        this.validateConfidenceLevel(vector);
    }

    public Vector validate() throws Exception {
        Vector vector = new Vector();
        this.validate(vector);
        return vector;
    }

    public void restoreSettingsToDefault() {
        this.setConfidenceLevel(this.m_defaultConfidenceLevel);
        this.setDiagnosticsTableEnabled(this.m_defaultDiagnosticsTableEnabled);
        this.setReferenceTargetClass(this.m_defaultReferenceTargetClass);
        this.setRidgeRegressionEnabled(this.m_defaultRidgeRegressionEnabled);
        this.setRidgeVIFEnabled(this.m_defaultRidgeVIFEnabled);
        this.setRidgeValue(this.m_defaultRidgeValue);
        if (this.m_wizardStepState.getState() == StepStateType.VALIDATED) {
            this.m_wizardStepState.setState(StepStateType.DIRTY);
        }
    }
}

