/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.miningsteps;

import java.sql.SQLException;
import java.util.Vector;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.minings.ClassificationModelApplyState;
import oracle.dmt.dm4j.wizard.state.minings.ClassificationModelBuildState;
import oracle.dmt.dm4j.wizard.state.minings.ClassificationModelLiftState;
import oracle.dmt.dm4j.wizard.state.minings.ExplainState;
import oracle.dmt.dm4j.wizard.state.minings.ModelBuildState;
import oracle.dmt.dm4j.wizard.state.minings.PredictState;
import oracle.dmt.dm4j.wizard.state.minings.RegressionModelTestState;
import oracle.dmt.dm4j.wizard.state.minings.WizardState;
import oracle.dmt.dm4j.wizard.state.minings.WizardStepState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ApplyCostMatrixState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ClassificationTestMetricsOptionsState;
import oracle.dmt.dm4j.wizard.state.miningsteps.DataState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ModelLiftNameState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ModelNameState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ModelState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ModelTargetValueState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ModelTestNameState;
import oracle.dmt.dm4j.wizard.state.miningsteps.TargetValueState;
import oracle.dmt.dm4j.wizard.state.miningsteps.TestTargetValueState;
import oracle.dmt.dm4j.wizard.steps.minings.StepType;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.dm4j.wizard.validation.miningsteps.NameStateError;

public class FinishState
extends WizardStepState {
    private final int VIEW_NAME_LENGTH_MAX = 30;
    private final int RESULT_NAME_LENGTH_MAX = 25;
    private String m_objectName = null;
    private StringBuffer m_dataUsageViewName = new StringBuffer(0);
    private StringBuffer m_settingName = new StringBuffer(0);
    private StringBuffer m_costMatrixName = new StringBuffer(0);
    private StringBuffer m_confustionMatrixName = new StringBuffer(0);
    private StringBuffer m_ROCName = new StringBuffer(0);
    private StringBuffer m_liftName = new StringBuffer(0);
    private boolean m_enableDataUsageView = false;
    private boolean m_enableCostMatrix = false;
    private boolean m_enableConfusionMatrix = false;
    private boolean m_enableROC = false;
    private boolean m_enableLift = false;

    public FinishState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
    }

    public String getObjectName() {
        return this.m_objectName;
    }

    public boolean isDataUsageViewEnabled() {
        return this.m_enableDataUsageView;
    }

    public boolean isCostMatrixEnabled() {
        return this.m_enableCostMatrix;
    }

    public boolean isConfusionMatrixEnabled() {
        return this.m_enableConfusionMatrix;
    }

    public boolean isROCEnabled() {
        return this.m_enableROC;
    }

    public boolean isLiftEnabled() {
        return this.m_enableLift;
    }

    protected void loadDefaultNames() throws SQLException {
        String string;
        DataState dataState = (DataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
        String string2 = ValidationUtil.addPrefixToName("DM4J$", dataState.getSelectedTableName());
        String string3 = ValidationUtil.createUniqueJDMObjectName(string2, ((WizardState)this.getparentWizardState()).getConnection(), "_B");
        if (ValidationUtil.isValidNonQuotedDBObjectName(string3)) {
            this.setMiningSettingsName(string3);
        } else {
            this.setMiningSettingsName(DM4JStringUtils.addDoubleQuotes(string3));
        }
        if (this.m_enableDataUsageView) {
            string = dataState.getSelectedTableName();
            if (ValidationUtil.isValidNonQuotedDBObjectName(string = ValidationUtil.createUniqueTableName(string, ((WizardState)this.getparentWizardState()).getConnection(), "_U"))) {
                this.setDataUsageViewName(string);
            } else {
                this.setDataUsageViewName(DM4JStringUtils.addDoubleQuotes(string));
            }
        }
        if (this.m_enableCostMatrix) {
            string = ValidationUtil.createUniqueJDMObjectName(string2, ((WizardState)this.getparentWizardState()).getConnection(), "_C");
            if (ValidationUtil.isValidNonQuotedDBObjectName(string)) {
                this.setCostMatrixName(string);
            } else {
                this.setCostMatrixName(DM4JStringUtils.addDoubleQuotes(string));
            }
        }
        if (this.m_enableConfusionMatrix) {
            string = ValidationUtil.createUniqueJDMObjectName(string2, ((WizardState)this.getparentWizardState()).getConnection(), "_M");
            if (ValidationUtil.isValidNonQuotedDBObjectName(string)) {
                this.setConfustionMatrixName(string);
            } else {
                this.setConfustionMatrixName(DM4JStringUtils.addDoubleQuotes(string));
            }
        }
        if (this.m_enableROC) {
            string = ValidationUtil.createUniqueJDMObjectName(string2, ((WizardState)this.getparentWizardState()).getConnection(), "_R");
            if (ValidationUtil.isValidNonQuotedDBObjectName(string)) {
                this.setROCName(string);
            } else {
                this.setROCName(DM4JStringUtils.addDoubleQuotes(string));
            }
        }
        if (this.m_enableLift) {
            string = ValidationUtil.createUniqueJDMObjectName(string2, ((WizardState)this.getparentWizardState()).getConnection(), "_L");
            if (ValidationUtil.isValidNonQuotedDBObjectName(string)) {
                this.setLiftName(string);
            } else {
                this.setLiftName(DM4JStringUtils.addDoubleQuotes(string));
            }
        }
    }

    public void loadDefault() throws Exception {
        WizardStepState wizardStepState;
        Object object;
        WizardStepState wizardStepState2 = (WizardStepState)this.getparentWizardState().getStep(StepType.NAME_STEP);
        if (wizardStepState2 instanceof ModelNameState) {
            this.m_objectName = ((ModelNameState)wizardStepState2).getModelName();
        } else if (wizardStepState2 instanceof ModelTestNameState) {
            this.m_objectName = ((ModelTestNameState)wizardStepState2).getModelTestName();
        } else if (wizardStepState2 instanceof ModelLiftNameState) {
            this.m_objectName = ((ModelLiftNameState)wizardStepState2).getTestMetricName();
        }
        if (wizardStepState2 == null) {
            object = (ModelState)this.getparentWizardState().getStep(StepType.MODEL_STEP);
            this.m_objectName = ((ModelState)object).getSelectedModelName() + " Apply";
        }
        this.m_enableDataUsageView = false;
        this.m_enableCostMatrix = false;
        this.m_enableConfusionMatrix = false;
        this.m_enableROC = false;
        this.m_enableLift = false;
        if (this.getparentWizardState() instanceof ModelBuildState || this.getparentWizardState() instanceof ClassificationModelLiftState || this.getparentWizardState() instanceof RegressionModelTestState) {
            object = (DataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
            this.m_enableDataUsageView = ((DataState)object).getLDSDataSource().isDirty();
        }
        if (this.getparentWizardState() instanceof ClassificationModelBuildState) {
            object = (ClassificationModelBuildState)this.getparentWizardState();
            wizardStepState = (ModelTargetValueState)((oracle.dmt.dm4j.wizard.state.WizardState)object).getStep(StepType.TARGET_VALUE_STEP);
            this.m_enableCostMatrix = ((TargetValueState)wizardStepState).getWeightedScoreIndicator();
        }
        if (this.getparentWizardState() instanceof ClassificationModelLiftState) {
            object = (ClassificationModelLiftState)this.getparentWizardState();
            wizardStepState = (TestTargetValueState)((oracle.dmt.dm4j.wizard.state.WizardState)object).getStep(StepType.TARGET_VALUE_STEP);
            ClassificationTestMetricsOptionsState classificationTestMetricsOptionsState = (ClassificationTestMetricsOptionsState)((oracle.dmt.dm4j.wizard.state.WizardState)object).getStep(StepType.TM_OPTIONS_STEP);
            this.m_enableCostMatrix = ((TestTargetValueState)wizardStepState).getWeightedScoreIndicator();
            this.m_enableConfusionMatrix = classificationTestMetricsOptionsState.IsGenerateTest();
            this.m_enableROC = classificationTestMetricsOptionsState.IsGenerateROC();
            this.m_enableLift = classificationTestMetricsOptionsState.IsGenerateLift();
        }
        if (this.getparentWizardState() instanceof ClassificationModelApplyState) {
            object = (ClassificationModelApplyState)this.getparentWizardState();
            wizardStepState = (ApplyCostMatrixState)((oracle.dmt.dm4j.wizard.state.WizardState)object).getStep(StepType.TARGET_VALUE_STEP);
            boolean bl = this.m_enableCostMatrix = ((ApplyCostMatrixState)wizardStepState).getCostMatrixName() != null;
        }
        if (this.getparentWizardState() instanceof PredictState || this.getparentWizardState() instanceof ExplainState) {
            this.m_enableDataUsageView = false;
        }
        this.loadDefaultNames();
    }

    protected void refreshOld() throws Exception {
        this.refreshNew();
    }

    protected void refreshNew() throws Exception {
        this.loadNew();
    }

    protected void loadNew() throws Exception {
        this.loadDefault();
    }

    protected void loadOld() throws Exception {
        this.loadNew();
    }

    public String getDataUsageViewName() {
        return this.m_dataUsageViewName.toString().length() > 0 ? this.m_dataUsageViewName.toString() : null;
    }

    public String getMiningSettingsName() {
        return this.m_settingName.toString().length() > 0 ? this.m_settingName.toString() : null;
    }

    public String getCostMatrixName() {
        return this.m_costMatrixName.toString().length() > 0 ? this.m_costMatrixName.toString() : null;
    }

    public String getConfustionMatrixName() {
        return this.m_confustionMatrixName.toString().length() > 0 ? this.m_confustionMatrixName.toString() : null;
    }

    public String getROCName() {
        return this.m_ROCName.toString().length() > 0 ? this.m_ROCName.toString() : null;
    }

    public String getLiftName() {
        return this.m_liftName.toString().length() > 0 ? this.m_liftName.toString() : null;
    }

    public void setDataUsageViewName(String string) {
        if (string != null) {
            String string2;
            if (!DM4JStringUtils.isDoubleQuotedString(string)) {
                string = string.toUpperCase();
            }
            if (!string.equals(string2 = this.m_dataUsageViewName.toString())) {
                if (this.getState() == StepStateType.VALIDATED) {
                    this.setState(StepStateType.DIRTY);
                }
                this.m_dataUsageViewName = new StringBuffer(string);
            }
        }
    }

    public void setMiningSettingsName(String string) {
        if (string != null) {
            String string2;
            if (!DM4JStringUtils.isDoubleQuotedString(string)) {
                string = string.toUpperCase();
            }
            if (!string.equals(string2 = this.m_settingName.toString())) {
                if (this.getState() == StepStateType.VALIDATED) {
                    this.setState(StepStateType.DIRTY);
                }
                this.m_settingName = new StringBuffer(string);
            }
        }
    }

    public void setCostMatrixName(String string) {
        if (string != null) {
            String string2;
            if (!DM4JStringUtils.isDoubleQuotedString(string)) {
                string = string.toUpperCase();
            }
            if (!string.equals(string2 = this.m_costMatrixName.toString())) {
                if (this.getState() == StepStateType.VALIDATED) {
                    this.setState(StepStateType.DIRTY);
                }
                this.m_costMatrixName = new StringBuffer(string);
            }
        }
    }

    public void setConfustionMatrixName(String string) {
        if (string != null) {
            String string2;
            if (!DM4JStringUtils.isDoubleQuotedString(string)) {
                string = string.toUpperCase();
            }
            if (!string.equals(string2 = this.m_confustionMatrixName.toString())) {
                if (this.getState() == StepStateType.VALIDATED) {
                    this.setState(StepStateType.DIRTY);
                }
                this.m_confustionMatrixName = new StringBuffer(string);
            }
        }
    }

    public void setROCName(String string) {
        if (string != null) {
            String string2;
            if (!DM4JStringUtils.isDoubleQuotedString(string)) {
                string = string.toUpperCase();
            }
            if (!string.equals(string2 = this.m_ROCName.toString())) {
                if (this.getState() == StepStateType.VALIDATED) {
                    this.setState(StepStateType.DIRTY);
                }
                this.m_ROCName = new StringBuffer(string);
            }
        }
    }

    public void setLiftName(String string) {
        if (string != null) {
            String string2;
            if (!DM4JStringUtils.isDoubleQuotedString(string)) {
                string = string.toUpperCase();
            }
            if (!string.equals(string2 = this.m_liftName.toString())) {
                if (this.getState() == StepStateType.VALIDATED) {
                    this.setState(StepStateType.DIRTY);
                }
                this.m_liftName = new StringBuffer(string);
            }
        }
    }

    public boolean postValidate(Vector vector) throws Exception {
        boolean bl = true;
        return bl;
    }

    public boolean preload() throws Exception {
        boolean bl = true;
        return bl;
    }

    public void validateDataUsageViewName(Vector vector) throws Exception {
        String[] stringArray;
        String string;
        boolean bl = DM4JStringUtils.isDoubleQuotedString(this.m_dataUsageViewName.toString());
        String string2 = this.m_dataUsageViewName.toString();
        if (bl) {
            string2 = DM4JStringUtils.trimDoubleQuotes(string2);
        }
        if (string2.length() == 0) {
            string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            stringArray = new String[]{ResourceUtilities.getUILabel("DATA_USAGE_VIEW_NAME")};
            vector.add(new StateValidation(NameStateError.DATA_USAGE_VIEW_NAME_EMPTY, string, stringArray));
        }
        if (!ValidationUtil.checkStringLength(string2, 30)) {
            string = ResourceUtilities.getstateExceptionMessage("MAXIMUM_LENGTH_EXCEEDED");
            stringArray = new String[]{ResourceUtilities.getUILabel("DATA_USAGE_VIEW_NAME"), Integer.toString(30)};
            vector.add(new StateValidation(NameStateError.DATA_USAGE_VIEW_NAME_EXCEEDS_MAXIMUM_LENGTH, string, stringArray));
        }
        if (!ValidationUtil.isTableNameUnique(string2, ((WizardState)this.getparentWizardState()).getConnection())) {
            vector.add(new StateValidation(NameStateError.DATA_USAGE_VIEW_NAME_DUPLICATE));
        }
        if (!bl && !ValidationUtil.isValidNonQuotedDBObjectName(string2)) {
            vector.add(new StateValidation(NameStateError.DATAMINING_NAME_INVALID_DB_OBJECT_NAME));
        }
    }

    public void validateCostMatrixName(Vector vector) throws Exception {
        String[] stringArray;
        String string;
        boolean bl = DM4JStringUtils.isDoubleQuotedString(this.m_costMatrixName.toString());
        String string2 = this.m_costMatrixName.toString();
        if (bl) {
            string2 = DM4JStringUtils.trimDoubleQuotes(string2);
        }
        if (string2.length() == 0) {
            string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            stringArray = new String[]{ResourceUtilities.getUILabel("COST_MATRIX_NAME")};
            vector.add(new StateValidation(NameStateError.COST_MATRIX_NAME_EMPTY, string, stringArray));
        }
        if (!ValidationUtil.checkStringLength(string2, 25)) {
            string = ResourceUtilities.getstateExceptionMessage("MAXIMUM_LENGTH_EXCEEDED");
            stringArray = new String[]{ResourceUtilities.getUILabel("COST_MATRIX_NAME"), Integer.toString(25)};
            vector.add(new StateValidation(NameStateError.COST_MATRIX_NAME_EXCEEDS_MAXIMUM_LENGTH, string, stringArray));
        }
        if (!ValidationUtil.isTableNameUnique(string2, ((WizardState)this.getparentWizardState()).getConnection())) {
            vector.add(new StateValidation(NameStateError.COST_MATRIX_NAME_DUPLICATE));
        }
        if (!bl && !ValidationUtil.isValidNonQuotedDBObjectName(string2)) {
            vector.add(new StateValidation(NameStateError.DATAMINING_NAME_INVALID_DB_OBJECT_NAME));
        }
    }

    public void validateConfusionMatrixName(Vector vector) throws Exception {
        String[] stringArray;
        String string;
        boolean bl = DM4JStringUtils.isDoubleQuotedString(this.m_confustionMatrixName.toString());
        String string2 = this.m_confustionMatrixName.toString();
        if (bl) {
            string2 = DM4JStringUtils.trimDoubleQuotes(string2);
        }
        if (string2.length() == 0) {
            string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            stringArray = new String[]{ResourceUtilities.getUILabel("CONFUSION_MATRIX_NAME")};
            vector.add(new StateValidation(NameStateError.CONFUSION_MATRIX_NAME_EMPTY, string, stringArray));
        }
        if (!ValidationUtil.checkStringLength(string2, 25)) {
            string = ResourceUtilities.getstateExceptionMessage("MAXIMUM_LENGTH_EXCEEDED");
            stringArray = new String[]{ResourceUtilities.getUILabel("CONFUSION_MATRIX_NAME"), Integer.toString(25)};
            vector.add(new StateValidation(NameStateError.CONFUSION_MATRIX_NAME_EXCEEDS_MAXIMUM_LENGTH, string, stringArray));
        }
        if (!ValidationUtil.isTableNameUnique(string2, ((WizardState)this.getparentWizardState()).getConnection())) {
            vector.add(new StateValidation(NameStateError.CONFUSION_MATRIX_NAME_DUPLICATE));
        }
        if (!bl && !ValidationUtil.isValidNonQuotedDBObjectName(string2)) {
            vector.add(new StateValidation(NameStateError.DATAMINING_NAME_INVALID_DB_OBJECT_NAME));
        }
    }

    public void validateROCName(Vector vector) throws Exception {
        String[] stringArray;
        String string;
        boolean bl = DM4JStringUtils.isDoubleQuotedString(this.m_ROCName.toString());
        String string2 = this.m_ROCName.toString();
        if (bl) {
            string2 = DM4JStringUtils.trimDoubleQuotes(string2);
        }
        if (string2.length() == 0) {
            string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            stringArray = new String[]{ResourceUtilities.getUILabel("ROC_NAME")};
            vector.add(new StateValidation(NameStateError.ROC_NAME_EMPTY, string, stringArray));
        }
        if (!ValidationUtil.checkStringLength(string2, 25)) {
            string = ResourceUtilities.getstateExceptionMessage("MAXIMUM_LENGTH_EXCEEDED");
            stringArray = new String[]{ResourceUtilities.getUILabel("ROC_NAME"), Integer.toString(25)};
            vector.add(new StateValidation(NameStateError.ROC_NAME_EXCEEDS_MAXIMUM_LENGTH, string, stringArray));
        }
        if (!ValidationUtil.isTableNameUnique(string2, ((WizardState)this.getparentWizardState()).getConnection())) {
            vector.add(new StateValidation(NameStateError.ROC_NAME_DUPLICATE));
        }
        if (!bl && !ValidationUtil.isValidNonQuotedDBObjectName(string2)) {
            vector.add(new StateValidation(NameStateError.DATAMINING_NAME_INVALID_DB_OBJECT_NAME));
        }
    }

    public void validateLiftName(Vector vector) throws Exception {
        String[] stringArray;
        String string;
        boolean bl = DM4JStringUtils.isDoubleQuotedString(this.m_liftName.toString());
        String string2 = this.m_liftName.toString();
        if (bl) {
            string2 = DM4JStringUtils.trimDoubleQuotes(string2);
        }
        if (string2.length() == 0) {
            string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            stringArray = new String[]{ResourceUtilities.getUILabel("LIFT_NAME")};
            vector.add(new StateValidation(NameStateError.LIFT_NAME_EMPTY, string, stringArray));
        }
        if (!ValidationUtil.checkStringLength(string2, 25)) {
            string = ResourceUtilities.getstateExceptionMessage("MAXIMUM_LENGTH_EXCEEDED");
            stringArray = new String[]{ResourceUtilities.getUILabel("LIFT_NAME"), Integer.toString(25)};
            vector.add(new StateValidation(NameStateError.LIFT_NAME_EXCEEDS_MAXIMUM_LENGTH, string, stringArray));
        }
        if (!ValidationUtil.isTableNameUnique(string2, ((WizardState)this.getparentWizardState()).getConnection())) {
            vector.add(new StateValidation(NameStateError.LIFT_NAME_DUPLICATE));
        }
        if (!bl && !ValidationUtil.isValidNonQuotedDBObjectName(string2)) {
            vector.add(new StateValidation(NameStateError.DATAMINING_NAME_INVALID_DB_OBJECT_NAME));
        }
    }

    public void validate(Vector vector) throws Exception {
        if (this.m_enableDataUsageView) {
            this.validateDataUsageViewName(vector);
        }
        if (this.m_enableCostMatrix) {
            this.validateCostMatrixName(vector);
        }
        if (this.m_enableConfusionMatrix) {
            this.validateConfusionMatrixName(vector);
        }
        if (this.m_enableROC) {
            this.validateROCName(vector);
        }
        if (this.m_enableLift) {
            this.validateLiftName(vector);
        }
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        }
    }
}

