/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.miningsteps;

import java.util.HashMap;
import java.util.Vector;
import oracle.bali.ewt.model.TwoDModelAdapter;
import oracle.bali.ewt.model.TwoDModelEvent;
import oracle.dmt.dm4j.activity.steps.FeatureApplyStepOptions;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.browser.LaunchPoint;
import oracle.dmt.dm4j.datasources.FeatureIdSource;
import oracle.dmt.dm4j.wizard.director.minings.FeatureExtractionModelApplyLoader;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.minings.WizardState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ApplyOutputOptionState;
import oracle.dmt.dm4j.wizard.steps.minings.StepType;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.dm4j.wizard.validation.miningsteps.ApplyOutputOptionError;

public class FeatureExtractionApplyOutputOptionState
extends ApplyOutputOptionState {
    protected FeatureIdSource m_featureIdDS;
    protected FeatureApplyStepOptions m_options;
    CheckForDataSourceChanges m_dataSourcelistener = new CheckForDataSourceChanges();

    public FeatureExtractionApplyOutputOptionState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
        BrowserContext browserContext = this.getparentWizardState().getBrowserContext();
        if (browserContext.getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE) && browserContext.getOptions() instanceof FeatureApplyStepOptions) {
            this.m_options = (FeatureApplyStepOptions)browserContext.getOptions();
        }
    }

    protected void loadNew() throws Exception {
        super.loadNew();
        this.loadDefaults();
    }

    private void loadDefaults() throws InterruptedException {
        this.m_featureIdDS = this.m_options.getFeatureIdDataSource();
        this.setDataUsageListener();
    }

    protected void setDataUsageListener() {
        this.m_featureIdDS.addModelListener(this.m_dataSourcelistener);
    }

    protected void validateSpecificPredictions(Vector vector) throws Exception {
        if (this.m_featureIdDS.getIncludedCount() == 0) {
            vector.add(new StateValidation(ApplyOutputOptionError.APPLY_OPTION_REQUIRES_FEATURE_ID));
        }
    }

    protected void validateTopNPredictions(Vector vector) throws Exception {
        super.validateTopNPredictions(vector);
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            int n = this.m_featureIdDS.getRowCount();
            if (this.getNumberOfTopNPredictions() <= 0 || this.getNumberOfTopNPredictions() > n) {
                String string = ResourceUtilities.getstateExceptionMessage("APPLY_OPTION_MAXIMUM_RANKED_PREDICTIONS");
                String[] stringArray = new String[]{String.valueOf(n)};
                vector.add(new StateValidation(ApplyOutputOptionError.APPLY_OPTION_BOTN_MAXIMUM_RANKED_PREDICTIONS, string, stringArray));
            }
        }
    }

    protected void refreshNew() throws Exception {
        super.refreshNew();
        this.loadDefaults();
    }

    protected void refreshOld() throws Exception {
        super.refreshOld();
        FeatureExtractionModelApplyLoader featureExtractionModelApplyLoader = (FeatureExtractionModelApplyLoader)((WizardState)this.getparentWizardState()).getMiningLoader();
        featureExtractionModelApplyLoader.buildApplyOption(this);
    }

    protected void loadOld() throws Exception {
        super.loadOld();
        FeatureExtractionModelApplyLoader featureExtractionModelApplyLoader = (FeatureExtractionModelApplyLoader)((WizardState)this.getparentWizardState()).getMiningLoader();
        featureExtractionModelApplyLoader.buildApplyOption(this);
    }

    public boolean preload() throws Exception {
        boolean bl = true;
        return bl;
    }

    public boolean postValidate(Vector vector) throws Exception {
        boolean bl = true;
        return bl;
    }

    public void setFeatureIds(FeatureIdSource featureIdSource) {
        this.m_featureIdDS = featureIdSource;
    }

    public FeatureIdSource getFeatureIds() {
        return this.m_featureIdDS;
    }

    public Vector getFeatureIdsAsVector(boolean bl) {
        return this.m_featureIdDS.getIncludedFeatureIDs(bl);
    }

    public String getFeatureIDDataType() {
        return "NUMBER";
    }

    public String getFeatureIDCount() {
        return Integer.toString(this.m_featureIdDS.getRowCount());
    }

    public int getFeatureIDCountInteger() {
        return this.m_featureIdDS.getRowCount();
    }

    public HashMap getFeaturePredictionColumns(boolean bl) {
        return this.m_featureIdDS.getFeaturePredictionColumns(bl);
    }

    private class CheckForDataSourceChanges
    extends TwoDModelAdapter {
        private CheckForDataSourceChanges() {
        }

        public void invalidateCells(TwoDModelEvent twoDModelEvent) {
            if (FeatureExtractionApplyOutputOptionState.this.getState() == StepStateType.VALIDATED) {
                FeatureExtractionApplyOutputOptionState.this.setState(StepStateType.DIRTY);
            }
        }
    }
}

