/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.miningsteps;

import java.util.Vector;
import oracle.dmt.dm4j.activity.AbstractActivity;
import oracle.dmt.dm4j.activity.steps.DiscretizationStep;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.browser.LaunchPoint;
import oracle.dmt.dm4j.wizard.director.minings.ModelBuildLoader;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.minings.ClusteringModelBuildState;
import oracle.dmt.dm4j.wizard.state.minings.WizardState;
import oracle.dmt.dm4j.wizard.state.minings.WizardStepState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ClassificationAlgorithmState;
import oracle.dmt.dm4j.wizard.state.miningsteps.DataUsageState;
import oracle.dmt.dm4j.wizard.state.miningsteps.RegressionAlgorithmState;
import oracle.dmt.dm4j.wizard.steps.minings.StepType;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;

public class DataPrepState
extends WizardStepState {
    public static int PREP_NONE;
    public static int DISC_PREP_NONE;
    public static int DISC_PREP_AUTO;
    private int m_dataPreparedStatus = PREP_NONE;
    private boolean m_minMaxSelected = true;
    private boolean m_zscoreSelected = false;

    public DataPrepState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
    }

    public int getDataPreparedStatus() {
        return this.m_dataPreparedStatus;
    }

    public void setDataPreparedStatus(int n) {
        if (this.m_dataPreparedStatus != n) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_dataPreparedStatus = n;
        }
    }

    public boolean isDiscretization() {
        boolean bl = true;
        WizardStepState wizardStepState = (WizardStepState)this.getparentWizardState().getStep(StepType.ALGORITHM_STEP);
        if (wizardStepState instanceof ClassificationAlgorithmState) {
            bl = !((ClassificationAlgorithmState)wizardStepState).getSupportVectorMachineSelected();
        } else if (wizardStepState instanceof RegressionAlgorithmState) {
            bl = false;
        }
        return bl;
    }

    public void setMinMaxSelected(boolean bl) {
        this.m_minMaxSelected = bl;
        this.m_zscoreSelected = !this.m_minMaxSelected;
    }

    public void setZScoreSelected(boolean bl) {
        this.m_zscoreSelected = bl;
        this.m_minMaxSelected = !this.m_zscoreSelected;
    }

    public boolean isMinMaxSelected() {
        return this.m_minMaxSelected;
    }

    public boolean isZScoreSelected() {
        return this.m_zscoreSelected;
    }

    public boolean preload() throws Exception {
        boolean bl = true;
        return bl;
    }

    public boolean allowPrepSelection() {
        DiscretizationStep discretizationStep;
        BrowserContext browserContext = this.getparentWizardState().getBrowserContext();
        AbstractActivity abstractActivity = browserContext.getActivity();
        boolean bl = true;
        if (abstractActivity != null && (discretizationStep = abstractActivity.findDiscretizationStep()) != null && discretizationStep.getIsComplete()) {
            bl = false;
        }
        return bl;
    }

    protected void loadOld() throws Exception {
        this.loadDefaultValues();
        ModelBuildLoader modelBuildLoader = (ModelBuildLoader)((WizardState)this.getparentWizardState()).getMiningLoader();
        modelBuildLoader.buildDataPrep(this);
    }

    protected void loadNew() throws Exception {
        this.loadDefaultValues();
    }

    protected void refreshOld() throws Exception {
        this.loadOld();
    }

    protected void refreshNew() throws Exception {
        this.loadNew();
    }

    private void validatePrepData(Vector vector) throws Exception {
        DataUsageState dataUsageState = (DataUsageState)this.getparentWizardState().getStep(StepType.DATA_USAGE_STEP);
        if (dataUsageState != null && dataUsageState.doesAlgorithmRequireBinning() && !(this.getparentWizardState() instanceof ClusteringModelBuildState)) {
            Boolean bl = new Boolean(false);
            for (int i = 0; i < dataUsageState.getLDSDataSource().getRowCount(); ++i) {
                bl = (Boolean)dataUsageState.getLDSDataSource().getData(0, i);
                if (!bl.booleanValue() || ((String)dataUsageState.getLDSDataSource().getData(5, i)).equals("target")) continue;
                if (this.getDataPreparedStatus() == DISC_PREP_NONE) {
                    dataUsageState.getLDSDataSource().setData(3, i, "categorical");
                    continue;
                }
                dataUsageState.getLDSDataSource().setData(3, i, (String)dataUsageState.getLDSDataSource().getData(6, i));
            }
        }
    }

    public void validate(Vector vector) throws Exception {
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.validatePrepData(vector);
        }
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        } else {
            this.setState(StepStateType.DIRTY);
        }
    }

    protected void loadDefaultValues() {
        this.m_dataPreparedStatus = DISC_PREP_AUTO;
        WizardStepState wizardStepState = (WizardStepState)this.getparentWizardState().getStep(StepType.ALGORITHM_STEP);
        BrowserContext browserContext = this.getparentWizardState().getBrowserContext();
        if (browserContext.getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE)) {
            AbstractActivity abstractActivity = this.getparentWizardState().getBrowserContext().getActivity();
            boolean bl = false;
            try {
                bl = abstractActivity.isDataPrepared();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setDataPreparedStatus(bl ? DISC_PREP_NONE : DISC_PREP_AUTO);
        }
    }

    public boolean postValidate(Vector vector) throws Exception {
        boolean bl = true;
        return bl;
    }

    static {
        DISC_PREP_NONE = PREP_NONE = 0;
        DISC_PREP_AUTO = PREP_NONE + 1;
    }
}

