/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.miningsteps;

import java.util.Vector;
import oracle.dmt.dm4j.activity.ActivityType;
import oracle.dmt.dm4j.activity.steps.BuildStepOptions;
import oracle.dmt.dm4j.activity.steps.KMeansBuildStepOptions;
import oracle.dmt.dm4j.activity.steps.OClusterBuildStepOptions;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.datasources.LDSDataSource;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.minings.WizardState;
import oracle.dmt.dm4j.wizard.state.minings.WizardStepState;
import oracle.dmt.dm4j.wizard.state.miningsteps.DataState;
import oracle.dmt.dm4j.wizard.state.miningsteps.KMeansAlgorithmState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ModelDataState;
import oracle.dmt.dm4j.wizard.state.miningsteps.OClusterAlgorithmState;
import oracle.dmt.dm4j.wizard.steps.minings.StepType;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;

public class ClusteringAlgorithmState
extends WizardStepState {
    private boolean m_kmeansSelected = false;
    private boolean m_oclusterSelected = false;
    private KMeansAlgorithmState m_kmeansAlgorithmState;
    private OClusterAlgorithmState m_oclusterAlgorithmState;
    private BuildStepOptions m_options = null;

    public ClusteringAlgorithmState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
        BrowserContext browserContext = this.getparentWizardState().getBrowserContext();
        this.m_options = (BuildStepOptions)browserContext.getOptions();
        ActivityType activityType = browserContext.getActivity().getType();
        if (activityType == ActivityType.K_MEANS_CLUSTER) {
            this.m_kmeansSelected = true;
        } else {
            this.m_oclusterSelected = true;
        }
    }

    public void setKMeansSelected(boolean bl) {
        if (!this.m_kmeansSelected == bl) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_kmeansSelected = bl;
            this.m_oclusterSelected = !bl;
        }
    }

    public boolean getKMeansSelected() {
        return this.m_kmeansSelected;
    }

    public boolean isKMeansSelected() {
        return this.m_kmeansSelected;
    }

    public void setOClusterSelected(boolean bl) {
        if (!this.m_oclusterSelected == bl) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_oclusterSelected = bl;
            this.m_kmeansSelected = !bl;
        }
    }

    public boolean getOClusterSelected() {
        return this.m_oclusterSelected;
    }

    public boolean isOClusterSelected() {
        return this.m_oclusterSelected;
    }

    public LDSDataSource getLDSDataSource() {
        ModelDataState modelDataState = (ModelDataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
        return modelDataState.getLDSDataSource();
    }

    public String getAttributeCount() {
        ModelDataState modelDataState = (ModelDataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
        return Integer.toString(modelDataState.getAttributeCountFromLDSDataSource());
    }

    public String getActiveAttributeCountExcludingTargets() {
        ModelDataState modelDataState = (ModelDataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
        return Integer.toString(modelDataState.getActiveAttributeCountExcludingTargets());
    }

    public int getActiveAttributeCountExcludingTargetsInteger() {
        ModelDataState modelDataState = (ModelDataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
        return modelDataState.getActiveAttributeCountExcludingTargets();
    }

    public String getCaseCount() {
        DataState dataState = (DataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
        return Integer.toString(dataState.getCaseCount());
    }

    public int getCaseCountInteger() {
        DataState dataState = (DataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
        return dataState.getCaseCount();
    }

    public KMeansAlgorithmState getKMeans() {
        if (this.m_kmeansAlgorithmState == null) {
            this.loadDefaultKMeansSetting();
        }
        return this.m_kmeansAlgorithmState;
    }

    public void setKMeans(KMeansAlgorithmState kMeansAlgorithmState) {
        this.m_kmeansAlgorithmState = kMeansAlgorithmState;
    }

    public OClusterAlgorithmState getOCluster() {
        if (this.m_oclusterAlgorithmState == null) {
            this.loadDefaultOClusterSetting();
        }
        return this.m_oclusterAlgorithmState;
    }

    public void setOCluster(OClusterAlgorithmState oClusterAlgorithmState) {
        this.m_oclusterAlgorithmState = oClusterAlgorithmState;
    }

    public void setKMeansNumberOfClusters(Integer n) {
        if (this.getState() == StepStateType.VALIDATED) {
            this.setState(StepStateType.DIRTY);
        }
        ((KMeansBuildStepOptions)this.m_options).setKmeansNumberOfClusters(n);
    }

    public Integer getKMeansNumberOfClusters() {
        return ((KMeansBuildStepOptions)this.m_options).getKmeansNumberOfClusters();
    }

    public void setOClusterNumberOfClusters(Integer n) {
        if (this.getState() == StepStateType.VALIDATED) {
            this.setState(StepStateType.DIRTY);
        }
        ((OClusterBuildStepOptions)this.m_options).setOclusterNumberOfClusters(n);
    }

    public Integer getOClusterNumberOfClusters() {
        return ((OClusterBuildStepOptions)this.m_options).getOclusterNumberOfClusters();
    }

    public boolean allowAlgorithmSelection() {
        return false;
    }

    protected void refreshOld() throws Exception {
    }

    protected void refreshNew() throws Exception {
    }

    protected void loadOld() throws Exception {
    }

    public boolean postValidate(Vector vector) throws Exception {
        boolean bl = true;
        return bl;
    }

    public boolean preload() throws Exception {
        boolean bl = true;
        return bl;
    }

    protected void loadNew() throws Exception {
        this.loadDefaults();
    }

    protected void loadDefaults() {
        if (this.isKMeansSelected()) {
            this.m_kmeansAlgorithmState = new KMeansAlgorithmState(this);
        } else if (this.isOClusterSelected()) {
            this.m_oclusterAlgorithmState = new OClusterAlgorithmState(this);
        }
    }

    protected void loadDefaultKMeansSetting() {
        this.m_kmeansAlgorithmState = new KMeansAlgorithmState(this);
    }

    protected void loadDefaultOClusterSetting() {
        this.m_oclusterAlgorithmState = new OClusterAlgorithmState(this);
    }

    protected void validateNumberOfClusters(Vector vector) throws Exception {
        if (this.isKMeansSelected()) {
            this.validateKMeansNumberOfClusters(vector);
        } else if (this.isOClusterSelected()) {
            this.validateOClusterNumberOfClusters(vector);
        }
    }

    protected void validateOClusterNumberOfClusters(Vector vector) throws Exception {
        ((OClusterBuildStepOptions)this.m_options).validateNumberOfClusters(vector);
    }

    protected void validateKMeansNumberOfClusters(Vector vector) throws Exception {
        ((KMeansBuildStepOptions)this.m_options).validateNumberOfClusters(vector);
    }

    public void validate(Vector vector) throws Exception {
        this.validateNumberOfClusters(vector);
        if (ValidationUtil.validationsContainsErrors(vector)) {
            return;
        }
        if (this.isKMeansSelected()) {
            this.validateKMeansNumberOfClusters(vector);
        } else if (this.isOClusterSelected()) {
            this.validateOClusterNumberOfClusters(vector);
        }
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        }
    }
}

