/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.miningsteps;

import java.util.Vector;
import oracle.dmt.dm4j.activity.steps.ClassificationTestMetricStepOptions;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.browser.LaunchPoint;
import oracle.dmt.dm4j.wizard.director.minings.ClassificationModelLiftLoader;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.minings.WizardState;
import oracle.dmt.dm4j.wizard.state.minings.WizardStepState;
import oracle.dmt.dm4j.wizard.steps.minings.StepType;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.dm4j.wizard.validation.miningsteps.TestMetricsOptionsStateError;

public class ClassificationTestMetricsOptionsState
extends WizardStepState {
    private boolean m_generateTest;
    private boolean m_generateLift;
    private boolean m_generateROC;
    private Integer m_numLiftQuantile;
    private ClassificationTestMetricStepOptions m_options = null;

    public ClassificationTestMetricsOptionsState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
    }

    protected void refreshOld() throws Exception {
        this.loadOld();
    }

    protected void refreshNew() throws Exception {
        this.loadNew();
    }

    protected void loadOld() throws Exception {
        this.loadDefault();
        ClassificationModelLiftLoader classificationModelLiftLoader = (ClassificationModelLiftLoader)((WizardState)this.getparentWizardState()).getMiningLoader();
        classificationModelLiftLoader.buildResultOptions(this);
    }

    protected void loadNew() throws Exception {
        this.loadDefault();
    }

    public boolean preload() throws Exception {
        boolean bl = true;
        return bl;
    }

    protected void loadDefault() {
        BrowserContext browserContext = this.getparentWizardState().getBrowserContext();
        if (browserContext.getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE)) {
            this.m_options = (ClassificationTestMetricStepOptions)browserContext.getOptions();
        }
        if (this.m_options != null) {
            this.m_generateTest = this.m_options.isGenConfusionMatrix();
            this.m_generateLift = this.m_options.isGenLift();
            this.m_generateROC = this.m_options.isGenROC();
            this.m_numLiftQuantile = this.m_options.getNumLiftQuantiles();
        } else {
            this.m_generateTest = true;
            this.m_generateLift = true;
            this.m_generateROC = true;
            this.m_numLiftQuantile = new Integer(10);
        }
    }

    public void setGenerateTest(boolean bl) {
        if (this.m_generateTest != bl) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_generateTest = bl;
            if (this.m_options != null) {
                this.m_options.setGenConfusionMatrix(bl);
            }
        }
    }

    public boolean IsGenerateTest() {
        return this.m_generateTest;
    }

    public void setGenerateLift(boolean bl) {
        if (this.m_generateLift != bl) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_generateLift = bl;
            if (this.m_options != null) {
                this.m_options.setGenLift(bl);
            }
        }
    }

    public boolean IsGenerateLift() {
        return this.m_generateLift;
    }

    public void setGenerateROC(boolean bl) {
        if (this.m_generateROC != bl) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_generateROC = bl;
            if (this.m_options != null) {
                this.m_options.setGenROC(bl);
            }
        }
    }

    public boolean IsGenerateROC() {
        return this.m_generateROC;
    }

    public void setNumLiftQuantile(Integer n) {
        if (this.m_numLiftQuantile == null || n == null || this.m_numLiftQuantile.compareTo(n) != 0) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_numLiftQuantile = n;
            if (this.m_options != null) {
                this.m_options.setNumLiftQuantiles(n);
            }
        }
    }

    public Integer getNumLiftQuantile() {
        return this.m_numLiftQuantile;
    }

    public boolean postValidate(Vector vector) throws Exception {
        boolean bl = true;
        return bl;
    }

    public void validate(Vector vector) throws Exception {
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            if (this.m_numLiftQuantile == null) {
                String string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
                String[] stringArray = new String[]{ResourceUtilities.getUILabel("ALGO_NB_PAIRWISE_THRESHOLD")};
                vector.add(new StateValidation(TestMetricsOptionsStateError.TM_NUM_LIFT_QUANTILE_EMPTY, string, stringArray));
            } else {
                int n = this.m_numLiftQuantile;
                if (n < 2 || n > 100) {
                    vector.add(new StateValidation(TestMetricsOptionsStateError.TM_NUM_LIFT_QUANTILE_INVALID));
                }
            }
            if (!(this.IsGenerateLift() || this.IsGenerateROC() || this.IsGenerateTest())) {
                vector.add(new StateValidation(TestMetricsOptionsStateError.TM_NUM_NO_OPTION_SELECTED));
            }
            this.setState(StepStateType.VALIDATED);
        }
    }

    public void restoreSettingsToDefault() {
        this.loadDefault();
    }
}

