/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.miningsteps;

import java.util.Vector;
import javax.datamining.base.Model;
import javax.datamining.supervised.SupervisedModel;
import oracle.bali.ewt.model.TwoDModelAdapter;
import oracle.bali.ewt.model.TwoDModelEvent;
import oracle.bali.share.collection.Range;
import oracle.dmt.dm4j.activity.steps.AbstractStepOptions;
import oracle.dmt.dm4j.activity.steps.ApplyStepOptions;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.browser.LaunchPoint;
import oracle.dmt.dm4j.datasources.LDSDataSource;
import oracle.dmt.dm4j.wizard.director.minings.ModelApplyLoader;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.minings.WizardState;
import oracle.dmt.dm4j.wizard.state.minings.WizardStepState;
import oracle.dmt.dm4j.wizard.state.miningsteps.RegressionModelState;
import oracle.dmt.dm4j.wizard.state.miningsteps.SequenceAttributeState;
import oracle.dmt.dm4j.wizard.steps.minings.StepType;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.dm4j.wizard.validation.miningsteps.ApplyIDError;

public class ApplyIDState
extends WizardStepState {
    static final int MAXIMUM_IDS = 995;
    CheckForDataSourceChanges m_dataSourcelistener = null;
    protected LDSDataSource m_ldsDataSource;
    protected AbstractStepOptions m_options = null;

    public ApplyIDState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
        BrowserContext browserContext = wizardState.getBrowserContext();
        if (browserContext.getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE)) {
            this.m_options = browserContext.getOptions();
        }
    }

    protected void setDataUsageListener(boolean bl) {
        this.m_dataSourcelistener = new CheckForDataSourceChanges(bl);
        this.getLDSDataSource().addModelListener(this.m_dataSourcelistener);
    }

    protected void clearDataUsageListener() {
        if (this.m_ldsDataSource != null) {
            this.m_ldsDataSource.removeModelListener(this.m_dataSourcelistener);
        }
    }

    protected void loadNew() throws Exception {
        this.setAllAttributesToExclude();
        if (this.m_options != null) {
            ApplyStepOptions applyStepOptions = (ApplyStepOptions)this.m_options;
            Vector vector = applyStepOptions.getCurSupplementalAttributes();
            this.setAttributeToInclude(vector);
        }
        this.setDataUsageListener(true);
    }

    protected void loadOld() throws Exception {
        ModelApplyLoader modelApplyLoader = (ModelApplyLoader)((WizardState)this.getparentWizardState()).getMiningLoader();
        modelApplyLoader.buildApplySourceAttributes(this);
        this.setDataUsageListener(false);
    }

    protected void refreshNew() throws Exception {
        this.loadNew();
    }

    protected void refreshOld() throws Exception {
        this.loadOld();
    }

    public void setAllAttributesToExclude() {
        Range range = new Range(0, Integer.parseInt(this.getAttributeCount()) - 1);
        Range[] rangeArray = new Range[]{range};
        this.setAttributeToExclude(rangeArray);
    }

    public Vector getIDAttributes() {
        return this.getLDSDataSource().getAttributes(true, false);
    }

    public int getSequenceIDRowID() {
        SequenceAttributeState sequenceAttributeState = (SequenceAttributeState)this.getparentWizardState().getStep(StepType.SEQ_ID_STEP);
        if (sequenceAttributeState != null && this.m_ldsDataSource != null) {
            String string = sequenceAttributeState.getSequenceAttribute();
            if (string != null && string != "") {
                return this.m_ldsDataSource.getAttributeIndex(string);
            }
            return -1;
        }
        return -1;
    }

    public String getSequenceIDName() {
        SequenceAttributeState sequenceAttributeState = (SequenceAttributeState)this.getparentWizardState().getStep(StepType.SEQ_ID_STEP);
        if (sequenceAttributeState != null && this.m_ldsDataSource != null) {
            String string = sequenceAttributeState.getSequenceAttribute();
            if (string != null && string != "") {
                return string;
            }
            return null;
        }
        return null;
    }

    public LDSDataSource getLDSDataSource() {
        return this.m_ldsDataSource;
    }

    public void setLDSDataSource(LDSDataSource lDSDataSource) {
        this.m_ldsDataSource = lDSDataSource;
        this.setDataUsageListener(false);
    }

    protected void validateMinimumAttributes(Vector vector) throws Exception {
        int n = Integer.parseInt(this.getSelectedAttributeCount());
        if (n == 0) {
            vector.add(new StateValidation(ApplyIDError.APPLY_ID_NO_SELECTED_ID_ATTRIBUTES));
        }
    }

    protected void validateMaximumAttributes(Vector vector) throws Exception {
        int n = Integer.parseInt(this.getSelectedAttributeCount());
        if (n > 995) {
            String string = ResourceUtilities.getstateExceptionMessage("APPLY_ID_MAXIMUM_SELECTED_ID_ATTRIBUTES");
            String[] stringArray = new String[]{String.valueOf(995)};
            vector.add(new StateValidation(ApplyIDError.APPLY_ID_MAXIMUM_SELECTED_ID_ATTRIBUTES, string, stringArray));
        }
    }

    public void validate(Vector vector) throws Exception {
        if (vector.isEmpty()) {
            this.validateMaximumAttributes(vector);
        }
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        } else {
            this.setState(StepStateType.DIRTY);
        }
    }

    public int getAttributeCountInteger() {
        int n = this.getLDSDataSource().getRowCount();
        if (this.getSequenceIDName() == null) {
            return n;
        }
        return n - 1;
    }

    public String getAttributeCount() {
        return Integer.toString(this.getLDSDataSource().getRowCount());
    }

    public String getSelectedAttributeCount() {
        return Integer.toString(this.getLDSDataSource().getActiveAttributeCountIncludingTargets());
    }

    public int getSelectedAttributeCountInteger() {
        return this.getLDSDataSource().getActiveAttributeCountIncludingTargets();
    }

    public void saveIncludedAttributes(Vector vector) {
        ApplyStepOptions applyStepOptions = (ApplyStepOptions)this.m_options;
        applyStepOptions.setCurSupplementalAttributes(vector);
    }

    public void setAttributeToInclude(Vector vector) {
        LDSDataSource lDSDataSource = this.getLDSDataSource();
        for (int i = 0; i < lDSDataSource.getRowCount(); ++i) {
            for (int j = 0; j < vector.size(); ++j) {
                String string = (String)vector.get(j);
                if (!string.equals(lDSDataSource.getData(1, i))) continue;
                lDSDataSource.setData(0, i, new Boolean(true));
            }
        }
        this.setState(StepStateType.DIRTY);
    }

    public void setAttributeToInclude(Range[] rangeArray) {
        LDSDataSource lDSDataSource = this.getLDSDataSource();
        String string = this.getSequenceIDName();
        for (int i = 0; i < rangeArray.length; ++i) {
            for (int j = rangeArray[i].getLowerLimit(); j < rangeArray[i].getUpperLimit() + 1; ++j) {
                if (string.equals(lDSDataSource.getData(1, j))) continue;
                lDSDataSource.setData(0, j, new Boolean(true));
            }
        }
        this.setState(StepStateType.DIRTY);
    }

    public void setAttributeToExclude(Range[] rangeArray) {
        String string = this.getSequenceIDName();
        LDSDataSource lDSDataSource = this.getLDSDataSource();
        for (int i = 0; i < rangeArray.length; ++i) {
            for (int j = rangeArray[i].getLowerLimit(); j < rangeArray[i].getUpperLimit() + 1; ++j) {
                if (string != null) {
                    if (string.equals(lDSDataSource.getData(1, j))) continue;
                    this.getLDSDataSource().setData(0, j, new Boolean(false));
                    continue;
                }
                this.getLDSDataSource().setData(0, j, new Boolean(false));
            }
        }
        this.setState(StepStateType.DIRTY);
    }

    public boolean preload() throws Exception {
        boolean bl = true;
        return bl;
    }

    public boolean postValidate(Vector vector) throws Exception {
        boolean bl = true;
        Vector vector2 = this.getIDAttributes();
        this.saveIncludedAttributes(vector2);
        return bl;
    }

    public int getTargetAttributeRowID(LDSDataSource lDSDataSource) {
        this.m_ldsDataSource = lDSDataSource;
        this.setAllAttributesToExclude();
        this.setDataUsageListener(true);
        return this.getTargetAttributeRowID();
    }

    public int getTargetAttributeRowID() {
        String string = null;
        RegressionModelState regressionModelState = (RegressionModelState)this.getparentWizardState().getStep(StepType.MODEL_STEP);
        if (regressionModelState != null && this.m_ldsDataSource != null) {
            try {
                Model model = regressionModelState.restoreModel();
                if (model != null) {
                    string = ((SupervisedModel)model).getTargetAttributeName();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string != null && string != "") {
                return this.m_ldsDataSource.getAttributeIndex(string);
            }
            return -1;
        }
        return -1;
    }

    private class CheckForDataSourceChanges
    extends TwoDModelAdapter {
        private boolean m_newWizard;

        public CheckForDataSourceChanges(boolean bl) {
            this.m_newWizard = bl;
        }

        public void invalidateCells(TwoDModelEvent twoDModelEvent) {
            if (this.m_newWizard) {
                if (ApplyIDState.this.getState() == StepStateType.VALIDATED) {
                    ApplyIDState.this.setState(StepStateType.DIRTY);
                }
            } else if (ApplyIDState.this.getState() == StepStateType.VALIDATED) {
                ApplyIDState.this.setState(StepStateType.INCONSISTENT);
            }
        }
    }
}

