/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.minings;

import java.util.Iterator;
import java.util.Vector;
import javax.datamining.resource.Connection;
import javax.swing.JOptionPane;
import oracle.dmt.dm4j.DM4JException;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.ProgressBar;
import oracle.dmt.dm4j.datasources.LDSDataSource;
import oracle.dmt.dm4j.wizard.dialogs.MissingAttributesDialog;
import oracle.dmt.dm4j.wizard.director.minings.MiningBuilder;
import oracle.dmt.dm4j.wizard.director.minings.MiningLoader;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.minings.ExplainState;
import oracle.dmt.dm4j.wizard.state.minings.PredictState;
import oracle.dmt.dm4j.wizard.state.minings.WizardStepState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ApplyIDState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ApplyOutputOptionState;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.jdm.resource.OraConnection;

public abstract class WizardState
extends oracle.dmt.dm4j.wizard.state.WizardState {
    protected MiningBuilder m_builder;
    protected MiningLoader m_loader;
    protected StringBuffer m_newTaskName = new StringBuffer(30);
    protected Connection m_jdmConnection = null;
    protected boolean m_isNewInstance = true;

    public WizardState(BrowserContext browserContext) {
        super(browserContext);
    }

    public WizardState(BrowserContext browserContext, Connection connection, boolean bl) {
        super(browserContext, ((OraConnection)connection).getDatabaseConnection());
        this.m_jdmConnection = connection;
        this.m_isNewInstance = !bl;
    }

    public Connection getJDMConnection() {
        return this.m_jdmConnection;
    }

    public MiningBuilder getMiningBuilder() {
        return this.m_builder;
    }

    public MiningLoader getMiningLoader() {
        return this.m_loader;
    }

    public boolean isNew() {
        return this.m_isNewInstance;
    }

    public boolean isOld() {
        return !this.m_isNewInstance;
    }

    public void setCopy(boolean bl) {
        this.m_isNewInstance = !bl;
    }

    public void validateWizard(oracle.dmt.dm4j.wizard.steps.minings.StepType stepType, WizardStepState wizardStepState, Vector vector) throws Exception {
        if (this.isNew()) {
            this.invalidateFurtherSteps(stepType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish(Vector vector) throws Exception {
        try {
            ProgressBar progressBar = new ProgressBar(BrowserFrame.getMainFrame(), ResourceUtilities.getUILabel("MODEL_BUILD_DIALOG_TITLE"), this.m_builder, true);
            this.m_builder.setProgressBar(progressBar);
            progressBar.start(ResourceUtilities.getUILabel("MODEL_BUILD_UPPER_DESC"), null);
            if (this.m_builder.getException() != null) {
                this.doAbortCancel(this.m_builder.getException());
            } else if (progressBar.hasUserCancelled()) {
                this.m_builder.cleanUp();
            } else {
                this.setWizardFinished();
                BrowserFrame.getMainFrame().getActiveTasksTable().findTask(this.m_newTaskName.toString());
            }
            Object var4_3 = null;
            if (this.m_builder != null) {
                this.m_builder.clear();
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (this.m_builder != null) {
                this.m_builder.clear();
            }
            throw throwable;
        }
    }

    protected void invalidateFurtherSteps(StepType stepType) throws Exception {
        Vector vector = this.getStepKeys();
        Iterator iterator = vector.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            oracle.dmt.dm4j.wizard.steps.minings.StepType stepType2 = (oracle.dmt.dm4j.wizard.steps.minings.StepType)iterator.next();
            WizardStepState wizardStepState = (WizardStepState)this.getStep(stepType2);
            if (stepType2 == stepType) {
                bl = true;
                continue;
            }
            if (!bl) continue;
            if (oracle.dmt.dm4j.wizard.steps.minings.StepType.MODEL_STEP == stepType) {
                if (oracle.dmt.dm4j.wizard.steps.minings.StepType.DATA_STEP == stepType2 && wizardStepState.getState() != StepStateType.UNLOADED) {
                    wizardStepState.setState(StepStateType.INCONSISTENT);
                } else if (oracle.dmt.dm4j.wizard.steps.minings.StepType.OUTPUT_DATA_STEP == stepType2 && wizardStepState.getState() != StepStateType.UNLOADED) {
                    wizardStepState.setState(StepStateType.INCONSISTENT);
                }
            }
            if (oracle.dmt.dm4j.wizard.steps.minings.StepType.DATA_STEP == stepType) {
                if (oracle.dmt.dm4j.wizard.steps.minings.StepType.ALGORITHM_STEP == stepType2 && wizardStepState.getState() != StepStateType.UNLOADED) {
                    wizardStepState.setState(StepStateType.INCONSISTENT);
                } else if (oracle.dmt.dm4j.wizard.steps.minings.StepType.SEQ_ID_STEP == stepType2 && wizardStepState.getState() != StepStateType.UNLOADED) {
                    wizardStepState.setState(StepStateType.INCONSISTENT);
                } else if (oracle.dmt.dm4j.wizard.steps.minings.StepType.TARGET_STEP == stepType2 && wizardStepState.getState() != StepStateType.UNLOADED) {
                    wizardStepState.setState(StepStateType.INCONSISTENT);
                } else if (oracle.dmt.dm4j.wizard.steps.minings.StepType.TARGET_VALUE_STEP == stepType2 && wizardStepState.getState() != StepStateType.UNLOADED) {
                    wizardStepState.setState(StepStateType.INCONSISTENT);
                } else if (oracle.dmt.dm4j.wizard.steps.minings.StepType.DATA_USAGE_STEP == stepType2 && wizardStepState.getState() != StepStateType.UNLOADED) {
                    wizardStepState.setState(StepStateType.INCONSISTENT);
                }
                if ((this instanceof PredictState || this instanceof ExplainState) && oracle.dmt.dm4j.wizard.steps.minings.StepType.NAME_STEP == stepType2 && wizardStepState.getState() != StepStateType.UNLOADED) {
                    wizardStepState.setState(StepStateType.INCONSISTENT);
                }
            }
            if (oracle.dmt.dm4j.wizard.steps.minings.StepType.SEQ_ID_STEP == stepType && oracle.dmt.dm4j.wizard.steps.minings.StepType.DATA_USAGE_STEP == stepType2 && wizardStepState.getState() != StepStateType.UNLOADED) {
                wizardStepState.setState(StepStateType.INCONSISTENT);
            }
            if (oracle.dmt.dm4j.wizard.steps.minings.StepType.ALGORITHM_STEP == stepType) {
                if (oracle.dmt.dm4j.wizard.steps.minings.StepType.SEQ_ID_STEP == stepType2 && wizardStepState.getState() != StepStateType.UNLOADED) {
                    wizardStepState.setState(StepStateType.INCONSISTENT);
                } else if (oracle.dmt.dm4j.wizard.steps.minings.StepType.TARGET_STEP == stepType2 && wizardStepState.getState() != StepStateType.UNLOADED) {
                    wizardStepState.setState(StepStateType.INCONSISTENT);
                } else if (oracle.dmt.dm4j.wizard.steps.minings.StepType.TARGET_VALUE_STEP == stepType2 && wizardStepState.getState() != StepStateType.UNLOADED) {
                    wizardStepState.setState(StepStateType.INCONSISTENT);
                }
            }
            if (oracle.dmt.dm4j.wizard.steps.minings.StepType.TARGET_STEP == stepType) {
                if (oracle.dmt.dm4j.wizard.steps.minings.StepType.TARGET_VALUE_STEP == stepType2 && wizardStepState.getState() != StepStateType.UNLOADED) {
                    wizardStepState.setState(StepStateType.INCONSISTENT);
                } else if (oracle.dmt.dm4j.wizard.steps.minings.StepType.DATA_USAGE_STEP == stepType2 && wizardStepState.getState() != StepStateType.UNLOADED) {
                    wizardStepState.setState(StepStateType.INCONSISTENT);
                }
            }
            if (oracle.dmt.dm4j.wizard.steps.minings.StepType.TM_OPTIONS_STEP == stepType && oracle.dmt.dm4j.wizard.steps.minings.StepType.TARGET_VALUE_STEP == stepType2 && wizardStepState.getState() != StepStateType.UNLOADED) {
                wizardStepState.setState(StepStateType.INCONSISTENT);
            }
            if (oracle.dmt.dm4j.wizard.steps.minings.StepType.FINISH_STEP != stepType2 || wizardStepState.getState() == StepStateType.UNLOADED) continue;
            wizardStepState.setState(StepStateType.INCONSISTENT);
        }
    }

    public void loadAllForReentrantState() throws Exception {
        Vector vector = this.getStepKeys();
        Iterator iterator = vector.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            oracle.dmt.dm4j.wizard.steps.minings.StepType stepType = (oracle.dmt.dm4j.wizard.steps.minings.StepType)iterator.next();
            WizardStepState wizardStepState = (WizardStepState)this.getStep(stepType);
            if (StepStateType.UNLOADED != wizardStepState.getState()) continue;
            wizardStepState.load();
        }
    }

    public abstract String getDefaultModelName();

    public abstract boolean synchronize(Vector var1, WizardStepState var2);

    protected boolean showPriorsDialog(String string) throws Exception {
        String string2 = ResourceUtilities.getUILabel("SYNCRHONIZE_COMPONENT_DIALOG_TITLE");
        String string3 = ResourceUtilities.getstateExceptionMessage(string);
        int n = JOptionPane.showConfirmDialog(null, string3, string2, 0, 3);
        return n == 0;
    }

    protected boolean doesApplyOptionsNeedToChange(ApplyOutputOptionState applyOutputOptionState, int n) {
        int n2 = 0;
        boolean bl = false;
        if (applyOutputOptionState.isBottomNPredictions()) {
            n2 = applyOutputOptionState.getNumberOfBottomNPredictions();
            if (n2 > n) {
                bl = true;
            }
        } else if (applyOutputOptionState.isTopNPredictions() && (n2 = applyOutputOptionState.getNumberOfTopNPredictions().intValue()) > n) {
            bl = true;
        }
        return bl;
    }

    protected void performPriorsSynch(ApplyOutputOptionState applyOutputOptionState, int n) {
        int n2 = 0;
        n2 = applyOutputOptionState.getNumberOfBottomNPredictions();
        if (n2 > n) {
            applyOutputOptionState.setNumberOfBottomNPredictions(new Integer(n));
        }
        if ((n2 = applyOutputOptionState.getNumberOfTopNPredictions().intValue()) > n) {
            applyOutputOptionState.setNumberOfTopNPredictions(new Integer(n));
        }
    }

    protected void synchApplyIDs(LDSDataSource lDSDataSource, WizardStepState wizardStepState) throws DM4JException, Exception {
        ApplyIDState applyIDState = (ApplyIDState)this.getStep(oracle.dmt.dm4j.wizard.steps.minings.StepType.APPLY_ID_STEP);
        LDSDataSource lDSDataSource2 = applyIDState.getLDSDataSource();
        Vector vector = lDSDataSource2.getAttributes(true, false);
        applyIDState.setLDSDataSource(lDSDataSource);
        applyIDState.setAllAttributesToExclude();
        int n = -1;
        int n2 = 0;
        boolean bl = false;
        for (int i = 0; i < vector.size(); ++i) {
            n = lDSDataSource.getAttributeIndex((String)vector.get(i));
            if (n == -1) {
                bl = true;
                continue;
            }
            ++n2;
            lDSDataSource.setData(0, n, new Boolean(true));
        }
        if (bl) {
            String string = ResourceUtilities.getUILabel("SYNCRHONIZE_COMPONENT_DIALOG_TITLE");
            String string2 = ResourceUtilities.getstateExceptionMessage("SYNCHRONIZE_APPLY_IDS_CHANGED");
            JOptionPane.showMessageDialog(null, string2, string, 1);
        }
    }

    protected boolean displayMissingAttributesDialog(LDSDataSource lDSDataSource, Vector vector) {
        try {
            MissingAttributesDialog missingAttributesDialog = new MissingAttributesDialog(this.getDialog(), lDSDataSource, vector);
            return missingAttributesDialog.isCancelled();
        }
        catch (Exception exception) {
            this.doAbortCancel(exception);
            return true;
        }
    }

    public void setNewTaskName(String string) {
        this.m_newTaskName.setLength(0);
        this.m_newTaskName.append(string);
    }
}

