/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.minings;

import java.util.Vector;
import javax.datamining.resource.Connection;
import oracle.dmt.dm4j.DM4JException;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.ProgressBar;
import oracle.dmt.dm4j.datasources.DiffLDSDataSource;
import oracle.dmt.dm4j.datasources.LDSDataSource;
import oracle.dmt.dm4j.wizard.dialogs.ModelSignatureDiscrepancyWarningDialog;
import oracle.dmt.dm4j.wizard.director.minings.SynchronizeModelBuildProcess;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.minings.WizardState;
import oracle.dmt.dm4j.wizard.state.minings.WizardStepState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ModelDataState;
import oracle.dmt.dm4j.wizard.steps.minings.StepType;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.miningsteps.DataStateInformational;

public abstract class ModelBuildState
extends WizardState {
    public ModelBuildState(BrowserContext browserContext, Connection connection, boolean bl) throws Exception {
        super(browserContext, connection, bl);
    }

    public boolean synchronize(Vector vector, WizardStepState wizardStepState) {
        boolean bl = false;
        SynchronizeModelBuildProcess synchronizeModelBuildProcess = null;
        try {
            synchronizeModelBuildProcess = new SynchronizeModelBuildProcess((ModelDataState)wizardStepState, false);
            ProgressBar progressBar = new ProgressBar(BrowserFrame.getMainFrame(), ResourceUtilities.getUILabel("SYNCHRONIZE_MODEL_BUILD_DIALOG_TITLE"), synchronizeModelBuildProcess, true);
            synchronizeModelBuildProcess.setProgressBar(progressBar);
            progressBar.start(ResourceUtilities.getUILabel("SYNCHRONIZE_MODEL_BUILD_DIALOG_TITLE"), ResourceUtilities.getUILabel("SYNCHRONIZE_MODEL_BUILD_DESCRIPTION"));
            if (synchronizeModelBuildProcess.getException() != null) {
                this.doAbortCancel(synchronizeModelBuildProcess.getException());
            } else {
                if (progressBar.hasUserCancelled()) {
                    bl = false;
                    return bl;
                }
                bl = this.processSynchronizationAction(vector, wizardStepState, synchronizeModelBuildProcess);
            }
        }
        catch (Exception exception) {
            this.doAbortCancel(exception);
        }
        return bl;
    }

    protected boolean processSynchronizationAction(Vector vector, WizardStepState wizardStepState, SynchronizeModelBuildProcess synchronizeModelBuildProcess) throws Exception {
        boolean bl;
        ModelDataState modelDataState = (ModelDataState)this.getStep(StepType.DATA_STEP);
        int n = synchronizeModelBuildProcess.getValidationAction();
        if (n == SynchronizeModelBuildProcess.ACTION_NO_DIFFS) {
            LDSDataSource lDSDataSource = synchronizeModelBuildProcess.getNewLDSDataSource();
            int n2 = synchronizeModelBuildProcess.getCaseCountForNewLDSDataSource();
            modelDataState.setLDSDataSource(lDSDataSource);
            modelDataState.setCaseCount(n2);
            this.updateSynchronizationState(synchronizeModelBuildProcess);
            bl = true;
            vector.add(new StateValidation(DataStateInformational.SYNCHRONIZE_NO_CHANGES));
        } else if (n == SynchronizeModelBuildProcess.ACTION_DIFFS) {
            LDSDataSource lDSDataSource = synchronizeModelBuildProcess.getOldLDSDataSource();
            LDSDataSource lDSDataSource2 = synchronizeModelBuildProcess.getNewLDSDataSource();
            DiffLDSDataSource diffLDSDataSource = synchronizeModelBuildProcess.getChangesLDSDataSource();
            int n3 = synchronizeModelBuildProcess.getCaseCountForNewLDSDataSource();
            if (this.showSynchronizedAttributesDialog(lDSDataSource2, modelDataState.getCaseCount(), lDSDataSource, synchronizeModelBuildProcess.getCaseCountForNewLDSDataSource(), diffLDSDataSource)) {
                bl = true;
                modelDataState.setLDSDataSource(lDSDataSource2);
                modelDataState.setCaseCount(n3);
                this.updateSynchronizationState(synchronizeModelBuildProcess);
            } else {
                bl = false;
                wizardStepState.setState(StepStateType.DIRTY);
            }
        } else if (n == SynchronizeModelBuildProcess.ACTION_MISSING_TARGET) {
            bl = false;
        } else {
            DM4JException dM4JException = new DM4JException("Invalid syncrhonization validation action returned: " + Integer.toString(n));
            throw dM4JException;
        }
        return bl;
    }

    protected void updateSynchronizationState(SynchronizeModelBuildProcess synchronizeModelBuildProcess) throws Exception {
    }

    protected boolean showSynchronizedAttributesDialog(LDSDataSource lDSDataSource, int n, LDSDataSource lDSDataSource2, int n2, DiffLDSDataSource diffLDSDataSource) {
        boolean bl = false;
        try {
            ModelSignatureDiscrepancyWarningDialog modelSignatureDiscrepancyWarningDialog = new ModelSignatureDiscrepancyWarningDialog(this.getDialog(), this, lDSDataSource, n, lDSDataSource2, n2, diffLDSDataSource);
            bl = !modelSignatureDiscrepancyWarningDialog.isCancelled();
        }
        catch (Exception exception) {
            this.doAbortCancel(exception);
        }
        return bl;
    }
}

