/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.minings;

import java.util.Vector;
import javax.datamining.MiningAlgorithm;
import javax.datamining.base.Model;
import javax.datamining.resource.Connection;
import javax.datamining.supervised.SupervisedModel;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.ProgressBar;
import oracle.dmt.dm4j.datasources.TargetValueDataSource;
import oracle.dmt.dm4j.wizard.DM4JWizard;
import oracle.dmt.dm4j.wizard.director.minings.ValidateDataToModelProcess;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.minings.ClassificationModelLiftState;
import oracle.dmt.dm4j.wizard.state.minings.WizardState;
import oracle.dmt.dm4j.wizard.state.minings.WizardStepState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ClassificationModelState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ClassificationTestSettingState;
import oracle.dmt.dm4j.wizard.state.miningsteps.DataState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ModelState;
import oracle.dmt.dm4j.wizard.state.miningsteps.TargetValueState;
import oracle.dmt.dm4j.wizard.steps.minings.DM4JPage;
import oracle.dmt.dm4j.wizard.steps.minings.StepType;

public abstract class ClassificationModelResultState
extends WizardState {
    public ClassificationModelResultState(BrowserContext browserContext, Connection connection, boolean bl) throws Exception {
        super(browserContext, connection, bl);
    }

    public boolean synchronize(Vector vector, WizardStepState wizardStepState) {
        boolean bl = true;
        ValidateDataToModelProcess validateDataToModelProcess = null;
        try {
            ModelState modelState = (ModelState)this.getStep(StepType.MODEL_STEP);
            DataState dataState = (DataState)this.getStep(StepType.DATA_STEP);
            TargetValueState targetValueState = (TargetValueState)this.getStep(StepType.TARGET_VALUE_STEP);
            ClassificationTestSettingState classificationTestSettingState = (ClassificationTestSettingState)this.getStep(StepType.TEST_STEP);
            if (this.isOld()) {
                modelState.validateModelExists(vector);
                if (!vector.isEmpty()) {
                    bl = false;
                    return bl;
                }
            }
            Model model = modelState.getSelectedMiningModel();
            boolean bl2 = this.needTargetValues();
            validateDataToModelProcess = new ValidateDataToModelProcess(dataState, model, bl2, true);
            ProgressBar progressBar = new ProgressBar(BrowserFrame.getMainFrame(), ResourceUtilities.getUILabel("VALIDATE_MODEL_TO_DATA_DIALOG_TITLE"), validateDataToModelProcess, true);
            validateDataToModelProcess.setProgressBar(progressBar);
            progressBar.start(ResourceUtilities.getUILabel("VALIDATE_MODEL_TO_DATA_DIALOG_TITLE"), ResourceUtilities.getUILabel("VALIDATE_MODEL_TO_DATA_DESCRIPTION"));
            if (validateDataToModelProcess.getException() != null) {
                this.doAbortCancel(validateDataToModelProcess.getException());
            } else {
                if (progressBar.hasUserCancelled()) {
                    bl = false;
                    return bl;
                }
                Vector vector2 = validateDataToModelProcess.getMissingAttributes();
                if (vector2 != null) {
                    if (vector2.isEmpty() || !vector2.isEmpty() && !this.displayMissingAttributesDialog(validateDataToModelProcess.getModelLDSDataSource(), vector2)) {
                        bl = true;
                        dataState.setLDSDataSource(validateDataToModelProcess.getDataLDSDataSource());
                        modelState.setLDSDataSource(validateDataToModelProcess.getModelLDSDataSource());
                        ((ClassificationModelState)modelState).setTargetAttributeDataType(validateDataToModelProcess.getModelLDSDataSource().getTargetAttributeDataType());
                        ((ClassificationModelState)modelState).setTargetAttributeName(validateDataToModelProcess.getModelLDSDataSource().getTargetAttributeName());
                        if (validateDataToModelProcess.getTargetValuesDataSource() != null) {
                            targetValueState.setTargetValues(validateDataToModelProcess.getTargetValuesDataSource());
                            targetValueState.setTargetValueCostMatrix(validateDataToModelProcess.getTargetValueCostMatrixDataSource());
                        }
                        this.syncrhonizeTargetValue(targetValueState);
                        if (!this.syncrhonizeTestSetting(modelState, classificationTestSettingState)) {
                            // empty if block
                        }
                    } else {
                        bl = false;
                        wizardStepState.setState(StepStateType.DIRTY);
                    }
                }
            }
        }
        catch (Exception exception) {
            this.doAbortCancel(exception);
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean syncrhonizeTestSetting(ModelState modelState, ClassificationTestSettingState classificationTestSettingState) throws Exception {
        if (classificationTestSettingState == null) {
            return true;
        }
        Model model = modelState.restoreModel();
        if (model == null) return false;
        if (model.getMiningAlgorithm().compareTo(MiningAlgorithm.naiveBayes) == 0) return true;
        if (!(model instanceof SupervisedModel)) return false;
        classificationTestSettingState.setCrossValidationMFSName("CrossValidateTestMFSName");
        classificationTestSettingState.setStandardTest(true);
        this.enableTestSettingsPage(false);
        return true;
    }

    private void syncrhonizeTargetValue(TargetValueState targetValueState) {
        if (targetValueState == null) {
            return;
        }
        TargetValueDataSource targetValueDataSource = targetValueState.getTargetValuesDataSource();
        if (targetValueDataSource == null) {
            return;
        }
        int n = targetValueDataSource.getFirstRowByColumnValue(0, targetValueState.getSelectedTargetValue());
        if (n == -1 && targetValueDataSource.getRowCount() > 0) {
            String string = (String)targetValueDataSource.getData(0, 0);
            targetValueState.setSelectedTargetValue(string);
        }
    }

    protected boolean needTargetValues() {
        boolean bl = false;
        Class<ClassificationModelLiftState> clazz = ClassificationModelLiftState.class;
        if (clazz.isInstance(this)) {
            bl = true;
        }
        return bl;
    }

    protected void enableTestSettingsPage(boolean bl) throws Exception {
        DM4JWizard dM4JWizard = this.getWizard();
        int n = dM4JWizard.getPageCount();
        Class<DM4JPage> clazz = DM4JPage.class;
        DM4JPage dM4JPage = null;
        WizardPage wizardPage = null;
        for (int i = 0; i < n; ++i) {
            wizardPage = dM4JWizard.getPageAt(i);
            if (!clazz.isInstance(wizardPage) || !(dM4JPage = (DM4JPage)wizardPage).getStepType().equals(StepType.TEST_STEP)) continue;
            dM4JPage.getDM4JStep().refreshFromCurrent();
            dM4JPage.setEnabled(bl);
        }
    }
}

