/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.commonsteps;

import java.util.Vector;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.browser.LaunchPoint;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.state.commonsteps.DataState;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.dm4j.wizard.validation.commonsteps.DataStateError;

public class MultiRecordCaseData
extends DataState {
    private boolean m_multipleRecordCaseFormat = false;
    private StringBuffer m_sequenceIDMapping = new StringBuffer(0);
    private StringBuffer m_attributeNameMapping = new StringBuffer(0);
    private StringBuffer m_valueMapping = new StringBuffer(0);
    private boolean m_bSingleMetric = false;
    private boolean m_isOnlyTransactional = false;

    public MultiRecordCaseData(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType, false);
    }

    public void setIsOnlyTransactional(boolean bl) {
        if (bl) {
            this.m_multipleRecordCaseFormat = true;
        }
        this.m_isOnlyTransactional = bl;
    }

    public boolean isOnlyTransactional() {
        return this.m_isOnlyTransactional;
    }

    public void validate(Vector vector) throws Exception {
        super.validate(vector);
        if (vector.isEmpty()) {
            this.validateMultipleRecordCaseMapping(vector);
        }
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        } else {
            this.setState(StepStateType.DIRTY);
        }
    }

    public void refresh() throws Exception {
        super.refresh();
        this.clearMappingColumns();
    }

    public void load() throws Exception {
        super.load();
        this.loadDefaultRecordCaseFormat();
        if (!this.allowDataSelection()) {
            this.enablePage(true);
        }
    }

    private void loadDefaultRecordCaseFormat() {
        BrowserContext browserContext = this.getparentWizardState().getBrowserContext();
        if (!browserContext.getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE)) {
            this.m_multipleRecordCaseFormat = this.m_isOnlyTransactional;
            this.clearMappingColumns();
        }
    }

    public void clearMappingColumns() {
        this.m_sequenceIDMapping.delete(0, this.m_sequenceIDMapping.length());
        this.m_attributeNameMapping.delete(0, this.m_attributeNameMapping.length());
        this.m_valueMapping.delete(0, this.m_valueMapping.length());
        this.m_bSingleMetric = false;
    }

    public boolean isMultipleRecordCaseFormat() {
        return this.m_multipleRecordCaseFormat;
    }

    public void setMultipleRecordCaseFormat(boolean bl) {
        if (!this.m_multipleRecordCaseFormat == bl) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_multipleRecordCaseFormat = bl;
        }
    }

    public String getSequenceIDMapping() {
        return this.m_sequenceIDMapping.toString();
    }

    public void setSequenceIDMapping(String string) {
        String string2;
        if (string != null && !string.equals(string2 = this.m_sequenceIDMapping.toString())) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_sequenceIDMapping = new StringBuffer(string);
        }
    }

    public String getAttributeNameMapping() {
        return this.m_attributeNameMapping.toString();
    }

    public void setAttributeNameMapping(String string) {
        String string2;
        if (string != null && !string.equals(string2 = this.m_attributeNameMapping.toString())) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_attributeNameMapping = new StringBuffer(string);
        }
    }

    public String getValueMapping() {
        return this.m_valueMapping.toString();
    }

    public boolean isSingleMetric() {
        return this.m_bSingleMetric;
    }

    public void setValueMapping(String string) {
        String string2;
        if (string != null && !string.equals(string2 = this.m_valueMapping.toString())) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_valueMapping = new StringBuffer(string);
        }
    }

    public void setSingleMetric(boolean bl) {
        if (this.getState() == StepStateType.VALIDATED) {
            this.setState(StepStateType.DIRTY);
        }
        this.m_bSingleMetric = bl;
    }

    private void validateMultipleRecordCaseMapping(Vector vector) throws Exception {
        String[] stringArray;
        String string;
        if (!this.m_multipleRecordCaseFormat) {
            return;
        }
        if (this.m_multipleRecordCaseFormat && this.m_sequenceIDMapping.length() == 0 && this.m_attributeNameMapping.length() == 0 && this.m_valueMapping.length() == 0) {
            vector.add(new StateValidation(DataStateError.MRC_NAMES_EMPTY));
            return;
        }
        if (this.m_sequenceIDMapping.length() == 0) {
            string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            stringArray = new String[]{ResourceUtilities.getUILabel("MRC_FORMAT_SEQUENCE_ID")};
            vector.add(new StateValidation(DataStateError.SEQUENCE_ID_MAPPING_EMPTY, string, stringArray));
        }
        if (this.m_attributeNameMapping.length() == 0) {
            string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            stringArray = new String[]{ResourceUtilities.getUILabel("MRC_FORMAT_ATTRIBUTE_NAME")};
            vector.add(new StateValidation(DataStateError.ATTRIBUTE_NAME_MAPPING_EMPTY, string, stringArray));
        }
        if (this.m_valueMapping.length() == 0) {
            string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            stringArray = new String[]{ResourceUtilities.getUILabel("MRC_FORMAT_VALUE")};
            vector.add(new StateValidation(DataStateError.VALUE_MAPPING_EMPTY, string, stringArray));
        }
        if (this.m_valueMapping.toString().equals(this.m_attributeNameMapping.toString()) || this.m_valueMapping.toString().equals(this.m_sequenceIDMapping.toString()) || this.m_sequenceIDMapping.toString().equals(this.m_attributeNameMapping.toString())) {
            vector.add(new StateValidation(DataStateError.MRC_DUPLICATE_NAMES));
        }
    }

    public Vector validateMultipleRecordCaseMapping() throws Exception {
        Vector vector = new Vector();
        this.validateMultipleRecordCaseMapping(vector);
        return vector;
    }

    public boolean allowDataFormatSelection() {
        BrowserContext browserContext = this.getparentWizardState().getBrowserContext();
        return !browserContext.getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE);
    }
}

