/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state;

import java.text.MessageFormat;
import java.util.Vector;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.state.WizardStepStateInterface;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.validation.StateActionException;

public abstract class WizardStepState
implements WizardStepStateInterface {
    protected boolean m_enabled = true;
    private StepStateType m_stateType = StepStateType.UNLOADED;
    private String m_stepStateName;
    private WizardState m_parentWizardState;
    private StepType m_stepType;

    public WizardStepState(WizardState wizardState, String string, StepType stepType) {
        this.m_parentWizardState = wizardState;
        this.m_stepStateName = string;
        this.m_stepType = stepType;
    }

    public abstract void load() throws Exception;

    public void setEnabled(boolean bl) {
        this.m_enabled = bl;
    }

    public boolean getEnabled() {
        return this.m_enabled;
    }

    public abstract void refresh() throws Exception;

    public abstract void validate(Vector var1) throws Exception;

    public WizardState getparentWizardState() {
        return this.m_parentWizardState;
    }

    protected void validateLoadState() throws Exception {
        if (this.m_stateType != StepStateType.UNLOADED) {
            String string = ResourceUtilities.getstateExceptionMessage("STATE_ACTION_EXCEPTION");
            Object[] objectArray = new Object[]{this.m_stepStateName, ResourceUtilities.getstateExceptionMessage("LOAD_METHOD")};
            throw new StateActionException(MessageFormat.format(string, objectArray));
        }
    }

    public StepStateType getState() {
        return this.m_stateType;
    }

    public void setState(StepStateType stepStateType) {
        this.m_stateType = stepStateType;
    }

    public StepType getStepType() {
        return this.m_stepType;
    }

    public boolean postValidate(Vector vector) throws Exception {
        return true;
    }

    public void abortCleanUp() {
    }

    public void finishCleanUp() {
    }
}

