/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.director.transforms;

import oracle.dmt.dm4j.sql.PLSQLPackage;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.transforms.TransformWizardState;
import oracle.dmt.dm4j.wizard.state.transformsteps.ViewNameState;
import oracle.dmt.dm4j.wizard.steps.StepType;

public class TransformPLSQLPackage
extends PLSQLPackage {
    public static String TRANS_PROC_PREFIX = "T";
    private final int COMMENT_LENGTH_MAX = 4000;
    protected TransformWizardState m_state = null;
    protected String m_baseProcedureName = "";
    protected String m_baseProcedureComment = "";
    public static final String[] STANDARD_EXCEPTION_DEFINITIONS = new String[]{"object_not_found EXCEPTION;", "PRAGMA EXCEPTION_INIT(object_not_found, -00942);"};
    public static final String[] STANDARD_EXCEPTION_NAMES = new String[]{"object_not_found"};

    public TransformPLSQLPackage(TransformWizardState transformWizardState, String string, String string2) throws Exception {
        this.m_state = transformWizardState;
        this.m_baseProcedureName = string;
        this.m_baseProcedureComment = string2;
        this.setPackageName(string);
        this.generateDefaultPackageComment();
    }

    public TransformPLSQLPackage(TransformWizardState transformWizardState) throws Exception {
        this.m_state = transformWizardState;
        ViewNameState viewNameState = (ViewNameState)transformWizardState.getStep(StepType.NAME_STEP);
        this.m_baseProcedureName = viewNameState.getViewName();
        this.m_baseProcedureComment = viewNameState.getViewComment();
        this.generateDefaultPackageComment();
    }

    protected String generateDefaultPackageComment() throws Exception {
        String[] stringArray = new String[]{this.m_baseProcedureComment};
        StringBuffer stringBuffer = new StringBuffer(ResourceUtilities.getUILabelFromResource("PLSQL_PROCEDURE_COMMENT", stringArray));
        if (stringBuffer.length() > 4000) {
            stringBuffer.setLength(4000);
        }
        this.setPackageComment(stringBuffer.toString());
        return stringBuffer.toString();
    }
}

