/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.director.transforms;

import java.io.Serializable;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Vector;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.browser.LaunchPoint;
import oracle.dmt.dm4j.datasources.ComplexDataStructure;
import oracle.dmt.dm4j.datasources.DatabaseMetadata;
import oracle.dmt.dm4j.sql.PLSQLPackage;
import oracle.dmt.dm4j.wizard.director.transforms.TransformPLSQLPackage;
import oracle.dmt.dm4j.wizard.director.transforms.TransformsDirector;
import oracle.dmt.dm4j.wizard.state.transforms.TransformWizardState;
import oracle.dmt.dm4j.wizard.state.transformsteps.CaseCountDataState;
import oracle.dmt.dm4j.wizard.state.transformsteps.FinishState;
import oracle.dmt.dm4j.wizard.state.transformsteps.SampleSettingsState;
import oracle.dmt.dm4j.wizard.state.transformsteps.TableViewNameState;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;

public class SampleDirector
extends TransformsDirector {
    CaseCountDataState m_dataState;
    TableViewNameState m_nameState;
    SampleSettingsState m_settingsState;
    FinishState m_finishState;
    String m_caseID = "ROWNUM";
    private StringBuffer m_results = new StringBuffer();
    private StringBuffer m_queryResults = new StringBuffer();
    private TransformPLSQLPackage m_componentResults = null;
    protected Hashtable m_TxData;

    public SampleDirector(TransformWizardState transformWizardState) {
        super(transformWizardState);
    }

    public void construct() throws Exception {
        Serializable serializable;
        Object object;
        String string;
        Object object2;
        Object[] objectArray;
        Object[] objectArray2;
        this.m_dataState = (CaseCountDataState)this.getWizardState().getStep(StepType.DATA_STEP);
        this.m_nameState = (TableViewNameState)this.getWizardState().getStep(StepType.NAME_STEP);
        this.m_settingsState = (SampleSettingsState)this.getWizardState().getStep(StepType.SETTING_STEP);
        this.m_finishState = (FinishState)this.getWizardState().getStep(StepType.FINISH_STEP);
        boolean bl = this.m_dataState.isMultipleRecordCaseFormat();
        boolean bl2 = this.m_dataState.isSingleMetric();
        boolean bl3 = this.m_nameState.getCreateTable();
        String string2 = "TABLE";
        if (!bl3) {
            string2 = "VIEW";
        }
        boolean bl4 = this.m_settingsState.isSampleByNumOfCases();
        String string3 = "\"" + this.m_dataState.getSelectedSchemaName() + "\"" + ".\"" + this.m_dataState.getSelectedTableName() + "\"";
        String string4 = DM4JStringUtils.trimDoubleQuotes(this.m_nameState.getViewName());
        String string5 = "\"" + DM4JConnectionManager.getUser() + "\"." + "\"" + DM4JStringUtils.trimDoubleQuotes(this.m_nameState.getViewName()) + "\"";
        String string6 = "\"" + DM4JStringUtils.trimDoubleQuotes(this.m_nameState.getViewComment()) + "\"";
        long l = this.m_dataState.getCaseCount();
        long l2 = 0L;
        l2 = bl4 ? this.m_settingsState.getSampleNumberOfCases() : (long)(this.m_settingsState.getSamplePercentageOfCases() / 100.0 * (double)l);
        StringBuffer stringBuffer = null;
        StringBuffer stringBuffer2 = null;
        StringBuffer stringBuffer3 = null;
        if (bl && !bl2) {
            objectArray2 = this.m_dataState.getSequenceIDMapping();
            objectArray = new Object[]{string3, l + "", "\"" + (String)objectArray2 + "\"", this.m_settingsState.getRandomSeed() + "", l2 + ""};
            stringBuffer = new StringBuffer(MessageFormat.format("SELECT * FROM {0} WHERE ORA_HASH({2},({1}-1),{3}) < {4}", objectArray));
        } else if (bl2) {
            objectArray2 = new Object[]{this.m_dataState.getAttributeNameMapping(), string3, l + "", this.m_settingsState.getRandomSeed() + "", l2 + ""};
            stringBuffer = new StringBuffer(MessageFormat.format("SELECT {0} \nFROM (SELECT t.*, {5} RNUM FROM {1} t) WHERE ORA_HASH(RNUM,({2}-1),{3}) < {4}", objectArray2));
        } else {
            objectArray2 = this.getWizardState().getConnection();
            objectArray = DatabaseMetadata.getColumnNames((Connection)objectArray2, this.m_dataState.getSelectedSchemaName(), this.m_dataState.getSelectedTableName());
            object2 = new StringBuffer();
            int n = objectArray.size();
            for (int i = 0; i < n; ++i) {
                string = (String)objectArray.get(i);
                ((StringBuffer)object2).append("\"" + string + "\"");
                if (i >= n - 1) continue;
                ((StringBuffer)object2).append(", ");
            }
            object = this.getWizardState().getBrowserContext();
            string = this.m_caseID;
            if (((BrowserContext)object).getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE)) {
                serializable = ((BrowserContext)object).getInputDataDescriptor();
                this.m_caseID = ((ComplexDataStructure)serializable).getCaseId();
                string = "\"" + this.m_caseID + "\"";
            } else {
                try {
                    serializable = DatabaseMetadata.getSequenceColumn((Connection)objectArray2, this.m_dataState.getSelectedSchemaName(), this.m_dataState.getSelectedTableName());
                    if (serializable != null && ((Vector)serializable).size() > 0) {
                        this.m_caseID = ((Vector)serializable).get(0).toString();
                        string = "\"" + this.m_caseID + "\"";
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            serializable = new Object[]{((StringBuffer)object2).toString(), string3, l + "", this.m_settingsState.getRandomSeed() + "", l2 + "", string};
            stringBuffer = new StringBuffer(MessageFormat.format("SELECT {0} \nFROM (SELECT t.*, {5} RNUM FROM {1} t) WHERE ORA_HASH(RNUM,({2}-1),{3}) < {4}", (Object[])serializable));
        }
        objectArray2 = new Object[]{string2, string5};
        stringBuffer2 = new StringBuffer(MessageFormat.format("CREATE {0} {1} AS ", objectArray2));
        stringBuffer2.append(stringBuffer.toString());
        stringBuffer3 = new StringBuffer("COMMENT ON TABLE \"" + DM4JStringUtils.trimDoubleQuotes(this.m_nameState.getViewName()) + "\"" + " IS '" + SampleDirector.getReplacedString(string6, "'", "''") + "'");
        this.m_queryResults = stringBuffer;
        this.m_results.setLength(0);
        int n = 2;
        object2 = this.getWizardState().getBrowserContext();
        ComplexDataStructure complexDataStructure = null;
        object = null;
        string = null;
        if (((BrowserContext)object2).getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE)) {
            complexDataStructure = ((BrowserContext)object2).getInputDataDescriptor();
            n += 2 * complexDataStructure.getColumnMap().size();
        }
        serializable = new StringBuffer[n];
        serializable[0] = new StringBuffer(stringBuffer2.toString());
        serializable[1] = new StringBuffer(stringBuffer3.toString());
        if (((BrowserContext)object2).getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE)) {
            object = TransformsDirector.createCDSDataStructureAndSQL(complexDataStructure, "Random Sample Output", complexDataStructure.getCaseSchema(), complexDataStructure.getCaseTable(), string4, string2, (StringBuffer[])serializable, 2);
        }
        this.m_stmtComponentArray = serializable;
        if (object2 != null && complexDataStructure != null) {
            ComplexDataStructure complexDataStructure2 = ((BrowserContext)object2).getSampledInputDataDescriptor();
            if (complexDataStructure2 != null) {
                String string7 = complexDataStructure.getCaseTable();
                String string8 = ValidationUtil.createUniqueTableNameUsingRandom(string7, this.getWizardState().getConnection(), "_S");
                StringBuffer stringBuffer4 = new StringBuffer("CREATE VIEW ");
                stringBuffer4.append(DM4JStringUtils.addDoubleQuotes(DM4JStringUtils.trimDoubleQuotes(complexDataStructure2.getCaseSchema())));
                stringBuffer4.append(".");
                stringBuffer4.append(DM4JStringUtils.addDoubleQuotes(DM4JStringUtils.trimDoubleQuotes(string8)));
                stringBuffer4.append(" AS\n   (SELECT * FROM ");
                stringBuffer4.append(DM4JStringUtils.addDoubleQuotes(DM4JStringUtils.trimDoubleQuotes(complexDataStructure2.getCaseSchema())));
                stringBuffer4.append(".");
                stringBuffer4.append(DM4JStringUtils.addDoubleQuotes(DM4JStringUtils.trimDoubleQuotes(complexDataStructure2.getCaseTable())));
                stringBuffer4.append(")");
                this.m_stmtComponentArray = new StringBuffer[((Serializable)serializable).length + 1];
                System.arraycopy(serializable, 0, this.m_stmtComponentArray, 0, ((Serializable)serializable).length);
                this.m_stmtComponentArray[((Serializable)serializable).length] = stringBuffer4;
                ComplexDataStructure complexDataStructure3 = new ComplexDataStructure(complexDataStructure2.getName() + "SAMPLED_RESULT", string8, ((ComplexDataStructure)object).getCaseSchema(), ((ComplexDataStructure)object).getCaseId());
                complexDataStructure3.setColumnMap(((ComplexDataStructure)object).getColumnMap());
                this.getWizardState().setOutputSampledDataDescriptor(complexDataStructure3);
            }
        } else {
            this.m_stmtComponentArray = new StringBuffer[((Serializable)serializable).length];
            System.arraycopy(serializable, 0, this.m_stmtComponentArray, 0, ((Serializable)serializable).length);
        }
        this.getWizardState().setNewTranformName(DM4JConnectionManager.getUser(), string4, !bl3);
        this.getWizardState().setOutputDataDescriptor((ComplexDataStructure)object);
    }

    public String getConstructResults() throws Exception {
        return null;
    }

    public String getConstructResultsQueryOnly() throws Exception {
        return this.m_queryResults.toString();
    }

    public PLSQLPackage getConstructComponent() throws Exception {
        return null;
    }

    public Vector getTxSQL(String string) {
        if (this.m_TxData != null) {
            return (Vector)this.m_TxData.get(string);
        }
        return null;
    }

    public void setTxSQL(String string, Vector vector) {
        if (this.m_TxData == null) {
            this.m_TxData = new Hashtable();
        }
        this.m_TxData.put(string, vector);
    }

    public void constructCodeGen() throws Exception {
        Object object;
        Serializable serializable;
        Object object2;
        Object[] objectArray;
        this.m_dataState = (CaseCountDataState)this.getWizardState().getStep(StepType.DATA_STEP);
        this.m_nameState = (TableViewNameState)this.getWizardState().getStep(StepType.NAME_STEP);
        this.m_settingsState = (SampleSettingsState)this.getWizardState().getStep(StepType.SETTING_STEP);
        this.m_finishState = (FinishState)this.getWizardState().getStep(StepType.FINISH_STEP);
        boolean bl = this.m_dataState.isMultipleRecordCaseFormat();
        boolean bl2 = this.m_dataState.isSingleMetric();
        boolean bl3 = this.m_nameState.getCreateTable();
        String string = "TABLE";
        if (!bl3) {
            string = "VIEW";
        }
        boolean bl4 = this.m_settingsState.isSampleByNumOfCases();
        String string2 = "\"" + this.m_dataState.getSelectedSchemaName() + "\"" + ".\"" + this.m_dataState.getSelectedTableName() + "\"";
        String string3 = DM4JStringUtils.trimDoubleQuotes(this.m_nameState.getViewName());
        String string4 = "\"" + DM4JConnectionManager.getUser() + "\"." + "\"" + DM4JStringUtils.trimDoubleQuotes(this.m_nameState.getViewName()) + "\"";
        long l = this.m_dataState.getCaseCount();
        long l2 = 0L;
        l2 = bl4 ? this.m_settingsState.getSampleNumberOfCases() : (long)(this.m_settingsState.getSamplePercentageOfCases() / 100.0 * (double)l);
        StringBuffer stringBuffer = null;
        StringBuffer stringBuffer2 = null;
        if (bl && !bl2) {
            objectArray = this.m_dataState.getSequenceIDMapping();
            object2 = new Object[]{string2, l + "", "\"" + (String)objectArray + "\"", this.m_settingsState.getRandomSeed() + "", l2 + ""};
            stringBuffer = new StringBuffer(MessageFormat.format("SELECT * FROM {0} WHERE ORA_HASH({2},({1}-1),{3}) < {4}", (Object[])object2));
        } else if (bl2) {
            objectArray = new Object[]{this.m_dataState.getAttributeNameMapping(), string2, l + "", this.m_settingsState.getRandomSeed() + "", l2 + ""};
            stringBuffer = new StringBuffer(MessageFormat.format("SELECT {0} \nFROM (SELECT t.*, {5} RNUM FROM {1} t) WHERE ORA_HASH(RNUM,({2}-1),{3}) < {4}", objectArray));
        } else {
            Object[] objectArray2;
            objectArray = this.getWizardState().getConnection();
            object2 = DatabaseMetadata.getColumnNames((Connection)objectArray, this.m_dataState.getSelectedSchemaName(), this.m_dataState.getSelectedTableName());
            serializable = new StringBuffer();
            int n = ((Vector)object2).size();
            for (int i = 0; i < n; ++i) {
                objectArray2 = (String)((Vector)object2).get(i);
                ((StringBuffer)serializable).append("\"" + (String)objectArray2 + "\"");
                if (i >= n - 1) continue;
                ((StringBuffer)serializable).append(", ");
            }
            object = this.getWizardState().getBrowserContext();
            if (((BrowserContext)object).getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE)) {
                objectArray2 = ((BrowserContext)object).getInputDataDescriptor();
                this.m_caseID = objectArray2.getCaseId();
            } else {
                try {
                    objectArray2 = DatabaseMetadata.getSequenceColumn((Connection)objectArray, this.m_dataState.getSelectedSchemaName(), this.m_dataState.getSelectedTableName());
                    if (objectArray2 != null && objectArray2.size() > 0) {
                        this.m_caseID = objectArray2.get(0).toString();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            objectArray2 = new Object[]{((StringBuffer)serializable).toString(), string2, "{0}", this.m_settingsState.getRandomSeed() + "", l2 + "", "\"" + this.m_caseID + "\""};
            stringBuffer = new StringBuffer(MessageFormat.format("SELECT {0} \nFROM (SELECT t.*, {5} RNUM FROM {1} t) WHERE ORA_HASH(RNUM,({2}-1),{3}) < {4}", objectArray2));
        }
        objectArray = new Object[]{string, string4};
        stringBuffer2 = new StringBuffer(MessageFormat.format("CREATE {0} {1} AS ", objectArray));
        stringBuffer2.append(stringBuffer.toString());
        object2 = this.getWizardState().getBrowserContext();
        serializable = new Vector();
        ((Vector)serializable).add(stringBuffer2);
        ComplexDataStructure complexDataStructure = null;
        if (((BrowserContext)object2).getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE)) {
            complexDataStructure = ((BrowserContext)object2).getInputDataDescriptor();
            object = new Vector();
            TransformsDirector.createCDSDataStructureAndSQLCodeGen(complexDataStructure, "Random Sample Output", string3, string, (Vector)object);
            this.setTxSQL("Random Sample Output", (Vector)object);
        }
        this.m_stmtComponentArray = ((Vector)serializable).toArray(new StringBuffer[((Vector)serializable).size()]);
    }

    static interface SQL_TEMPLATES {
        public static final String QUERY_SAMPLE_2D_DATA = "SELECT {0} \nFROM (SELECT t.*, {5} RNUM FROM {1} t) WHERE ORA_HASH(RNUM,({2}-1),{3}) < {4}";
        public static final String QUERY_SAMPLE_XNL_DATA = "SELECT * FROM {0} WHERE ORA_HASH({2},({1}-1),{3}) < {4}";
        public static final String CREATE_TABLE_PREFIX = "CREATE {0} {1} AS ";
    }
}

