/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.director.transforms;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Vector;
import oracle.dmt.dm4j.browser.ProgressBar;
import oracle.dmt.dm4j.codegen.CodeGenResult;
import oracle.dmt.dm4j.codegen.ResultDBTypes;
import oracle.dmt.dm4j.wizard.director.transforms.TransformsDirector;
import oracle.dmt.dm4j.wizard.state.transforms.CodeGenState;
import oracle.dmt.dm4j.wizard.state.transforms.TransformWizardState;
import oracle.dmt.dm4j.wizard.state.transformsteps.CodeGenResultsState;
import oracle.dmt.dm4j.wizard.state.transformsteps.CodeGenTargetFileState;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.jdbc.OracleCallableStatement;

public class CodeGenDirector
extends TransformsDirector
implements Runnable {
    private Exception m_Exception;
    private ProgressBar m_bar;
    private Connection m_dbConn;
    private OracleCallableStatement m_statement;

    public CodeGenDirector(TransformWizardState transformWizardState) {
        super(transformWizardState);
    }

    public void setConnection(Connection connection) {
        this.m_dbConn = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block13: {
            block12: {
                this.construct();
                if (this.m_stmtComponentArray != null) {
                    for (int i = 0; i < this.m_stmtComponentArray.length; ++i) {
                        String string = this.m_stmtComponentArray[i].toString();
                        this.m_statement = (OracleCallableStatement)this.m_dbConn.prepareCall(string);
                        this.m_statement.execute();
                    }
                }
                Object var4_4 = null;
                if (this.m_statement == null) break block12;
                try {
                    this.m_statement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.m_bar.setDoneStatus();
            {
                break block13;
                catch (Exception exception) {
                    exception.printStackTrace();
                    this.m_Exception = exception;
                    Object var4_5 = null;
                    if (this.m_statement != null) {
                        try {
                            this.m_statement.close();
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                    }
                    this.m_bar.setDoneStatus();
                }
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                if (this.m_statement != null) {
                    try {
                        this.m_statement.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.m_bar.setDoneStatus();
                throw throwable;
            }
        }
    }

    public Exception getException() {
        return this.m_Exception;
    }

    public void setProgressBar(ProgressBar progressBar) {
        this.m_bar = progressBar;
    }

    public void construct() throws Exception {
        if (((CodeGenState)this.getWizardState()).isDataMiner()) {
            this.constructDataMiner();
            return;
        }
        if (!((CodeGenState)this.getWizardState()).isJDevOffline()) {
            this.constructJDevOnline();
        } else {
            this.constructJDevOffline();
        }
    }

    private void constructJDevOnline() throws Exception {
        CodeGenResult codeGenResult = this.getGeneratedCode();
        String string = codeGenResult.getPackageHdr();
        String string2 = codeGenResult.getPackageBody();
        if (string == null || string2 == null || 0 == string.length() || 0 == string2.length()) {
            return;
        }
        ArrayList arrayList = codeGenResult.getTypeObjects();
        if (arrayList != null) {
            Vector<StringBuffer> vector = new Vector<StringBuffer>();
            for (int i = 0; i < arrayList.size(); ++i) {
                ResultDBTypes resultDBTypes = (ResultDBTypes)arrayList.get(i);
                if (resultDBTypes == null) continue;
                vector.add(new StringBuffer(resultDBTypes.getDefinition()));
            }
            vector.add(new StringBuffer(string));
            vector.add(new StringBuffer(string2));
            this.m_stmtComponentArray = vector.toArray(new StringBuffer[vector.size()]);
        } else {
            this.m_stmtComponentArray = new StringBuffer[]{new StringBuffer(string), new StringBuffer(string2)};
        }
    }

    private CodeGenResult getGeneratedCode() throws Exception {
        CodeGenResultsState codeGenResultsState = (CodeGenResultsState)this.getWizardState().getStep(StepType.SETTING_STEP);
        CodeGenResult codeGenResult = codeGenResultsState.getResults();
        return codeGenResult;
    }

    private void constructDataMiner() throws Exception {
        CodeGenResult codeGenResult = this.getGeneratedCode();
        String string = codeGenResult.getPackageHdr();
        String string2 = codeGenResult.getPackageBody();
        if (string == null || string2 == null || 0 == string.length() || 0 == string2.length()) {
            return;
        }
        ArrayList arrayList = codeGenResult.getTypeObjects();
        PrintWriter printWriter = null;
        String string3 = null;
        try {
            block9: {
                try {
                    CodeGenTargetFileState codeGenTargetFileState = (CodeGenTargetFileState)this.getWizardState().getStep(StepType.SETTING_STEP_3);
                    string3 = codeGenTargetFileState.getFullFileName();
                    File file = new File(string3);
                    if (!file.createNewFile()) break block9;
                    printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file)));
                    if (arrayList != null) {
                        for (int i = 0; i < arrayList.size(); ++i) {
                            ResultDBTypes resultDBTypes = (ResultDBTypes)arrayList.get(i);
                            if (resultDBTypes == null) continue;
                            printWriter.write(resultDBTypes.getDefinition());
                            printWriter.write("\n");
                            printWriter.write("/");
                            printWriter.write("\n");
                        }
                    }
                    printWriter.write(string);
                    printWriter.write("\n");
                    printWriter.write("/");
                    printWriter.write("\n");
                    printWriter.write(string2);
                    printWriter.write("\n");
                    printWriter.write("/");
                    printWriter.write("\n");
                    printWriter.flush();
                }
                catch (Exception exception) {
                    System.out.println(exception + " Filename:" + string3);
                    throw exception;
                }
            }
            Object var12_12 = null;
            if (printWriter != null) {
                printWriter.close();
            }
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            if (printWriter != null) {
                printWriter.close();
            }
            throw throwable;
        }
    }

    private void constructJDevOffline() throws Exception {
        CodeGenResult codeGenResult = this.getGeneratedCode();
        String string = codeGenResult.getPackageHdr();
        String string2 = codeGenResult.getPackageBody();
        if (string == null || string2 == null || 0 == string.length() || 0 == string2.length()) {
            return;
        }
        ArrayList arrayList = codeGenResult.getTypeObjects();
        CodeGenState codeGenState = (CodeGenState)this.getWizardState();
        if (arrayList != null && !arrayList.isEmpty()) {
            codeGenState.setPackageTypes(arrayList);
        }
        codeGenState.setPackageSpec(string);
        codeGenState.setPackageBody(string2);
    }
}

