/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.director.minings;

import java.util.Vector;
import javax.datamining.resource.Connection;
import oracle.bali.ewt.event.Cancelable;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.browser.LongRunningProcess;
import oracle.dmt.dm4j.datasources.CaseCountDataSource2;
import oracle.dmt.dm4j.datasources.DiffLDSDataSource;
import oracle.dmt.dm4j.datasources.LDSDataSource;
import oracle.dmt.dm4j.datasources.MissingTargetAttributeException;
import oracle.dmt.dm4j.datasources.TargetValueCostMatrixDataSource;
import oracle.dmt.dm4j.datasources.TargetValueDataSource;
import oracle.dmt.dm4j.datasources.TargetValueWeightDataSource;
import oracle.dmt.dm4j.wizard.state.minings.WizardStepState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ClassificationAlgorithmState;
import oracle.dmt.dm4j.wizard.state.miningsteps.DataState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ModelDataState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ModelTargetValueState;
import oracle.dmt.dm4j.wizard.state.miningsteps.TargetState;
import oracle.dmt.dm4j.wizard.steps.minings.StepType;

public class SynchronizeModelBuildProcess
extends LongRunningProcess
implements Cancelable {
    private static String COMMAND_MONITOR = "SynchronizeModelBuildPanelMonitor";
    private boolean m_canceled = false;
    private boolean m_targetPriors = true;
    WizardStepState m_stepState;
    String m_targetAttributeName;
    boolean m_classificationModel = true;
    boolean m_allowTextDataTypes = false;
    Thread m_workerThread;
    Thread m_workerThread2;
    Thread m_workerThread3;
    boolean m_workerThread3Success = false;
    boolean m_targetMissing = false;
    private String CREATE_LDS = "CreateLDS";
    private String CREATE_CASE_COUNT = "CreateCaseCount";
    private String SYNCHRONIZE = "SyncrhonizeDataToModel";
    private LDSDataSource m_ldsDataSource;
    private LDSDataSource m_modelLdsDataSource;
    private DiffLDSDataSource m_diffLdsDataSource;
    private CaseCountDataSource2 m_caseCountDataSource;
    Thread m_targetValuesThread;
    Thread m_targetValueCostMatrixThread;
    Thread m_syncPriorsThread;
    Thread m_syncCostMatrixThread;
    boolean m_syncPriorsThreadSuccess = false;
    boolean m_syncCostMatrixThreadSuccess = false;
    boolean m_perform_synchronize_data = true;
    private ModelTargetValueState m_modelTargetValueState = null;
    private TargetState m_targetState = null;
    private TargetValueDataSource m_targetValueDataSource = null;
    private TargetValueCostMatrixDataSource m_targetValueCostMatrixDataSource = null;
    private String TARGET_VALUES_THREAD_NAME = "ExtractTargetValues";
    ModelDataState m_dataState;
    LDSDataSource m_oldLDSDataSource;
    LDSDataSource m_newLDSDataSource;
    DiffLDSDataSource m_changesLDSDataSource;
    int m_caseCountForNewLDS = 0;
    public static int ACTION_NO_DIFFS = 0;
    public static int ACTION_MISSING_TARGET = 1;
    public static int ACTION_DIFFS = 2;
    int m_compareAction = 0;

    public SynchronizeModelBuildProcess(ModelDataState modelDataState, String string) throws Exception {
        this.m_stepState = modelDataState;
        this.m_classificationModel = true;
        this.m_targetAttributeName = string;
    }

    public SynchronizeModelBuildProcess(ModelDataState modelDataState, String string, boolean bl) throws Exception {
        this.m_stepState = modelDataState;
        this.m_classificationModel = true;
        this.m_targetAttributeName = string;
        this.m_allowTextDataTypes = bl;
    }

    public SynchronizeModelBuildProcess(ModelDataState modelDataState) throws Exception {
        this.m_stepState = modelDataState;
        this.m_classificationModel = false;
    }

    public SynchronizeModelBuildProcess(ModelDataState modelDataState, boolean bl) throws Exception {
        this.m_stepState = modelDataState;
        this.m_classificationModel = false;
        this.m_allowTextDataTypes = bl;
    }

    public SynchronizeModelBuildProcess(ModelDataState modelDataState, boolean bl, boolean bl2) throws Exception {
        this.m_stepState = modelDataState;
        this.m_classificationModel = false;
        this.m_allowTextDataTypes = bl;
        this.m_perform_synchronize_data = bl2;
    }

    public void run() {
        try {
            this.createWorkerThreads();
        }
        catch (Exception exception) {
            this.setException(exception);
            this.getProgressBar().setDoneStatus();
            exception.printStackTrace();
            return;
        }
        try {
            this.m_workerThread.join();
            if (this.m_ldsDataSource.getException() != null) {
                throw this.m_ldsDataSource.getException();
            }
            this.m_workerThread2.join();
            if (this.m_caseCountDataSource.getException() != null) {
                throw this.m_caseCountDataSource.getException();
            }
            if (this.m_perform_synchronize_data) {
                this.createSynchronizationThread();
                this.m_workerThread3.join();
            }
            if (this.m_classificationModel) {
                this.extractTargetValues();
                this.validateTargetStatus();
                this.syncPriorValues();
            }
            if (!this.m_perform_synchronize_data) {
                this.setValidationAction(ACTION_NO_DIFFS);
                this.setNewLDSDataSource(this.m_ldsDataSource);
                this.setCaseCountForNewLDSDataSource(this.m_caseCountDataSource.getCaseCount());
                this.setTargetValueDataSource(this.m_targetValueDataSource);
                this.setTargetValueCostMatrixDataSource(this.m_targetValueCostMatrixDataSource);
            } else if (this.m_workerThread3Success && !this.m_targetMissing) {
                if (this.m_diffLdsDataSource.getRowCount() > 0 && this.getValidationAction() == ACTION_NO_DIFFS) {
                    this.setValidationAction(ACTION_DIFFS);
                    this.setOldLDSDataSource(this.m_modelLdsDataSource);
                    this.setNewLDSDataSource(this.m_ldsDataSource);
                    this.setChangesLDSDataSource(this.m_diffLdsDataSource);
                    this.setCaseCountForNewLDSDataSource(this.m_caseCountDataSource.getCaseCount());
                    this.setTargetValueDataSource(this.m_targetValueDataSource);
                    this.setTargetValueCostMatrixDataSource(this.m_targetValueCostMatrixDataSource);
                } else if (this.getValidationAction() == ACTION_NO_DIFFS) {
                    this.setNewLDSDataSource(this.m_ldsDataSource);
                    this.setCaseCountForNewLDSDataSource(this.m_caseCountDataSource.getCaseCount());
                    this.setTargetValueDataSource(this.m_targetValueDataSource);
                    this.setTargetValueCostMatrixDataSource(this.m_targetValueCostMatrixDataSource);
                }
            }
            this.getProgressBar().setDoneStatus();
        }
        catch (InterruptedException interruptedException) {
            this.setException(interruptedException);
            this.getProgressBar().setDoneStatus();
            this.m_workerThread.interrupt();
        }
        catch (Exception exception) {
            this.setException(exception);
            this.getProgressBar().setDoneStatus();
            this.m_workerThread.interrupt();
        }
    }

    private void extractTargetValues() throws Exception {
        if (this.m_workerThread3Success && !this.m_targetMissing) {
            this.createTargetValuesThread();
            this.m_targetValuesThread.join();
            this.createTargetValueCostMatrixThread();
            this.m_targetValueCostMatrixThread.join();
        }
    }

    private void validateTargetStatus() {
        if (this.m_workerThread3Success && this.m_targetMissing) {
            this.setValidationAction(ACTION_MISSING_TARGET);
        }
    }

    private void syncPriorValues() throws Exception {
        if (this.m_workerThread3Success && !this.m_targetMissing) {
            this.createSyncPriorsThread();
            this.m_syncPriorsThread.join();
            this.createSyncCostMatrixThread();
            this.m_syncCostMatrixThread.join();
        }
    }

    private void createWorkerThreads() throws Exception {
        Connection connection = DM4JConnectionManager.getConnection();
        this.m_ldsDataSource = new LDSDataSource(connection, ((DataState)this.m_stepState).getSelectedSchemaName(), ((DataState)this.m_stepState).getSelectedTableName(), this.m_allowTextDataTypes, true);
        this.m_workerThread = new Thread((Runnable)this.m_ldsDataSource, this.CREATE_LDS);
        this.m_workerThread.setDaemon(false);
        this.m_workerThread.start();
        Connection connection2 = DM4JConnectionManager.getConnection();
        this.m_caseCountDataSource = new CaseCountDataSource2(connection2, ((DataState)this.m_stepState).getSelectedSchemaName(), ((DataState)this.m_stepState).getSelectedTableName());
        this.m_workerThread2 = new Thread((Runnable)this.m_caseCountDataSource, this.CREATE_CASE_COUNT);
        this.m_workerThread2.setDaemon(false);
        this.m_workerThread2.start();
    }

    private void createSynchronizationThread() throws Exception {
        this.m_modelLdsDataSource = ((ModelDataState)this.m_stepState).getLDSDataSource();
        this.m_workerThread3 = new Thread(new Runnable(){

            public void run() {
                try {
                    SynchronizeModelBuildProcess.this.m_diffLdsDataSource = SynchronizeModelBuildProcess.this.m_modelLdsDataSource.syncrhonizeForModelBuild(SynchronizeModelBuildProcess.this.m_ldsDataSource, SynchronizeModelBuildProcess.this.m_targetAttributeName, true);
                    SynchronizeModelBuildProcess.this.m_workerThread3Success = true;
                }
                catch (MissingTargetAttributeException missingTargetAttributeException) {
                    SynchronizeModelBuildProcess.this.m_targetMissing = true;
                    SynchronizeModelBuildProcess.this.m_workerThread3Success = true;
                }
                catch (InterruptedException interruptedException) {
                    String string = "interrupted exception";
                }
                catch (Exception exception) {
                    SynchronizeModelBuildProcess.this.m_workerThread3Success = false;
                }
            }
        });
        this.m_workerThread3.setDaemon(false);
        this.m_workerThread3.start();
    }

    private void createTargetValuesThread() throws Exception {
        Object object;
        this.m_targetState = (TargetState)this.m_stepState.getparentWizardState().getStep(StepType.TARGET_STEP);
        WizardStepState wizardStepState = (WizardStepState)this.m_stepState.getparentWizardState().getStep(StepType.ALGORITHM_STEP);
        if (wizardStepState instanceof ClassificationAlgorithmState) {
            object = (ClassificationAlgorithmState)wizardStepState;
            this.m_targetPriors = !((ClassificationAlgorithmState)object).isSupportVectorMachineSelected();
        }
        object = DM4JConnectionManager.getConnection();
        this.m_targetValueDataSource = this.m_targetPriors ? new TargetValueDataSource((Connection)object, ((DataState)this.m_stepState).getSelectedSchemaName(), ((DataState)this.m_stepState).getSelectedTableName(), this.m_targetState.getTargetAttribute()) : new TargetValueWeightDataSource((Connection)object, ((DataState)this.m_stepState).getSelectedSchemaName(), ((DataState)this.m_stepState).getSelectedTableName(), this.m_targetState.getTargetAttribute());
        this.m_targetValuesThread = new Thread((Runnable)this.m_targetValueDataSource, this.TARGET_VALUES_THREAD_NAME);
        this.m_targetValuesThread.setDaemon(false);
        this.m_targetValuesThread.start();
    }

    private void createTargetValueCostMatrixThread() throws Exception {
        Vector vector = this.m_targetValueDataSource.getAttributes(0);
        this.m_targetValueCostMatrixDataSource = new TargetValueCostMatrixDataSource(vector);
        this.m_targetValueCostMatrixThread = new Thread((Runnable)this.m_targetValueCostMatrixDataSource, this.TARGET_VALUES_THREAD_NAME);
        this.m_targetValueCostMatrixThread.setDaemon(false);
        this.m_targetValueCostMatrixThread.start();
    }

    private void createSyncPriorsThread() throws Exception {
        this.m_modelTargetValueState = (ModelTargetValueState)this.m_stepState.getparentWizardState().getStep(StepType.TARGET_VALUE_STEP);
        this.m_syncPriorsThread = new Thread(new Runnable(){

            public void run() {
                try {
                    SynchronizeModelBuildProcess.this.m_targetValueDataSource.syncrhonizePriors(SynchronizeModelBuildProcess.this.m_modelTargetValueState.getTargetValuesDataSource());
                    SynchronizeModelBuildProcess.this.m_syncPriorsThreadSuccess = true;
                }
                catch (Exception exception) {
                    SynchronizeModelBuildProcess.this.m_syncPriorsThreadSuccess = false;
                }
            }
        });
        this.m_syncPriorsThread.setDaemon(false);
        this.m_syncPriorsThread.start();
    }

    private void createSyncCostMatrixThread() throws Exception {
        this.m_modelTargetValueState = (ModelTargetValueState)this.m_stepState.getparentWizardState().getStep(StepType.TARGET_VALUE_STEP);
        this.m_syncCostMatrixThread = new Thread(new Runnable(){

            public void run() {
                try {
                    SynchronizeModelBuildProcess.this.m_targetValueCostMatrixDataSource.syncrhonizeCostMatrix(SynchronizeModelBuildProcess.this.m_modelTargetValueState.getTargetValueCostMatrixDataSource());
                    SynchronizeModelBuildProcess.this.m_syncCostMatrixThreadSuccess = true;
                }
                catch (Exception exception) {
                    SynchronizeModelBuildProcess.this.m_syncCostMatrixThreadSuccess = false;
                }
            }
        });
        this.m_syncCostMatrixThread.setDaemon(false);
        this.m_syncCostMatrixThread.start();
    }

    public boolean isCancelled() {
        return this.m_canceled;
    }

    public void cancel() {
        this.m_canceled = true;
    }

    public int getValidationAction() {
        return this.m_compareAction;
    }

    protected void setValidationAction(int n) {
        this.m_compareAction = n;
    }

    public LDSDataSource getOldLDSDataSource() {
        return this.m_oldLDSDataSource;
    }

    protected void setOldLDSDataSource(LDSDataSource lDSDataSource) {
        this.m_oldLDSDataSource = lDSDataSource;
    }

    public LDSDataSource getNewLDSDataSource() {
        return this.m_newLDSDataSource;
    }

    protected void setNewLDSDataSource(LDSDataSource lDSDataSource) {
        this.m_newLDSDataSource = lDSDataSource;
    }

    public DiffLDSDataSource getChangesLDSDataSource() {
        return this.m_changesLDSDataSource;
    }

    protected void setChangesLDSDataSource(DiffLDSDataSource diffLDSDataSource) {
        this.m_changesLDSDataSource = diffLDSDataSource;
    }

    public int getCaseCountForNewLDSDataSource() {
        return this.m_caseCountForNewLDS;
    }

    protected void setCaseCountForNewLDSDataSource(int n) {
        this.m_caseCountForNewLDS = n;
    }

    public TargetValueDataSource getTargetValueDataSource() {
        return this.m_targetValueDataSource;
    }

    protected void setTargetValueDataSource(TargetValueDataSource targetValueDataSource) {
        this.m_targetValueDataSource = targetValueDataSource;
    }

    public TargetValueCostMatrixDataSource getTargetValueCostMatrixDataSource() {
        return this.m_targetValueCostMatrixDataSource;
    }

    protected void setTargetValueCostMatrixDataSource(TargetValueCostMatrixDataSource targetValueCostMatrixDataSource) {
        this.m_targetValueCostMatrixDataSource = targetValueCostMatrixDataSource;
    }
}

