/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.director.minings;

import java.util.Vector;
import javax.datamining.MiningAlgorithm;
import javax.datamining.MiningObject;
import javax.datamining.NamedObject;
import javax.datamining.algorithm.svm.KernelFunction;
import javax.datamining.base.AlgorithmSettings;
import javax.datamining.base.Model;
import javax.datamining.supervised.regression.RegressionModel;
import oracle.dmt.dm4j.wizard.dialogs.DialogUtilities;
import oracle.dmt.dm4j.wizard.director.minings.ModelBuildLoader;
import oracle.dmt.dm4j.wizard.state.minings.WizardState;
import oracle.dmt.dm4j.wizard.state.miningsteps.GeneralizedLinearModelAlgorithmState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ModelDataState;
import oracle.dmt.dm4j.wizard.state.miningsteps.RegressionAlgorithmState;
import oracle.dmt.dm4j.wizard.state.miningsteps.SupportVectorMachineAlgorithmState;
import oracle.dmt.dm4j.wizard.state.miningsteps.TargetState;
import oracle.dmt.dm4j.wizard.steps.minings.StepType;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.jdm.OraMiningAlgorithm;
import oracle.dmt.jdm.algorithm.glm.OraGLMRegressionSettings;
import oracle.dmt.jdm.algorithm.svm.regression.OraSVMRegressionSettings;

public class RegressionModelBuildLoader
extends ModelBuildLoader {
    public RegressionModelBuildLoader(WizardState wizardState, String string) {
        super(wizardState, string);
    }

    protected MiningObject restoreMiningObject(String string) throws Exception {
        RegressionModel regressionModel = (RegressionModel)this.m_state.getJDMConnection().retrieveObject(string, NamedObject.model);
        return regressionModel;
    }

    public boolean validate() throws Exception {
        Vector vector = new Vector();
        this.m_state.getStep(StepType.DATA_STEP).load();
        this.m_state.getStep(StepType.TARGET_STEP).load();
        ModelDataState modelDataState = (ModelDataState)this.m_state.getStep(StepType.DATA_STEP);
        boolean bl = this.m_state.synchronize(vector, modelDataState);
        if (ValidationUtil.validationsContainsErrors(vector)) {
            DialogUtilities.displayValidations(vector, null, this.m_state.getDialog());
        }
        return bl;
    }

    public void buildAlgorithmSetting(RegressionAlgorithmState regressionAlgorithmState) throws Exception {
        Model model = (Model)this.getMiningObj();
        AlgorithmSettings algorithmSettings = this.getMiningFunctionSettings().getAlgorithmSettings();
        MiningAlgorithm miningAlgorithm = model.getMiningAlgorithm();
        if (miningAlgorithm.equals(MiningAlgorithm.svmClassification)) {
            OraSVMRegressionSettings oraSVMRegressionSettings = (OraSVMRegressionSettings)algorithmSettings;
            double d = oraSVMRegressionSettings.getComplexityFactor();
            KernelFunction kernelFunction = oraSVMRegressionSettings.getKernelFunction();
            int n = 0;
            double d2 = 0.0;
            if (kernelFunction.equals(KernelFunction.kGaussian)) {
                n = oraSVMRegressionSettings.getKernelCacheSize();
                d2 = oraSVMRegressionSettings.getStandardDeviation();
            }
            double d3 = oraSVMRegressionSettings.getTolerance();
            double d4 = oraSVMRegressionSettings.getEpsilon();
            regressionAlgorithmState.setSupportVectorMachineSelected(true);
            SupportVectorMachineAlgorithmState supportVectorMachineAlgorithmState = new SupportVectorMachineAlgorithmState(regressionAlgorithmState, kernelFunction, new Double(d3), new Double(d2), new Double(d), new Integer(n / 1000000), new Double(d3), oraSVMRegressionSettings.getActiveLearning());
            regressionAlgorithmState.setSupportVectorMachineAlgorithm(supportVectorMachineAlgorithmState);
        } else if (miningAlgorithm.equals(OraMiningAlgorithm.generalizedLinearModel)) {
            OraGLMRegressionSettings oraGLMRegressionSettings = (OraGLMRegressionSettings)algorithmSettings;
            regressionAlgorithmState.setGeneralizedLinearModelSelected(true);
            GeneralizedLinearModelAlgorithmState generalizedLinearModelAlgorithmState = new GeneralizedLinearModelAlgorithmState(regressionAlgorithmState, (Double)oraGLMRegressionSettings.getConfidenceLevel(), oraGLMRegressionSettings.getDiagnosticsTableName() != null && oraGLMRegressionSettings.getDiagnosticsTableName().length() > 0, (boolean)oraGLMRegressionSettings.useRidgeRegression(), oraGLMRegressionSettings.getRidgeValue(), oraGLMRegressionSettings.produceVIFforRidgeRegression());
            regressionAlgorithmState.setGeneralizedLinearModelAlgorithm(generalizedLinearModelAlgorithmState);
        }
    }

    public void buildTargetAttribute(TargetState targetState) throws Exception {
        if (this.m_ds != null) {
            targetState.setTargetAttribute(this.m_ds.getTargetAttributeName());
        }
    }
}

