/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.director.minings;

import java.io.Serializable;
import javax.datamining.NamedObject;
import javax.datamining.task.BuildTask;
import javax.datamining.task.BuildTaskFactory;
import oracle.dmt.dm4j.activity.AbstractActivity;
import oracle.dmt.dm4j.activity.data.Table;
import oracle.dmt.dm4j.activity.steps.AbstractStep;
import oracle.dmt.dm4j.activity.steps.AbstractTransformationStep;
import oracle.dmt.dm4j.activity.steps.DiscretizationStep;
import oracle.dmt.dm4j.activity.steps.NormalizeStep;
import oracle.dmt.dm4j.activity.steps.ODMrTextStep;
import oracle.dmt.dm4j.datasources.ComplexDataStructure;
import oracle.dmt.dm4j.datasources.DMEMetadata;
import oracle.dmt.dm4j.wizard.director.minings.MiningBuilder;
import oracle.dmt.dm4j.wizard.state.minings.WizardState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ModelNameState;
import oracle.dmt.dm4j.wizard.steps.minings.StepType;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;

public abstract class ModelBuildBuilder
extends MiningBuilder {
    private BuildTaskFactory m_buildFactory = null;
    private String m_uniqueTaskName = null;

    protected ModelBuildBuilder(WizardState wizardState) {
        super(wizardState);
    }

    public void construct() throws Exception {
        super.construct();
        this.m_buildFactory = (BuildTaskFactory)this.m_state.getJDMConnection().getFactory("javax.datamining.task.BuildTask");
    }

    public void cleanUp() {
        if (!this.m_isCancelable) {
            return;
        }
        try {
            if (this.m_uniqueTaskName != null) {
                this.m_state.getJDMConnection().removeObject("\"" + this.m_uniqueTaskName + "\"", NamedObject.task);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        DMEMetadata dMEMetadata = DMEMetadata.getInstance();
        try {
            dMEMetadata.deleteBuildRec(this.m_state.getConnection(), "\"" + this.m_uniqueTaskName + "\"", null);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        super.cleanUp();
    }

    protected abstract String createFunctionSettings() throws Exception;

    protected String getMiningTask() throws Exception {
        ModelNameState modelNameState = (ModelNameState)this.m_state.getStep(StepType.NAME_STEP);
        String string = modelNameState.getModelName();
        this.m_uniqueTaskName = ValidationUtil.createUniqueJDMObjectName("DM4J$" + string, this.m_state.getConnection(), "_J");
        String string2 = this.createFunctionSettings();
        String string3 = this.createPhysicalDataSpecification();
        BuildTask buildTask = this.m_buildFactory.create("\"" + string3 + "\"", "\"" + string2 + "\"", string);
        this.m_state.getJDMConnection().saveObject("\"" + this.m_uniqueTaskName + "\"", buildTask, true);
        DMEMetadata dMEMetadata = DMEMetadata.getInstance();
        AbstractActivity abstractActivity = this.m_state.getBrowserContext().getActivity();
        String string4 = abstractActivity.getName();
        dMEMetadata.insertBuildRec(this.m_state.getConnection(), "\"" + this.m_uniqueTaskName + "\"", string, string4);
        if (abstractActivity != null) {
            Serializable serializable;
            Table table;
            AbstractTransformationStep abstractTransformationStep;
            AbstractStep abstractStep = abstractActivity.findNormalizeStep();
            if (abstractStep != null) {
                abstractTransformationStep = abstractStep;
                table = ((NormalizeStep)abstractTransformationStep).getNormalizationTable();
                if (table != null) {
                    dMEMetadata.insertXformTableRec(this.m_state.getConnection(), "\"" + this.m_uniqueTaskName + "\"", string, "XNORM", table.getName());
                }
            } else {
                abstractStep = abstractActivity.findDiscretizationStep();
                if (abstractStep != null) {
                    abstractTransformationStep = (DiscretizationStep)abstractStep;
                    table = ((DiscretizationStep)abstractTransformationStep).getDiscretizationNumTable();
                    serializable = ((DiscretizationStep)abstractTransformationStep).getDiscretizationCatTable();
                    if (table != null || serializable != null) {
                        String string5 = table != null ? table.getName() : null;
                        dMEMetadata.insertXformTableRec(this.m_state.getConnection(), "\"" + this.m_uniqueTaskName + "\"", string, "XBINN", string5);
                        String string6 = serializable != null ? ((Table)serializable).getName() : null;
                        dMEMetadata.insertXformTableRec(this.m_state.getConnection(), "\"" + this.m_uniqueTaskName + "\"", string, "XBINC", string6);
                    }
                }
            }
            abstractStep = abstractActivity.findStep(ODMrTextStep.class.getName());
            if (abstractStep != null) {
                abstractTransformationStep = (ODMrTextStep)abstractStep;
                table = ((ODMrTextStep)abstractTransformationStep).getFeatureTable();
                serializable = ((ODMrTextStep)abstractTransformationStep).getMappingOutputDataDescriptor();
                if (table != null) {
                    dMEMetadata.insertXformTableRec(this.m_state.getConnection(), "\"" + this.m_uniqueTaskName + "\"", string, "XTFEA", table.getName());
                }
                if (serializable != null) {
                    dMEMetadata.insertXformTableRec(this.m_state.getConnection(), "\"" + this.m_uniqueTaskName + "\"", string, "XTMAP", ((ComplexDataStructure)serializable).getCaseTable());
                }
            }
        }
        return "\"" + this.m_uniqueTaskName + "\"";
    }
}

