/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.director.minings;

import java.awt.Frame;
import java.util.StringTokenizer;
import javax.datamining.MiningObject;
import javax.datamining.base.Task;
import javax.swing.JDialog;
import oracle.dmt.dm4j.DM4JSimpleDialog;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.LongRunningProcess;
import oracle.dmt.dm4j.datasources.CaseCountDataSource;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.minings.WizardState;
import oracle.dmt.dm4j.wizard.state.miningsteps.DataState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ModelState;
import oracle.dmt.dm4j.wizard.state.miningsteps.SequenceAttributeState;
import oracle.dmt.dm4j.wizard.state.miningsteps.TargetValueState;
import oracle.dmt.dm4j.wizard.steps.minings.StepType;
import oracle.dmt.dm4j.wizard.steps.miningsteps.DataPanel;

public abstract class MiningLoader
extends LongRunningProcess {
    protected WizardState m_state;
    protected String m_miningObjName = null;
    protected MiningObject m_miningObject = null;
    protected String m_schema = null;
    protected String m_table = null;
    protected Task m_task = null;

    protected MiningLoader(WizardState wizardState, String string) {
        this.m_state = wizardState;
        this.m_miningObjName = string;
    }

    protected abstract Task findTaskForMiningObj(String var1) throws Exception;

    protected abstract MiningObject restoreMiningObject(String var1) throws Exception;

    protected String findPDSForMiningObj(String string) throws Exception {
        return null;
    }

    public boolean promptForPDS() throws Exception {
        if (this.m_schema != null && this.m_table != null) {
            return true;
        }
        boolean bl = false;
        DM4JSimpleDialog dM4JSimpleDialog = new DM4JSimpleDialog((Frame)BrowserFrame.getMainFrame(), "Select a datasource");
        boolean bl2 = this.m_state.isOld();
        JDialog jDialog = this.m_state.getDialog();
        this.m_state.setCopy(false);
        this.m_state.setDialog(dM4JSimpleDialog);
        DataState dataState = new DataState(this.m_state, "DATA_STEP_NAME", StepType.DATA_STEP);
        dataState.load();
        DataPanel dataPanel = new DataPanel(this.m_state, dataState, "MODEL_DATA_STEP_DESCRIPTION");
        dataPanel.load();
        dM4JSimpleDialog.setPanel(dataPanel);
        dM4JSimpleDialog.setSize(400, 300);
        dM4JSimpleDialog.setVisible(true);
        this.m_state.setCopy(bl2);
        this.m_state.setDialog(jDialog);
        if (dM4JSimpleDialog.isOk()) {
            this.m_schema = dataState.getSelectedSchemaName();
            this.m_table = dataState.getSelectedTableName();
            bl = true;
        }
        return bl;
    }

    public void construct() throws Exception {
    }

    public String getMiningObjName() {
        return this.m_miningObjName;
    }

    public MiningObject getMiningObj() {
        return this.m_miningObject;
    }

    public Task getMiningTask() {
        return this.m_task;
    }

    public boolean validate() throws Exception {
        return true;
    }

    public void run() {
        try {
            StringTokenizer stringTokenizer;
            this.getProgressBar().updateProgress(ResourceUtilities.getUILabel("MODEL_REBUILD_UPPER_STEP_1"), null);
            this.m_miningObject = this.restoreMiningObject(this.m_miningObjName);
            this.getProgressBar().updateProgress(ResourceUtilities.getUILabel("MODEL_REBUILD_UPPER_STEP_2"), null);
            String string = this.findPDSForMiningObj(this.m_miningObjName);
            if (string != null && (stringTokenizer = new StringTokenizer(string, ".")).countTokens() == 2) {
                this.m_schema = stringTokenizer.nextToken();
                this.m_table = stringTokenizer.nextToken();
            }
            this.getProgressBar().setDoneStatus();
        }
        catch (Exception exception) {
            this.setException(exception);
            this.getProgressBar().setDoneStatus();
        }
    }

    public void buildPhysicalDataSpecification(DataState dataState) throws Exception {
        dataState.setSelectedSchemaName(this.m_schema);
        dataState.setSelectedTableName(this.m_table);
        CaseCountDataSource caseCountDataSource = null;
        dataState.setMultipleRecordCaseFormat(false);
        caseCountDataSource = new CaseCountDataSource(this.m_state.getConnection(), this.m_schema, this.m_table);
        caseCountDataSource.run();
        dataState.setCaseCount(caseCountDataSource.getCaseCount());
    }

    public void buildLogicalDataSpecification(DataState dataState) throws Exception {
    }

    public void buildModel(ModelState modelState) throws Exception {
    }

    public void buildTargetValue(TargetValueState targetValueState) throws Exception {
    }

    public void buildSequenceAttribute(SequenceAttributeState sequenceAttributeState) throws Exception {
    }
}

