/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.director.minings;

import javax.datamining.ExecutionHandle;
import javax.datamining.MiningObject;
import javax.datamining.NamedObject;
import javax.datamining.base.Task;
import javax.datamining.data.AttributeDataType;
import javax.datamining.data.PhysicalAttribute;
import javax.datamining.data.PhysicalAttributeFactory;
import javax.datamining.data.PhysicalAttributeRole;
import javax.datamining.data.PhysicalDataSetFactory;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.browser.LongRunningProcess;
import oracle.dmt.dm4j.datasources.DatabaseMetadata;
import oracle.dmt.dm4j.wizard.director.minings.MiningBuilderInterface;
import oracle.dmt.dm4j.wizard.director.minings.ModelApplyBuilder;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.minings.WizardState;
import oracle.dmt.dm4j.wizard.state.minings.WizardStepState;
import oracle.dmt.dm4j.wizard.state.miningsteps.DataState;
import oracle.dmt.dm4j.wizard.state.miningsteps.FinishState;
import oracle.dmt.dm4j.wizard.state.miningsteps.SequenceAttributeState;
import oracle.dmt.dm4j.wizard.steps.minings.StepType;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;

public abstract class MiningBuilder
extends LongRunningProcess
implements MiningBuilderInterface {
    protected WizardState m_state;
    protected Task m_task = null;
    protected boolean m_isCancelable = true;
    protected PhysicalDataSetFactory m_pdsFactory = null;
    protected PhysicalAttributeFactory m_paFactory = null;
    protected String m_pds = null;
    protected String m_dataUsageView = null;

    protected MiningBuilder(WizardState wizardState) {
        this.m_state = wizardState;
    }

    public void construct() throws Exception {
        this.m_pdsFactory = (PhysicalDataSetFactory)this.m_state.getJDMConnection().getFactory("javax.datamining.data.PhysicalDataSet");
        this.m_paFactory = (PhysicalAttributeFactory)this.m_state.getJDMConnection().getFactory("javax.datamining.data.PhysicalAttribute");
    }

    protected abstract String getMiningTask() throws Exception;

    public void run() {
        try {
            this.getProgressBar().updateProgress(ResourceUtilities.getUILabel("MODEL_BUILD_UPPER_STEP_1"), null);
            String string = this.getMiningTask();
            this.m_isCancelable = false;
            ExecutionHandle executionHandle = this.m_state.getJDMConnection().execute(string);
            this.m_state.setNewTaskName(string);
            this.getProgressBar().setDoneStatus();
        }
        catch (Exception exception) {
            if (this.m_isCancelable) {
                this.cleanUp();
            }
            this.setException(exception);
            this.getProgressBar().setDoneStatus();
        }
    }

    public void clear() {
        this.m_task = null;
    }

    public void cleanUp() {
        if (!this.m_isCancelable) {
            return;
        }
        try {
            if (this.m_dataUsageView != null) {
                DatabaseMetadata.dropView(this.m_state.getConnection(), this.m_state.getConnection().getMetaData().getUserName(), this.m_dataUsageView);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.m_pds != null) {
                this.m_state.getJDMConnection().removeObject("\"" + this.m_pds + "\"", NamedObject.physicalDataSet);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected String createPhysicalDataSpecification() throws Exception {
        Object object;
        WizardStepState wizardStepState;
        DataState dataState = (DataState)this.m_state.getStep(StepType.DATA_STEP);
        String string = dataState.getSelectedTableName();
        if (!(this instanceof ModelApplyBuilder) && dataState.getLDSDataSource().isDirty()) {
            wizardStepState = (FinishState)this.m_state.getStep(StepType.FINISH_STEP);
            this.m_dataUsageView = DM4JStringUtils.trimDoubleQuotes(((FinishState)wizardStepState).getDataUsageViewName());
            object = dataState.getLDSDataSource().getSQLString();
            DatabaseMetadata.createViewAs(this.m_state.getConnection(), (String)object, this.m_state.getConnection().getMetaData().getUserName(), this.m_dataUsageView);
        }
        wizardStepState = (SequenceAttributeState)this.m_state.getStep(StepType.SEQ_ID_STEP);
        object = this.m_pdsFactory.create("\"" + (this.m_dataUsageView != null ? this.m_dataUsageView : string) + "\"", false);
        if (((SequenceAttributeState)wizardStepState).isCaseIdUsed()) {
            String string2 = ((SequenceAttributeState)wizardStepState).getSequenceAttribute();
            String string3 = ((SequenceAttributeState)wizardStepState).getSequenceAttributeDataType();
            AttributeDataType attributeDataType = null;
            if (string3.compareTo("NUMBER") == 0) {
                attributeDataType = AttributeDataType.integerType;
            } else if (string3.compareTo("FLOAT") == 0) {
                attributeDataType = AttributeDataType.doubleType;
            } else if (string3.compareTo("CHAR") == 0 || string3.compareTo("VARCHAR2") == 0) {
                attributeDataType = AttributeDataType.stringType;
            }
            PhysicalAttribute physicalAttribute = this.m_paFactory.create("\"" + string2 + "\"", attributeDataType, PhysicalAttributeRole.caseId);
            object.addAttribute(physicalAttribute);
        }
        this.m_pds = ValidationUtil.createUniqueJDMObjectName("DM4J$" + string, this.m_state.getConnection(), "_P");
        this.m_state.getJDMConnection().saveObject("\"" + this.m_pds + "\"", (MiningObject)object, true);
        return this.m_pds;
    }
}

