/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.director.minings;

import javax.datamining.NamedObject;
import javax.datamining.base.AlgorithmSettings;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.wizard.director.minings.ModelBuildBuilder;
import oracle.dmt.dm4j.wizard.state.minings.WizardState;
import oracle.dmt.dm4j.wizard.state.miningsteps.FeatureExtractionAlgorithmState;
import oracle.dmt.dm4j.wizard.state.miningsteps.FinishState;
import oracle.dmt.dm4j.wizard.steps.minings.StepType;
import oracle.dmt.jdm.algorithm.nmf.OraNMFAlgorithmSettingsFactory;
import oracle.dmt.jdm.algorithm.nmf.OraNMFAlgorithmSettingsImpl;
import oracle.dmt.jdm.featureextraction.OraFeatureExtractionSettings;
import oracle.dmt.jdm.featureextraction.OraFeatureExtractionSettingsFactory;

public class FeatureExtractionModelBuildBuilder
extends ModelBuildBuilder {
    private OraFeatureExtractionSettingsFactory m_feSettingFactory = (OraFeatureExtractionSettingsFactory)this.m_state.getJDMConnection().getFactory("oracle.dmt.jdm.featureextraction.OraFeatureExtractionSettings");
    private OraNMFAlgorithmSettingsFactory m_feAlgFactory = (OraNMFAlgorithmSettingsFactory)this.m_state.getJDMConnection().getFactory("oracle.dmt.jdm.algorithm.nmf.OraNMFAlgorithmSettings");
    private String m_settingName = null;

    public FeatureExtractionModelBuildBuilder(WizardState wizardState) throws Exception {
        super(wizardState);
    }

    public void cleanUp() {
        if (!this.m_isCancelable) {
            return;
        }
        try {
            if (this.m_settingName != null) {
                this.m_state.getJDMConnection().removeObject("\"" + this.m_settingName + "\"", NamedObject.buildSettings);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.cleanUp();
    }

    private AlgorithmSettings buildAlgorithmSetting(FeatureExtractionAlgorithmState featureExtractionAlgorithmState) throws Exception {
        OraNMFAlgorithmSettingsImpl oraNMFAlgorithmSettingsImpl = (OraNMFAlgorithmSettingsImpl)this.m_feAlgFactory.create();
        Integer n = featureExtractionAlgorithmState.getNMF().getMaxNumberOfIterations();
        oraNMFAlgorithmSettingsImpl.setMaxNumberOfIterations(n.longValue());
        Double d = featureExtractionAlgorithmState.getNMF().getMinConvergenceTolerance();
        oraNMFAlgorithmSettingsImpl.setMinConvergenceTolerance(d);
        if (featureExtractionAlgorithmState.getNMF().isRandomSeedSelected()) {
            oraNMFAlgorithmSettingsImpl.setSeedValue(featureExtractionAlgorithmState.getNMF().getRandomSeed());
        }
        return oraNMFAlgorithmSettingsImpl;
    }

    protected String createFunctionSettings() throws Exception {
        FinishState finishState = (FinishState)this.m_state.getStep(StepType.FINISH_STEP);
        OraFeatureExtractionSettings oraFeatureExtractionSettings = this.m_feSettingFactory.create();
        FeatureExtractionAlgorithmState featureExtractionAlgorithmState = (FeatureExtractionAlgorithmState)this.m_state.getStep(StepType.ALGORITHM_STEP);
        AlgorithmSettings algorithmSettings = this.buildAlgorithmSetting(featureExtractionAlgorithmState);
        oraFeatureExtractionSettings.setAlgorithmSettings(algorithmSettings);
        if (featureExtractionAlgorithmState.getNMF().isNumberofFeaturesSelected()) {
            oraFeatureExtractionSettings.setNumberOfFeatures(featureExtractionAlgorithmState.getNMF().getNumberofFeatures());
        }
        this.m_settingName = DM4JStringUtils.trimDoubleQuotes(finishState.getMiningSettingsName());
        this.m_state.getJDMConnection().saveObject("\"" + this.m_settingName + "\"", oraFeatureExtractionSettings, true);
        return this.m_settingName;
    }
}

