/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.director.minings;

import javax.datamining.NamedObject;
import javax.datamining.base.AlgorithmSettings;
import javax.datamining.clustering.ClusteringAlgorithmSettings;
import javax.datamining.clustering.ClusteringSettings;
import javax.datamining.clustering.ClusteringSettingsFactory;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.wizard.director.minings.ModelBuildBuilder;
import oracle.dmt.dm4j.wizard.state.minings.WizardState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ClusteringAlgorithmState;
import oracle.dmt.dm4j.wizard.state.miningsteps.FinishState;
import oracle.dmt.dm4j.wizard.steps.minings.StepType;
import oracle.dmt.jdm.algorithm.kmeans.OraKMeansSettings;
import oracle.dmt.jdm.algorithm.kmeans.OraKMeansSettingsFactory;
import oracle.dmt.jdm.algorithm.ocluster.OraOClusterSettings;
import oracle.dmt.jdm.algorithm.ocluster.OraOClusterSettingsFactory;

public class ClusteringModelBuildBuilder
extends ModelBuildBuilder {
    private ClusteringSettingsFactory m_clusFactory = null;
    private OraOClusterSettingsFactory m_oclusterFactory = null;
    private OraKMeansSettingsFactory m_kmeansFactory = null;
    private String m_settingName = null;

    public ClusteringModelBuildBuilder(WizardState wizardState) {
        super(wizardState);
    }

    public void construct() throws Exception {
        super.construct();
        this.m_clusFactory = (ClusteringSettingsFactory)this.m_state.getJDMConnection().getFactory("javax.datamining.clustering.ClusteringSettings");
        this.m_oclusterFactory = (OraOClusterSettingsFactory)this.m_state.getJDMConnection().getFactory("oracle.dmt.jdm.algorithm.ocluster.OraOClusterSettings");
        this.m_kmeansFactory = (OraKMeansSettingsFactory)this.m_state.getJDMConnection().getFactory("javax.datamining.algorithm.kmeans.KMeansSettings");
    }

    public void cleanUp() {
        if (!this.m_isCancelable) {
            return;
        }
        try {
            if (this.m_settingName != null) {
                this.m_state.getJDMConnection().removeObject("\"" + this.m_settingName + "\"", NamedObject.buildSettings);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.cleanUp();
    }

    private AlgorithmSettings buildAlgorithmSetting(ClusteringAlgorithmState clusteringAlgorithmState) throws Exception {
        ClusteringAlgorithmSettings clusteringAlgorithmSettings = null;
        if (clusteringAlgorithmState.isOClusterSelected()) {
            OraOClusterSettings oraOClusterSettings = this.m_oclusterFactory.create();
            Double d = clusteringAlgorithmState.getOCluster().getSensitivity();
            Long l = clusteringAlgorithmState.getOCluster().getMaximumBufferSize();
            oraOClusterSettings.setSensitivity(d);
            oraOClusterSettings.setBufferSize(l);
            clusteringAlgorithmSettings = oraOClusterSettings;
        } else {
            OraKMeansSettings oraKMeansSettings = (OraKMeansSettings)this.m_kmeansFactory.create();
            Double d = clusteringAlgorithmState.getKMeans().getMinimumErrorTolerance();
            Double d2 = clusteringAlgorithmState.getKMeans().getMinimumSupportPercentage();
            Integer n = clusteringAlgorithmState.getKMeans().getMaximumIterations();
            Integer n2 = clusteringAlgorithmState.getKMeans().getNumberOfBins();
            Integer n3 = clusteringAlgorithmState.getKMeans().getBlockGrowth();
            oraKMeansSettings.setMinErrorTolerance(d);
            oraKMeansSettings.setMaxNumberOfIterations(n);
            oraKMeansSettings.setDistanceFunction(clusteringAlgorithmState.getKMeans().getDistanceFunction());
            oraKMeansSettings.setSplitCriterion(clusteringAlgorithmState.getKMeans().getSplitCriterion());
            oraKMeansSettings.setNumberOfBins(n2);
            oraKMeansSettings.setMinPercentageAtrrSupport(d2);
            oraKMeansSettings.setBlockGrowth(n3);
            clusteringAlgorithmSettings = oraKMeansSettings;
        }
        return clusteringAlgorithmSettings;
    }

    protected String createFunctionSettings() throws Exception {
        FinishState finishState = (FinishState)this.m_state.getStep(StepType.FINISH_STEP);
        ClusteringSettings clusteringSettings = this.m_clusFactory.create();
        ClusteringAlgorithmState clusteringAlgorithmState = (ClusteringAlgorithmState)this.m_state.getStep(StepType.ALGORITHM_STEP);
        int n = 0;
        n = clusteringAlgorithmState.isOClusterSelected() ? clusteringAlgorithmState.getOClusterNumberOfClusters().intValue() : clusteringAlgorithmState.getKMeansNumberOfClusters().intValue();
        clusteringSettings.setMaxNumberOfClusters(n);
        AlgorithmSettings algorithmSettings = this.buildAlgorithmSetting(clusteringAlgorithmState);
        clusteringSettings.setAlgorithmSettings(algorithmSettings);
        this.m_settingName = DM4JStringUtils.trimDoubleQuotes(finishState.getMiningSettingsName());
        this.m_state.getJDMConnection().saveObject("\"" + this.m_settingName + "\"", clusteringSettings, true);
        return this.m_settingName;
    }
}

