/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.director.minings;

import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.datamining.MiningObject;
import javax.datamining.NamedObject;
import javax.datamining.base.Model;
import javax.datamining.base.Task;
import javax.datamining.data.PhysicalAttribute;
import javax.datamining.data.PhysicalAttributeRole;
import javax.datamining.resource.Connection;
import javax.datamining.supervised.TestMetrics;
import javax.datamining.supervised.TestTask;
import javax.datamining.supervised.classification.ClassificationTestMetrics;
import javax.datamining.supervised.classification.ClassificationTestTask;
import javax.datamining.supervised.classification.CostMatrix;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.datasources.DMEMetadata;
import oracle.dmt.dm4j.datasources.DatabaseMetadata;
import oracle.dmt.dm4j.datasources.LDSDataSource;
import oracle.dmt.dm4j.datasources.TargetValueCostMatrixDataSource;
import oracle.dmt.dm4j.datasources.TargetValueDataSource;
import oracle.dmt.dm4j.wizard.dialogs.DialogUtilities;
import oracle.dmt.dm4j.wizard.director.minings.MiningLoader;
import oracle.dmt.dm4j.wizard.state.minings.WizardState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ClassificationTestMetricsOptionsState;
import oracle.dmt.dm4j.wizard.state.miningsteps.DataState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ModelState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ModelTestDataState;
import oracle.dmt.dm4j.wizard.state.miningsteps.SequenceAttributeState;
import oracle.dmt.dm4j.wizard.state.miningsteps.TargetValueState;
import oracle.dmt.dm4j.wizard.state.miningsteps.TestTargetValueState;
import oracle.dmt.dm4j.wizard.steps.minings.StepType;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.jdm.supervised.OraTestTask;

public class ClassificationModelLiftLoader
extends MiningLoader {
    protected LDSDataSource m_ds = null;
    protected TargetValueDataSource m_tvds = null;

    public ClassificationModelLiftLoader(WizardState wizardState, String string) {
        super(wizardState, string);
    }

    protected String findPDSForMiningObj(String string) throws Exception {
        String string2 = null;
        this.m_task = this.findTaskForMiningObj(string);
        if (this.m_task != null) {
            OraTestTask oraTestTask = (OraTestTask)this.m_task;
            string2 = oraTestTask.getTestData().getURI();
            BrowserFrame browserFrame = BrowserFrame.getMainFrame();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
            String string3 = null;
            String string4 = null;
            if (stringTokenizer.countTokens() == 2) {
                string3 = stringTokenizer.nextToken();
                string4 = stringTokenizer.nextToken();
            } else {
                string3 = DM4JConnectionManager.getUser();
                string4 = string2;
            }
            string2 = string3 + "." + string4;
            if (!DatabaseMetadata.datasourceExists(this.m_state.getConnection(), string3, string4)) {
                string2 = null;
            }
        }
        return string2;
    }

    protected Task findTaskForMiningObj(String string) {
        Task task = null;
        try {
            DMEMetadata dMEMetadata = DMEMetadata.getInstance();
            String string2 = dMEMetadata.getTaskNameForMiningObject(this.m_state.getConnection(), "TEST", string);
            if (string2 != null) {
                task = (Task)this.m_state.getJDMConnection().retrieveObject("\"" + string2 + "\"", NamedObject.task);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return task;
    }

    protected MiningObject restoreMiningObject(String string) throws Exception {
        TestMetrics testMetrics = (TestMetrics)this.m_state.getJDMConnection().retrieveObject(string, NamedObject.testMetrics);
        return testMetrics;
    }

    public boolean validate() throws Exception {
        Vector vector = new Vector();
        this.m_state.getStep(StepType.MODEL_STEP).load();
        this.m_state.getStep(StepType.DATA_STEP).load();
        ModelTestDataState modelTestDataState = (ModelTestDataState)this.m_state.getStep(StepType.DATA_STEP);
        boolean bl = this.m_state.synchronize(vector, modelTestDataState);
        if (ValidationUtil.validationsContainsErrors(vector)) {
            DialogUtilities.displayValidations(vector, null, this.m_state.getDialog());
        }
        return bl;
    }

    public void construct() throws Exception {
        super.construct();
    }

    public void buildModel(ModelState modelState) throws Exception {
        TestTask testTask = (TestTask)this.m_task;
        String string = testTask.getModelName();
        modelState.setSelectedModelName(string);
    }

    public void buildLogicalDataSpecification(DataState dataState) throws Exception {
        if (this.m_ds == null) {
            TestMetrics testMetrics = (TestMetrics)this.getMiningObj();
            String string = testMetrics.getModelName();
            Connection connection = DM4JConnectionManager.getConnection();
            MiningObject miningObject = connection.retrieveObject(string, NamedObject.model);
            this.m_ds = new LDSDataSource(connection, (Model)miningObject);
            this.m_ds.run();
            dataState.setLDSDataSource(this.m_ds);
        }
    }

    public void buildTargetValue(TargetValueState targetValueState) throws Exception {
        Object object;
        if (this.m_tvds == null) {
            object = DM4JConnectionManager.getConnection();
            this.m_tvds = new TargetValueDataSource((Connection)object, this.m_schema, this.m_table, this.m_ds.getTargetAttributeName());
            this.m_tvds.run();
        }
        targetValueState.setTargetValues(this.m_tvds);
        object = (ClassificationTestTask)this.m_task;
        Object object2 = object.getPositiveTargetValue();
        targetValueState.setSelectedTargetValue((String)object2);
    }

    public void buildSequenceAttribute(SequenceAttributeState sequenceAttributeState) throws Exception {
        OraTestTask oraTestTask = (OraTestTask)this.m_task;
        Collection collection = oraTestTask.getTestData().getAttributes();
        Iterator iterator = collection.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            PhysicalAttribute physicalAttribute = (PhysicalAttribute)iterator.next();
            PhysicalAttributeRole physicalAttributeRole = physicalAttribute.getRole();
            if (!physicalAttributeRole.equals(PhysicalAttributeRole.caseId)) continue;
            sequenceAttributeState.syncSequenceAttribute(physicalAttribute.getName());
            bl = true;
            break;
        }
        sequenceAttributeState.setUseCaseId(bl);
    }

    public void buildResultOptions(ClassificationTestMetricsOptionsState classificationTestMetricsOptionsState) throws Exception {
        ClassificationTestMetrics classificationTestMetrics = (ClassificationTestMetrics)this.getMiningObj();
        classificationTestMetricsOptionsState.setGenerateTest(classificationTestMetrics.getConfusionMatrix() != null);
        if (classificationTestMetrics.getLift() != null) {
            classificationTestMetricsOptionsState.setGenerateLift(true);
            ClassificationTestTask classificationTestTask = (ClassificationTestTask)this.m_task;
            classificationTestMetricsOptionsState.setNumLiftQuantile(new Integer(classificationTestTask.getNumberOfLiftQuantiles()));
        } else {
            classificationTestMetricsOptionsState.setGenerateLift(false);
        }
        classificationTestMetricsOptionsState.setGenerateROC(classificationTestMetrics.getROC() != null);
    }

    public void buildCostMatrix(TestTargetValueState testTargetValueState) throws Exception {
        ClassificationTestTask classificationTestTask = (ClassificationTestTask)this.m_task;
        String string = classificationTestTask.getCostMatrixName();
        if (string != null) {
            CostMatrix costMatrix = (CostMatrix)this.m_state.getJDMConnection().retrieveObject(string, NamedObject.costMatrix);
            testTargetValueState.setWeightedScoreIndicator(true);
            testTargetValueState.setFalsePositiveIndicator(false);
            testTargetValueState.setWeight("1.0");
            TargetValueCostMatrixDataSource targetValueCostMatrixDataSource = new TargetValueCostMatrixDataSource(new Vector(costMatrix.getCategories()));
            targetValueCostMatrixDataSource.run();
            targetValueCostMatrixDataSource.setCostMatrix(costMatrix);
            testTargetValueState.setTargetValueCostMatrix(targetValueCostMatrixDataSource);
        }
    }
}

