/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.director.minings;

import java.util.Collection;
import java.util.Iterator;
import javax.datamining.ExecutionHandle;
import javax.datamining.ExecutionState;
import javax.datamining.ExecutionStatus;
import javax.datamining.NamedObject;
import javax.datamining.data.CategorySetFactory;
import javax.datamining.supervised.classification.ClassificationTestMetricOption;
import javax.datamining.supervised.classification.ClassificationTestMetrics;
import javax.datamining.supervised.classification.ClassificationTestTask;
import javax.datamining.supervised.classification.ClassificationTestTaskFactory;
import javax.datamining.supervised.classification.ConfusionMatrix;
import javax.datamining.supervised.classification.CostMatrix;
import javax.datamining.supervised.classification.CostMatrixFactory;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.activity.AbstractActivity;
import oracle.dmt.dm4j.datasources.DMEMetadata;
import oracle.dmt.dm4j.datasources.TargetValueCostMatrixDataSource;
import oracle.dmt.dm4j.wizard.director.minings.MiningBuilder;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.minings.WizardState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ClassificationModelState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ClassificationTestMetricsOptionsState;
import oracle.dmt.dm4j.wizard.state.miningsteps.FinishState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ModelLiftNameState;
import oracle.dmt.dm4j.wizard.state.miningsteps.TestTargetValueState;
import oracle.dmt.dm4j.wizard.steps.minings.StepType;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.jdm.supervised.classification.OraClassificationTestTask;

public class ClassificationModelLiftBuilder
extends MiningBuilder {
    private ClassificationTestTaskFactory m_testFactory = null;
    private CostMatrixFactory m_costMatrixFactory = null;
    private CategorySetFactory m_catSetFactory = null;
    private String m_costMatrixName = null;
    private String m_uniqueTaskName = null;

    public ClassificationModelLiftBuilder(WizardState wizardState) {
        super(wizardState);
    }

    public void construct() throws Exception {
        super.construct();
        this.m_testFactory = (ClassificationTestTaskFactory)this.m_state.getJDMConnection().getFactory("javax.datamining.supervised.classification.ClassificationTestTask");
        this.m_costMatrixFactory = (CostMatrixFactory)this.m_state.getJDMConnection().getFactory("javax.datamining.supervised.classification.CostMatrix");
        this.m_catSetFactory = (CategorySetFactory)this.m_state.getJDMConnection().getFactory("javax.datamining.data.CategorySet");
    }

    public void cleanUp() {
        if (!this.m_isCancelable) {
            return;
        }
        try {
            if (this.m_costMatrixName != null) {
                this.m_state.getJDMConnection().removeObject("\"" + this.m_costMatrixName + "\"", NamedObject.costMatrix);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.m_uniqueTaskName != null) {
                this.m_state.getJDMConnection().removeObject("\"" + this.m_uniqueTaskName + "\"", NamedObject.task);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            DMEMetadata dMEMetadata = DMEMetadata.getInstance();
            dMEMetadata.deleteTestRec(this.m_state.getConnection(), "\"" + this.m_uniqueTaskName + "\"", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.cleanUp();
    }

    protected String getMiningTask() throws Exception {
        CostMatrix costMatrix;
        Object object;
        ClassificationTestMetricsOptionsState classificationTestMetricsOptionsState = (ClassificationTestMetricsOptionsState)this.m_state.getStep(StepType.TM_OPTIONS_STEP);
        ClassificationModelState classificationModelState = (ClassificationModelState)this.m_state.getStep(StepType.MODEL_STEP);
        FinishState finishState = (FinishState)this.m_state.getStep(StepType.FINISH_STEP);
        String string = classificationModelState.getSelectedModelName();
        ModelLiftNameState modelLiftNameState = (ModelLiftNameState)this.m_state.getStep(StepType.NAME_STEP);
        String string2 = DM4JStringUtils.trimDoubleQuotes(modelLiftNameState.getTestMetricName());
        this.m_uniqueTaskName = ValidationUtil.createUniqueJDMObjectName(ValidationUtil.addPrefixToName("DM4J$", string2), this.m_state.getConnection(), "_J");
        String string3 = this.createPhysicalDataSpecification();
        ClassificationTestTask classificationTestTask = this.m_testFactory.create("\"" + string3 + "\"", string, "\"" + string2 + "\"");
        classificationTestTask.computeMetric(ClassificationTestMetricOption.confusionMatrix, classificationTestMetricsOptionsState.IsGenerateTest());
        if (classificationTestMetricsOptionsState.IsGenerateTest()) {
            object = DM4JStringUtils.trimDoubleQuotes(finishState.getConfustionMatrixName());
            ((OraClassificationTestTask)classificationTestTask).setTableName(ClassificationTestMetricOption.confusionMatrix, "\"" + (String)object + "\"");
        }
        classificationTestTask.computeMetric(ClassificationTestMetricOption.lift, classificationTestMetricsOptionsState.IsGenerateLift());
        if (classificationTestMetricsOptionsState.IsGenerateLift()) {
            object = DM4JStringUtils.trimDoubleQuotes(finishState.getLiftName());
            ((OraClassificationTestTask)classificationTestTask).setTableName(ClassificationTestMetricOption.lift, "\"" + (String)object + "\"");
            classificationTestTask.setNumberOfLiftQuantiles(classificationTestMetricsOptionsState.getNumLiftQuantile());
        }
        classificationTestTask.computeMetric(ClassificationTestMetricOption.receiverOperatingCharacteristics, classificationTestMetricsOptionsState.IsGenerateROC());
        if (classificationTestMetricsOptionsState.IsGenerateROC()) {
            object = DM4JStringUtils.trimDoubleQuotes(finishState.getROCName());
            ((OraClassificationTestTask)classificationTestTask).setTableName(ClassificationTestMetricOption.receiverOperatingCharacteristics, "\"" + (String)object + "\"");
        }
        object = (TestTargetValueState)this.m_state.getStep(StepType.TARGET_VALUE_STEP);
        String string4 = ((TestTargetValueState)object).getSelectedTargetValue();
        if (classificationTestMetricsOptionsState.IsGenerateROC() || classificationTestMetricsOptionsState.IsGenerateLift()) {
            classificationTestTask.setPositiveTargetValue(new String(string4));
        }
        if ((costMatrix = this.buildCostMatrix((TestTargetValueState)object)) != null) {
            this.m_costMatrixName = DM4JStringUtils.trimDoubleQuotes(finishState.getCostMatrixName());
            this.m_state.getJDMConnection().saveObject("\"" + this.m_costMatrixName + "\"", costMatrix, true);
            classificationTestTask.setCostMatrixName("\"" + this.m_costMatrixName + "\"");
            ((OraClassificationTestTask)classificationTestTask).useCost(true);
        }
        this.m_state.getJDMConnection().saveObject("\"" + this.m_uniqueTaskName + "\"", classificationTestTask, true);
        DMEMetadata dMEMetadata = DMEMetadata.getInstance();
        AbstractActivity abstractActivity = this.m_state.getBrowserContext().getActivity();
        String string5 = abstractActivity.getName();
        dMEMetadata.insertTestRec(this.m_state.getConnection(), "\"" + string2 + "\"", "\"" + this.m_uniqueTaskName + "\"", string, string5);
        return "\"" + this.m_uniqueTaskName + "\"";
    }

    private CostMatrix buildCostMatrix(TestTargetValueState testTargetValueState) throws Exception {
        CostMatrix costMatrix = null;
        if (testTargetValueState.getWeightedScoreIndicator()) {
            TargetValueCostMatrixDataSource targetValueCostMatrixDataSource = testTargetValueState.getTargetValueCostMatrixDataSource();
            costMatrix = targetValueCostMatrixDataSource.generateCostMatrix(this.m_state.getJDMConnection());
        }
        return costMatrix;
    }

    public static Double computePredictiveConfidence(ClassificationTestMetrics classificationTestMetrics) throws Exception {
        ConfusionMatrix confusionMatrix = classificationTestMetrics.getConfusionMatrix();
        Collection collection = confusionMatrix.getCategories();
        int n = collection.size();
        String[] stringArray = new String[n];
        Iterator iterator = collection.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            stringArray[n2] = (String)iterator.next();
            ++n2;
        }
        n2 = n;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            double d2 = 0.0;
            double d3 = 0.0;
            for (int j = 0; j < n; ++j) {
                try {
                    Double d4 = confusionMatrix.getValue(stringArray[i], stringArray[j]);
                    d2 += d4.doubleValue();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Double d5 = confusionMatrix.getValue(stringArray[i], stringArray[i]);
            if (d2 == 0.0) {
                --n2;
                continue;
            }
            d3 = d5 / d2;
            d += d3;
        }
        double d6 = 1.0 - d / (double)n2;
        double d7 = (double)(n2 - 1) / (double)n2;
        double d8 = 1.0 - d6 / d7;
        return new Double(Math.min(Math.max(0.0, d8), 1.0) * 100.0);
    }

    public void run() {
        try {
            this.getProgressBar().updateProgress(ResourceUtilities.getUILabel("MODEL_BUILD_UPPER_STEP_1"), null);
            String string = this.getMiningTask();
            this.m_isCancelable = false;
            ExecutionHandle executionHandle = this.m_state.getJDMConnection().execute(string);
            ExecutionStatus executionStatus = executionHandle.waitForCompletion(Integer.MAX_VALUE);
            if (executionStatus.getState().equals(ExecutionState.success)) {
                ClassificationModelState classificationModelState = (ClassificationModelState)this.m_state.getStep(StepType.MODEL_STEP);
                String string2 = classificationModelState.getSelectedModelName();
                ModelLiftNameState modelLiftNameState = (ModelLiftNameState)this.m_state.getStep(StepType.NAME_STEP);
                String string3 = DM4JStringUtils.trimDoubleQuotes(modelLiftNameState.getTestMetricName());
                ClassificationTestMetrics classificationTestMetrics = (ClassificationTestMetrics)this.m_state.getJDMConnection().retrieveObject(DMEMetadata.fixObjectNameWhenLoad(string3), NamedObject.testMetrics);
                Double d = ClassificationModelLiftBuilder.computePredictiveConfidence(classificationTestMetrics);
                DMEMetadata dMEMetadata = DMEMetadata.getInstance();
                dMEMetadata.insertXformTableRec(this.m_state.getConnection(), "\"" + this.m_uniqueTaskName + "\"", string2, "XPCV", d + "");
            }
            this.m_state.setNewTaskName(string);
            this.getProgressBar().setDoneStatus();
        }
        catch (Exception exception) {
            if (this.m_isCancelable) {
                this.cleanUp();
            }
            this.setException(exception);
            this.getProgressBar().setDoneStatus();
        }
    }
}

