/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.director.minings;

import java.math.BigDecimal;
import java.util.Map;
import java.util.Vector;
import javax.datamining.MiningAlgorithm;
import javax.datamining.MiningObject;
import javax.datamining.NamedObject;
import javax.datamining.SizeUnit;
import javax.datamining.algorithm.naivebayes.NaiveBayesSettings;
import javax.datamining.algorithm.svm.KernelFunction;
import javax.datamining.base.AlgorithmSettings;
import javax.datamining.base.Model;
import javax.datamining.resource.Connection;
import javax.datamining.supervised.classification.ClassificationModel;
import javax.datamining.supervised.classification.ClassificationSettings;
import javax.datamining.supervised.classification.CostMatrix;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.datasources.TargetValueCostMatrixDataSource;
import oracle.dmt.dm4j.datasources.TargetValueDataSource;
import oracle.dmt.dm4j.datasources.TargetValueWeightDataSource;
import oracle.dmt.dm4j.wizard.dialogs.DialogUtilities;
import oracle.dmt.dm4j.wizard.director.minings.ModelBuildLoader;
import oracle.dmt.dm4j.wizard.state.minings.WizardState;
import oracle.dmt.dm4j.wizard.state.miningsteps.AdaptiveBayesNetworkAlgorithmState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ClassificationAlgorithmState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ClassificationModelState;
import oracle.dmt.dm4j.wizard.state.miningsteps.DecisionTreeAlgorithmState;
import oracle.dmt.dm4j.wizard.state.miningsteps.GeneralizedLinearModelAlgorithmState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ModelDataState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ModelTargetValueState;
import oracle.dmt.dm4j.wizard.state.miningsteps.NaiveBayesAlgorithmState;
import oracle.dmt.dm4j.wizard.state.miningsteps.SupportVectorMachineAlgorithmState;
import oracle.dmt.dm4j.wizard.state.miningsteps.TargetState;
import oracle.dmt.dm4j.wizard.state.miningsteps.TargetValueState;
import oracle.dmt.dm4j.wizard.steps.minings.StepType;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.jdm.OraMiningAlgorithm;
import oracle.dmt.jdm.algorithm.abn.OraABNModelType;
import oracle.dmt.jdm.algorithm.abn.OraABNSettings;
import oracle.dmt.jdm.algorithm.glm.OraGLMClassificationSettings;
import oracle.dmt.jdm.algorithm.svm.classification.OraSVMClassificationSettings;
import oracle.dmt.jdm.algorithm.tree.OraTreeSettings;

public class ClassificationModelBuildLoader
extends ModelBuildLoader {
    protected TargetValueDataSource m_tvds = null;

    public ClassificationModelBuildLoader(WizardState wizardState, String string) {
        super(wizardState, string);
    }

    protected MiningObject restoreMiningObject(String string) throws Exception {
        ClassificationModel classificationModel = (ClassificationModel)this.m_state.getJDMConnection().retrieveObject(string, NamedObject.model);
        return classificationModel;
    }

    public boolean validate() throws Exception {
        Vector vector = new Vector();
        this.m_state.getStep(StepType.DATA_STEP).load();
        this.m_state.getStep(StepType.TARGET_STEP).load();
        ModelDataState modelDataState = (ModelDataState)this.m_state.getStep(StepType.DATA_STEP);
        boolean bl = this.m_state.synchronize(vector, modelDataState);
        if (ValidationUtil.validationsContainsErrors(vector)) {
            DialogUtilities.displayValidations(vector, null, this.m_state.getDialog());
        }
        return bl;
    }

    public void buildAlgorithmSetting(ClassificationAlgorithmState classificationAlgorithmState) throws Exception {
        Model model = (Model)this.getMiningObj();
        AlgorithmSettings algorithmSettings = this.getMiningFunctionSettings().getAlgorithmSettings();
        MiningAlgorithm miningAlgorithm = model.getMiningAlgorithm();
        if (miningAlgorithm.equals(MiningAlgorithm.svmClassification)) {
            OraSVMClassificationSettings oraSVMClassificationSettings = (OraSVMClassificationSettings)algorithmSettings;
            double d = oraSVMClassificationSettings.getComplexityFactor();
            KernelFunction kernelFunction = oraSVMClassificationSettings.getKernelFunction();
            int n = 0;
            double d2 = 0.0;
            if (kernelFunction.equals(KernelFunction.kGaussian)) {
                n = oraSVMClassificationSettings.getKernelCacheSize();
                d2 = oraSVMClassificationSettings.getStandardDeviation();
            }
            double d3 = oraSVMClassificationSettings.getTolerance();
            classificationAlgorithmState.setSupportVectorMachineSelected(true);
            SupportVectorMachineAlgorithmState supportVectorMachineAlgorithmState = new SupportVectorMachineAlgorithmState(classificationAlgorithmState, kernelFunction, new Double(d3), new Double(d2), new Double(d), new Integer(n / 1000000), oraSVMClassificationSettings.getActiveLearning());
            classificationAlgorithmState.setSupportVectorMachineAlgorithm(supportVectorMachineAlgorithmState);
        } else if (miningAlgorithm.equals(MiningAlgorithm.naiveBayes)) {
            NaiveBayesSettings naiveBayesSettings = (NaiveBayesSettings)algorithmSettings;
            classificationAlgorithmState.setNaiveBayesSelected(true);
            NaiveBayesAlgorithmState naiveBayesAlgorithmState = new NaiveBayesAlgorithmState(classificationAlgorithmState, new Double(naiveBayesSettings.getSingletonThreshold()), new Double(naiveBayesSettings.getPairwiseThreshold()));
            classificationAlgorithmState.setNaiveBayes(naiveBayesAlgorithmState);
        } else if (miningAlgorithm.equals(OraMiningAlgorithm.adaptiveBayesNetwork)) {
            OraABNSettings oraABNSettings = (OraABNSettings)algorithmSettings;
            int n = this.getMiningFunctionSettings().getDesiredExecutionTimeInMinutes();
            OraABNModelType oraABNModelType = oraABNSettings.getModelType();
            int n2 = oraABNSettings.getMaximumNumberOfPredictors();
            int n3 = oraABNSettings.getNaiveBayesNumberOfPredictors();
            classificationAlgorithmState.setAdaptiveNaiveBayesSelected(true);
            AdaptiveBayesNetworkAlgorithmState adaptiveBayesNetworkAlgorithmState = new AdaptiveBayesNetworkAlgorithmState(classificationAlgorithmState, oraABNModelType, new Integer(n), null, new Integer(n2), new Integer(n3), null);
            classificationAlgorithmState.setAdaptiveNetworkBayes(adaptiveBayesNetworkAlgorithmState);
        } else if (miningAlgorithm.equals(MiningAlgorithm.decisionTree)) {
            OraTreeSettings oraTreeSettings = (OraTreeSettings)algorithmSettings;
            classificationAlgorithmState.setDecisionTreeSelected(true);
            DecisionTreeAlgorithmState decisionTreeAlgorithmState = new DecisionTreeAlgorithmState(classificationAlgorithmState, new Integer(oraTreeSettings.getMaxDepth()), new Integer((int)oraTreeSettings.getMinNodeSize(SizeUnit.count)), new Double(oraTreeSettings.getMinNodeSize(SizeUnit.percentage)), new Integer((int)oraTreeSettings.getMinNodeSizeForSplit(SizeUnit.count)), new Double(oraTreeSettings.getMinNodeSizeForSplit(SizeUnit.percentage)), oraTreeSettings.getBuildHomogeneityMetric());
            classificationAlgorithmState.setDecisionTree(decisionTreeAlgorithmState);
        } else if (miningAlgorithm.equals(OraMiningAlgorithm.generalizedLinearModel)) {
            OraGLMClassificationSettings oraGLMClassificationSettings = (OraGLMClassificationSettings)algorithmSettings;
            classificationAlgorithmState.setGenerializedLinearModelSelected(true);
            GeneralizedLinearModelAlgorithmState generalizedLinearModelAlgorithmState = new GeneralizedLinearModelAlgorithmState(classificationAlgorithmState, (Double)oraGLMClassificationSettings.getConfidenceLevel(), oraGLMClassificationSettings.getDiagnosticsTableName() != null && oraGLMClassificationSettings.getDiagnosticsTableName().length() > 0, (boolean)oraGLMClassificationSettings.useRidgeRegression(), oraGLMClassificationSettings.getRidgeValue(), oraGLMClassificationSettings.getReferenceCategory());
            classificationAlgorithmState.setGeneralizedLinearModelAlgorithm(generalizedLinearModelAlgorithmState);
        }
    }

    public void buildCostMatrix(ModelTargetValueState modelTargetValueState) throws Exception {
        ClassificationSettings classificationSettings = (ClassificationSettings)this.getMiningFunctionSettings();
        String string = classificationSettings.getCostMatrixName();
        if (string != null) {
            CostMatrix costMatrix = (CostMatrix)this.m_state.getJDMConnection().retrieveObject(string, NamedObject.costMatrix);
            modelTargetValueState.setWeightedScoreEnabled(true);
            modelTargetValueState.setWeightedScoreIndicator(true);
            modelTargetValueState.setFalsePositiveIndicator(false);
            modelTargetValueState.setWeight("1.0");
            TargetValueCostMatrixDataSource targetValueCostMatrixDataSource = new TargetValueCostMatrixDataSource(new Vector(costMatrix.getCategories()));
            targetValueCostMatrixDataSource.run();
            targetValueCostMatrixDataSource.setCostMatrix(costMatrix);
            modelTargetValueState.setTargetValueCostMatrix(targetValueCostMatrixDataSource);
        }
    }

    public void buildPriors(ModelTargetValueState modelTargetValueState) throws Exception {
        block13: {
            Model model = (Model)this.getMiningObj();
            AlgorithmSettings algorithmSettings = model.getBuildSettings().getAlgorithmSettings();
            MiningAlgorithm miningAlgorithm = model.getMiningAlgorithm();
            boolean bl = !miningAlgorithm.equals(MiningAlgorithm.svmClassification);
            ClassificationSettings classificationSettings = (ClassificationSettings)this.getMiningFunctionSettings();
            Map map = classificationSettings.getPriorProbabilitiesMap(classificationSettings.getTargetAttributeName());
            if (map == null) break block13;
            if (bl) {
                modelTargetValueState.setPriorsEnabled(true);
                modelTargetValueState.setPriorsIndicator(true);
                TargetValueDataSource targetValueDataSource = modelTargetValueState.getTargetValuesDataSource();
                Object[] objectArray = map.keySet().toArray();
                block0: for (int i = 0; i < objectArray.length; ++i) {
                    Double d = null;
                    Object v = map.get(objectArray[i]);
                    if (v instanceof BigDecimal) {
                        d = new Double(((BigDecimal)v).doubleValue());
                    } else if (v instanceof Double) {
                        d = (Double)v;
                    }
                    double d2 = d * 100.0;
                    for (int j = 0; j < objectArray.length; ++j) {
                        String string = (String)targetValueDataSource.getData(0, j);
                        if (string.compareToIgnoreCase(objectArray[i].toString()) != 0) continue;
                        targetValueDataSource.setData(3, j, new Double(d2));
                        continue block0;
                    }
                }
            } else {
                Double d;
                int n;
                modelTargetValueState.setTargetWeightsEnabled(true);
                modelTargetValueState.setTargetWeightsIndicator(true);
                Object[] objectArray = map.keySet().toArray();
                TargetValueDataSource targetValueDataSource = modelTargetValueState.getTargetValuesDataSource();
                double d3 = 0.0;
                for (n = 0; n < objectArray.length; ++n) {
                    d = (Double)targetValueDataSource.getData(3, n);
                    double d4 = d;
                    d3 += d4;
                }
                block3: for (n = 0; n < objectArray.length; ++n) {
                    d = null;
                    Object v = map.get(objectArray[n]);
                    if (v instanceof BigDecimal) {
                        d = new Double(((BigDecimal)v).doubleValue());
                    } else if (v instanceof Double) {
                        d = (Double)v;
                    }
                    double d5 = d;
                    for (int i = 0; i < objectArray.length; ++i) {
                        String string = (String)targetValueDataSource.getData(0, i);
                        if (string.compareToIgnoreCase(objectArray[n].toString()) != 0) continue;
                        double d6 = d5 * d3;
                        targetValueDataSource.setData(3, i, new Double(d6));
                        continue block3;
                    }
                }
            }
        }
    }

    public void buildTargetAttribute(TargetState targetState) throws Exception {
        if (this.m_ds != null) {
            targetState.setTargetAttribute(this.m_ds.getTargetAttributeName());
        }
    }

    public void buildTargetValue(TargetValueState targetValueState) throws Exception {
        boolean bl;
        Model model = (Model)this.getMiningObj();
        AlgorithmSettings algorithmSettings = model.getBuildSettings().getAlgorithmSettings();
        MiningAlgorithm miningAlgorithm = model.getMiningAlgorithm();
        boolean bl2 = bl = !miningAlgorithm.equals(MiningAlgorithm.svmClassification);
        if (this.m_tvds == null) {
            Connection connection = DM4JConnectionManager.getConnection();
            this.m_tvds = bl ? new TargetValueDataSource(connection, this.m_schema, this.m_table, this.m_ds.getTargetAttributeName()) : new TargetValueWeightDataSource(connection, this.m_schema, this.m_table, this.m_ds.getTargetAttributeName());
            this.m_tvds.run();
        }
        targetValueState.setTargetValues(this.m_tvds);
        targetValueState.setSelectedTargetValue(null);
    }

    public void buildTargetAttributeDataType(ClassificationModelState classificationModelState) throws Exception {
        if (this.m_ds != null) {
            classificationModelState.setTargetAttributeDataType(this.m_ds.getTargetAttributeDataType());
        }
    }
}

