/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.director.minings;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.datamining.NamedObject;
import javax.datamining.SizeUnit;
import javax.datamining.algorithm.naivebayes.NaiveBayesSettings;
import javax.datamining.algorithm.naivebayes.NaiveBayesSettingsFactory;
import javax.datamining.algorithm.svm.KernelFunction;
import javax.datamining.algorithm.tree.TreeHomogeneityMetric;
import javax.datamining.algorithm.tree.TreeSettings;
import javax.datamining.algorithm.tree.TreeSettingsFactory;
import javax.datamining.base.AlgorithmSettings;
import javax.datamining.data.CategorySetFactory;
import javax.datamining.supervised.SupervisedAlgorithmSettings;
import javax.datamining.supervised.classification.ClassificationSettings;
import javax.datamining.supervised.classification.ClassificationSettingsFactory;
import javax.datamining.supervised.classification.CostMatrix;
import javax.datamining.supervised.classification.CostMatrixFactory;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.datasources.LDSDataSource;
import oracle.dmt.dm4j.datasources.TargetValueCostMatrixDataSource;
import oracle.dmt.dm4j.datasources.TargetValueDataSource;
import oracle.dmt.dm4j.wizard.director.minings.ModelBuildBuilder;
import oracle.dmt.dm4j.wizard.state.minings.WizardState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ClassificationAlgorithmState;
import oracle.dmt.dm4j.wizard.state.miningsteps.FinishState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ModelDataState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ModelNameState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ModelTargetValueState;
import oracle.dmt.dm4j.wizard.state.miningsteps.TargetState;
import oracle.dmt.dm4j.wizard.steps.minings.StepType;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.jdm.algorithm.abn.OraABNModelType;
import oracle.dmt.jdm.algorithm.abn.OraABNSettings;
import oracle.dmt.jdm.algorithm.abn.OraABNSettingsFactory;
import oracle.dmt.jdm.algorithm.glm.OraGLMClassificationSettings;
import oracle.dmt.jdm.algorithm.glm.OraGLMSettingsFactory;
import oracle.dmt.jdm.algorithm.svm.classification.OraSVMClassificationSettings;
import oracle.dmt.jdm.algorithm.svm.classification.OraSVMClassificationSettingsFactory;
import oracle.dmt.jdm.algorithm.tree.OraTreeSettings;
import oracle.dmt.jdm.base.OraBuildSettings;

public class ClassificationModelBuildBuilder
extends ModelBuildBuilder {
    private ClassificationSettingsFactory m_clasFactory = null;
    private OraABNSettingsFactory m_abnFactory = null;
    private NaiveBayesSettingsFactory m_nbFactory = null;
    private OraSVMClassificationSettingsFactory m_svmFactory = null;
    private TreeSettingsFactory m_treeFactory = null;
    private OraGLMSettingsFactory m_glmFactory = null;
    private CostMatrixFactory m_costMatrixFactory = null;
    private CategorySetFactory m_catSetFactory = null;
    private String m_costMatrixName = null;
    private String m_settingName = null;

    public ClassificationModelBuildBuilder(WizardState wizardState) throws Exception {
        super(wizardState);
    }

    public void construct() throws Exception {
        super.construct();
        this.m_clasFactory = (ClassificationSettingsFactory)this.m_state.getJDMConnection().getFactory("javax.datamining.supervised.classification.ClassificationSettings");
        this.m_abnFactory = (OraABNSettingsFactory)this.m_state.getJDMConnection().getFactory("oracle.dmt.jdm.algorithm.abn.OraABNSettings");
        this.m_nbFactory = (NaiveBayesSettingsFactory)this.m_state.getJDMConnection().getFactory("javax.datamining.algorithm.naivebayes.NaiveBayesSettings");
        this.m_svmFactory = (OraSVMClassificationSettingsFactory)this.m_state.getJDMConnection().getFactory("javax.datamining.algorithm.svm.classification.SVMClassificationSettings");
        this.m_treeFactory = (TreeSettingsFactory)this.m_state.getJDMConnection().getFactory("javax.datamining.algorithm.tree.TreeSettings");
        this.m_glmFactory = (OraGLMSettingsFactory)this.m_state.getJDMConnection().getFactory("oracle.dmt.jdm.algorithm.glm.OraGLMSettings");
        this.m_costMatrixFactory = (CostMatrixFactory)this.m_state.getJDMConnection().getFactory("javax.datamining.supervised.classification.CostMatrix");
        this.m_catSetFactory = (CategorySetFactory)this.m_state.getJDMConnection().getFactory("javax.datamining.data.CategorySet");
    }

    public void cleanUp() {
        if (!this.m_isCancelable) {
            return;
        }
        try {
            if (this.m_costMatrixName != null) {
                this.m_state.getJDMConnection().removeObject("\"" + this.m_costMatrixName + "\"", NamedObject.costMatrix);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.m_settingName != null) {
                this.m_state.getJDMConnection().removeObject("\"" + this.m_settingName + "\"", NamedObject.buildSettings);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.cleanUp();
    }

    private AlgorithmSettings buildAlgorithmSetting(ClassificationAlgorithmState classificationAlgorithmState) throws Exception {
        SupervisedAlgorithmSettings supervisedAlgorithmSettings = null;
        if (classificationAlgorithmState.isAdaptiveNaiveBayesSelected()) {
            OraABNSettings oraABNSettings = this.m_abnFactory.create();
            OraABNModelType oraABNModelType = classificationAlgorithmState.getAdaptiveNetworkBayes().getModelBuildTypeSelected();
            oraABNSettings.setModelType(oraABNModelType);
            Integer n = classificationAlgorithmState.getAdaptiveNetworkBayes().getNumberOfNetworkFeatures();
            oraABNSettings.setMaximumNumberOfPredictors(n);
            Integer n2 = classificationAlgorithmState.getAdaptiveNetworkBayes().getNumberOfNBNetworkFeatures();
            oraABNSettings.setNaiveBayesNumberOfPredictors(n2);
            supervisedAlgorithmSettings = oraABNSettings;
        } else if (classificationAlgorithmState.isNaiveBayesSelected()) {
            Double d = classificationAlgorithmState.getNaiveBayes().getSingletonThreshold();
            Double d2 = classificationAlgorithmState.getNaiveBayes().getPairwiseThreshold();
            NaiveBayesSettings naiveBayesSettings = this.m_nbFactory.create();
            naiveBayesSettings.setPairwiseThreshold(d2.floatValue());
            naiveBayesSettings.setSingletonThreshold(d.floatValue());
            supervisedAlgorithmSettings = naiveBayesSettings;
        } else if (classificationAlgorithmState.isSupportVectorMachineSelected()) {
            Double d;
            Number number;
            OraSVMClassificationSettings oraSVMClassificationSettings = (OraSVMClassificationSettings)this.m_svmFactory.create();
            KernelFunction kernelFunction = classificationAlgorithmState.getSupportVectorMachine().getKernelFunction();
            oraSVMClassificationSettings.setKernelFunction(kernelFunction);
            if (kernelFunction.equals(KernelFunction.kGaussian)) {
                number = classificationAlgorithmState.getSupportVectorMachine().getKernelCacheSize();
                oraSVMClassificationSettings.setKernelCacheSize((Integer)number * 1000000);
                if (classificationAlgorithmState.getSupportVectorMachine().isStdSelected()) {
                    d = classificationAlgorithmState.getSupportVectorMachine().getStd();
                    oraSVMClassificationSettings.setStandardDeviation(d);
                }
            }
            number = classificationAlgorithmState.getSupportVectorMachine().getTolerance();
            oraSVMClassificationSettings.setTolerance((Double)number);
            if (classificationAlgorithmState.getSupportVectorMachine().isComplexityFactorSelected()) {
                d = classificationAlgorithmState.getSupportVectorMachine().getComplexityFactor();
                oraSVMClassificationSettings.setComplexityFactor(d);
            }
            oraSVMClassificationSettings.setActiveLearning(classificationAlgorithmState.getSupportVectorMachine().isLearningEnabled());
            supervisedAlgorithmSettings = oraSVMClassificationSettings;
        } else if (classificationAlgorithmState.isDecisionTreeSelected()) {
            TreeHomogeneityMetric treeHomogeneityMetric = classificationAlgorithmState.getDecisionTree().getHomogeneityMetricSelected();
            Integer n = classificationAlgorithmState.getDecisionTree().getMaxDepth();
            Integer n3 = classificationAlgorithmState.getDecisionTree().getMinSizeCnt();
            Double d = classificationAlgorithmState.getDecisionTree().getMinSizePercent();
            Integer n4 = classificationAlgorithmState.getDecisionTree().getNodeSizeForSplitCnt();
            Double d3 = classificationAlgorithmState.getDecisionTree().getNodeSizeForSplitPercent();
            TreeSettings treeSettings = this.m_treeFactory.create();
            OraTreeSettings oraTreeSettings = (OraTreeSettings)treeSettings;
            oraTreeSettings.setBuildHomogeneityMetric(treeHomogeneityMetric);
            oraTreeSettings.setMaxDepth(n);
            oraTreeSettings.setMinNodeSize(n3.doubleValue(), SizeUnit.count);
            oraTreeSettings.setMinNodeSize(d, SizeUnit.percentage);
            oraTreeSettings.setMinNodeSizeForSplit(n4.doubleValue(), SizeUnit.count);
            oraTreeSettings.setMinNodeSizeForSplit(d3, SizeUnit.percentage);
            supervisedAlgorithmSettings = oraTreeSettings;
        } else if (classificationAlgorithmState.isGenerializedLinearModelSelected()) {
            Object object;
            OraGLMClassificationSettings oraGLMClassificationSettings = this.m_glmFactory.createGLMClassificationSettings();
            oraGLMClassificationSettings.setConfidenceLevel(classificationAlgorithmState.getGenerializedLinearModel().getConfidenceLevel());
            if (classificationAlgorithmState.getGenerializedLinearModel().isDiagnosticsTableEnabled()) {
                object = this.m_state.getConnection();
                try {
                    String string = ValidationUtil.createUniqueTableName("DM4J$D", (Connection)object, "");
                    oraGLMClassificationSettings.setDiagnosticsTableName(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((object = classificationAlgorithmState.getGenerializedLinearModel().getReferenceTargetClass()) != null) {
                oraGLMClassificationSettings.setReferenceCategory(object);
            }
            boolean bl = classificationAlgorithmState.getGenerializedLinearModel().isRidgeRegressionEnabled();
            Double d = classificationAlgorithmState.getGenerializedLinearModel().getRidgeValue();
            if (!bl) {
                oraGLMClassificationSettings.useRidgeRegression(false);
            } else if (d != null) {
                oraGLMClassificationSettings.useRidgeRegression(true);
                oraGLMClassificationSettings.setRidgeValue((double)d);
            }
            supervisedAlgorithmSettings = oraGLMClassificationSettings;
        }
        return supervisedAlgorithmSettings;
    }

    private CostMatrix buildCostMatrix(ModelTargetValueState modelTargetValueState) throws Exception {
        CostMatrix costMatrix = null;
        if (modelTargetValueState.getWeightedScoreIndicator()) {
            TargetValueCostMatrixDataSource targetValueCostMatrixDataSource = modelTargetValueState.getTargetValueCostMatrixDataSource();
            costMatrix = targetValueCostMatrixDataSource.generateCostMatrix(this.m_state.getJDMConnection());
        }
        return costMatrix;
    }

    private Map buildPriors(ModelTargetValueState modelTargetValueState) throws Exception {
        HashMap<Object, Double> hashMap;
        block8: {
            double d;
            String string;
            block7: {
                ModelDataState modelDataState = (ModelDataState)this.m_state.getStep(StepType.DATA_STEP);
                LDSDataSource lDSDataSource = modelDataState.getLDSDataSource();
                string = lDSDataSource.getTargetAttributeDataType();
                hashMap = null;
                if (!modelTargetValueState.getPriorsIndicator()) break block7;
                hashMap = new HashMap<Object, Double>();
                TargetValueDataSource targetValueDataSource = modelTargetValueState.getTargetValuesDataSource();
                Vector vector = targetValueDataSource.getAttributes(0);
                Vector vector2 = targetValueDataSource.getAttributes(3);
                double d2 = 0.0;
                double d3 = 1.0;
                int n = vector2.size();
                for (int i = 0; i < n; ++i) {
                    d2 = (Double)targetValueDataSource.getData(3, i);
                    if (i == n - 1 && (d3 -= (d2 /= 100.0)) != 0.0) {
                        d2 = d3 > 0.0 ? (d2 -= d3) : (d2 += d3);
                    }
                    if (string.compareTo("NUMBER") == 0 || string.compareTo("FLOAT") == 0) {
                        hashMap.put(new Double((String)vector.get(i)), new Double(d2));
                        continue;
                    }
                    if (string.compareTo("VARCHAR2") != 0 && string.compareTo("CHAR") != 0) continue;
                    hashMap.put(new String((String)vector.get(i)), new Double(d2));
                }
                break block8;
            }
            if (!modelTargetValueState.getTargetWeightsIndicator()) break block8;
            hashMap = new HashMap();
            TargetValueDataSource targetValueDataSource = modelTargetValueState.getTargetValuesDataSource();
            Vector vector = targetValueDataSource.getAttributes(0);
            Vector vector3 = targetValueDataSource.getAttributes(3);
            double d4 = 0.0;
            for (int i = 0; i < vector3.size(); ++i) {
                Double d5 = (Double)targetValueDataSource.getData(3, i);
                d = d5;
                d4 += d;
            }
            double d6 = 0.0;
            d = 1.0;
            int n = vector3.size();
            for (int i = 0; i < n; ++i) {
                d6 = (Double)targetValueDataSource.getData(3, i);
                if (i == n - 1 && (d -= (d6 /= d4)) != 0.0) {
                    d6 = d > 0.0 ? (d6 -= d) : (d6 += d);
                }
                if (string.compareTo("NUMBER") == 0 || string.compareTo("FLOAT") == 0) {
                    hashMap.put(new Double((String)vector.get(i)), new Double(d6));
                    continue;
                }
                if (string.compareTo("VARCHAR2") != 0 && string.compareTo("CHAR") != 0) continue;
                hashMap.put(new String((String)vector.get(i)), new Double(d6));
            }
        }
        return hashMap;
    }

    protected String createFunctionSettings() throws Exception {
        Map map;
        Object object;
        ModelNameState modelNameState = (ModelNameState)this.m_state.getStep(StepType.NAME_STEP);
        FinishState finishState = (FinishState)this.m_state.getStep(StepType.FINISH_STEP);
        ClassificationSettings classificationSettings = this.m_clasFactory.create();
        ClassificationAlgorithmState classificationAlgorithmState = (ClassificationAlgorithmState)this.m_state.getStep(StepType.ALGORITHM_STEP);
        AlgorithmSettings algorithmSettings = this.buildAlgorithmSetting(classificationAlgorithmState);
        if (classificationAlgorithmState.isGenerializedLinearModelSelected()) {
            ((OraBuildSettings)((Object)classificationSettings)).useAutomatedDataPreparations(true);
        }
        classificationSettings.setAlgorithmSettings(algorithmSettings);
        if (classificationAlgorithmState.getAdaptiveNetworkBayes().isRunTimeSelected()) {
            object = classificationAlgorithmState.getAdaptiveNetworkBayes().getRunTime();
            classificationSettings.setDesiredExecutionTimeInMinutes((Integer)object);
        }
        object = (ModelTargetValueState)this.m_state.getStep(StepType.TARGET_VALUE_STEP);
        TargetState targetState = (TargetState)this.m_state.getStep(StepType.TARGET_STEP);
        String string = targetState.getTargetAttribute();
        string = "\"" + string + "\"";
        classificationSettings.setTargetAttributeName(string);
        String string2 = modelNameState.getModelName();
        CostMatrix costMatrix = this.buildCostMatrix((ModelTargetValueState)object);
        if (costMatrix != null) {
            this.m_costMatrixName = DM4JStringUtils.trimDoubleQuotes(finishState.getCostMatrixName());
            this.m_state.getJDMConnection().saveObject("\"" + this.m_costMatrixName + "\"", costMatrix, true);
            classificationSettings.setCostMatrixName(this.m_costMatrixName);
        }
        if ((map = this.buildPriors((ModelTargetValueState)object)) != null) {
            classificationSettings.setPriorProbabilitiesMap(string, map);
        }
        String string3 = "DM4J$" + string2;
        this.m_settingName = DM4JStringUtils.trimDoubleQuotes(finishState.getMiningSettingsName());
        this.m_state.getJDMConnection().saveObject("\"" + this.m_settingName + "\"", classificationSettings, true);
        return this.m_settingName;
    }
}

