/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.director.minings;

import javax.datamining.NamedObject;
import javax.datamining.attributeimportance.AttributeImportanceSettings;
import javax.datamining.attributeimportance.AttributeImportanceSettingsFactory;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.wizard.director.minings.ModelBuildBuilder;
import oracle.dmt.dm4j.wizard.state.minings.WizardState;
import oracle.dmt.dm4j.wizard.state.miningsteps.FinishState;
import oracle.dmt.dm4j.wizard.state.miningsteps.TargetState;
import oracle.dmt.dm4j.wizard.steps.minings.StepType;

public class AttributeImportanceModelBuildBuilder
extends ModelBuildBuilder {
    private AttributeImportanceSettingsFactory m_attribFactory = null;
    private String m_settingName = null;

    public AttributeImportanceModelBuildBuilder(WizardState wizardState) {
        super(wizardState);
    }

    public void construct() throws Exception {
        super.construct();
        this.m_attribFactory = (AttributeImportanceSettingsFactory)this.m_state.getJDMConnection().getFactory("javax.datamining.attributeimportance.AttributeImportanceSettings");
    }

    public void cleanUp() {
        if (!this.m_isCancelable) {
            return;
        }
        try {
            if (this.m_settingName != null) {
                this.m_state.getJDMConnection().removeObject("\"" + this.m_settingName + "\"", NamedObject.buildSettings);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.cleanUp();
    }

    protected String createFunctionSettings() throws Exception {
        FinishState finishState = (FinishState)this.m_state.getStep(StepType.FINISH_STEP);
        AttributeImportanceSettings attributeImportanceSettings = this.m_attribFactory.create();
        TargetState targetState = (TargetState)this.m_state.getStep(StepType.TARGET_STEP);
        String string = targetState.getTargetAttribute();
        attributeImportanceSettings.setTargetAttributeName("\"" + string + "\"");
        this.m_settingName = DM4JStringUtils.trimDoubleQuotes(finishState.getMiningSettingsName());
        this.m_state.getJDMConnection().saveObject("\"" + this.m_settingName + "\"", attributeImportanceSettings, true);
        return this.m_settingName;
    }
}

