/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.director.minings;

import javax.datamining.NamedObject;
import javax.datamining.association.AssociationSettings;
import javax.datamining.association.AssociationSettingsFactory;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.wizard.director.minings.ModelBuildBuilder;
import oracle.dmt.dm4j.wizard.state.minings.WizardState;
import oracle.dmt.dm4j.wizard.state.miningsteps.AssociationAlgorithmState;
import oracle.dmt.dm4j.wizard.state.miningsteps.FinishState;
import oracle.dmt.dm4j.wizard.steps.minings.StepType;

public class AssociationModelBuildBuilder
extends ModelBuildBuilder {
    private AssociationSettingsFactory m_assocFactory = (AssociationSettingsFactory)this.m_state.getJDMConnection().getFactory("javax.datamining.association.AssociationSettings");
    private String m_settingName = null;

    public AssociationModelBuildBuilder(WizardState wizardState) throws Exception {
        super(wizardState);
    }

    public void cleanUp() {
        if (!this.m_isCancelable) {
            return;
        }
        try {
            if (this.m_settingName != null) {
                this.m_state.getJDMConnection().removeObject("\"" + this.m_settingName + "\"", NamedObject.buildSettings);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.cleanUp();
    }

    protected String createFunctionSettings() throws Exception {
        FinishState finishState = (FinishState)this.m_state.getStep(StepType.FINISH_STEP);
        AssociationSettings associationSettings = this.m_assocFactory.create();
        AssociationAlgorithmState associationAlgorithmState = (AssociationAlgorithmState)this.m_state.getStep(StepType.ALGORITHM_STEP);
        Double d = associationAlgorithmState.getAssociation().getMinSupport();
        associationSettings.setMinSupport(d);
        Double d2 = associationAlgorithmState.getAssociation().getMinConfidence();
        associationSettings.setMinConfidence(d2);
        boolean bl = associationAlgorithmState.getAssociation().getNumOfAttrSelected();
        if (bl) {
            Integer n = associationAlgorithmState.getAssociation().getNumOfAttr();
            associationSettings.setMaxRuleLength(n);
        }
        this.m_settingName = DM4JStringUtils.trimDoubleQuotes(finishState.getMiningSettingsName());
        this.m_state.getJDMConnection().saveObject("\"" + this.m_settingName + "\"", associationSettings, true);
        return this.m_settingName;
    }
}

