/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.director.minings;

import javax.datamining.NamedObject;
import javax.datamining.algorithm.svm.KernelFunction;
import javax.datamining.algorithm.svm.classification.SVMClassificationSettingsFactory;
import javax.datamining.base.AlgorithmSettings;
import javax.datamining.supervised.classification.ClassificationSettings;
import javax.datamining.supervised.classification.ClassificationSettingsFactory;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.wizard.director.minings.ModelBuildBuilder;
import oracle.dmt.dm4j.wizard.state.minings.WizardState;
import oracle.dmt.dm4j.wizard.state.miningsteps.AnomalyDetectionAlgorithmState;
import oracle.dmt.dm4j.wizard.state.miningsteps.FinishState;
import oracle.dmt.dm4j.wizard.steps.minings.StepType;
import oracle.dmt.jdm.algorithm.svm.classification.OraSVMClassificationSettings;

public class AnomalyDetectionModelBuildBuilder
extends ModelBuildBuilder {
    private ClassificationSettingsFactory m_clasFactory = null;
    private SVMClassificationSettingsFactory m_svmFactory = null;
    private String m_settingName = null;

    public AnomalyDetectionModelBuildBuilder(WizardState wizardState) throws Exception {
        super(wizardState);
    }

    public void construct() throws Exception {
        super.construct();
        this.m_clasFactory = (ClassificationSettingsFactory)this.m_state.getJDMConnection().getFactory("javax.datamining.supervised.classification.ClassificationSettings");
        this.m_svmFactory = (SVMClassificationSettingsFactory)this.m_state.getJDMConnection().getFactory("javax.datamining.algorithm.svm.classification.SVMClassificationSettings");
    }

    public void cleanUp() {
        if (!this.m_isCancelable) {
            return;
        }
        try {
            if (this.m_settingName != null) {
                this.m_state.getJDMConnection().removeObject("\"" + this.m_settingName + "\"", NamedObject.buildSettings);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.cleanUp();
    }

    private AlgorithmSettings buildAlgorithmSetting(AnomalyDetectionAlgorithmState anomalyDetectionAlgorithmState) throws Exception {
        Number number;
        OraSVMClassificationSettings oraSVMClassificationSettings = null;
        OraSVMClassificationSettings oraSVMClassificationSettings2 = (OraSVMClassificationSettings)this.m_svmFactory.create();
        KernelFunction kernelFunction = anomalyDetectionAlgorithmState.getSupportVectorMachine().getKernelFunction();
        oraSVMClassificationSettings2.setKernelFunction(kernelFunction);
        if (kernelFunction.equals(KernelFunction.kGaussian)) {
            number = anomalyDetectionAlgorithmState.getSupportVectorMachine().getKernelCacheSize();
            oraSVMClassificationSettings2.setKernelCacheSize((Integer)number * 1000000);
        }
        if (anomalyDetectionAlgorithmState.getSupportVectorMachine().isStdSelected()) {
            number = anomalyDetectionAlgorithmState.getSupportVectorMachine().getStd();
            oraSVMClassificationSettings2.setStandardDeviation((Double)number);
        }
        number = anomalyDetectionAlgorithmState.getSupportVectorMachine().getTolerance();
        oraSVMClassificationSettings2.setTolerance((Double)number);
        Double d = anomalyDetectionAlgorithmState.getSupportVectorMachine().getOutlierRate();
        oraSVMClassificationSettings2.setOutlierRate(d);
        oraSVMClassificationSettings2.setActiveLearning(anomalyDetectionAlgorithmState.getSupportVectorMachine().isLearningEnabled());
        oraSVMClassificationSettings = oraSVMClassificationSettings2;
        return oraSVMClassificationSettings;
    }

    protected String createFunctionSettings() throws Exception {
        FinishState finishState = (FinishState)this.m_state.getStep(StepType.FINISH_STEP);
        ClassificationSettings classificationSettings = this.m_clasFactory.create();
        AnomalyDetectionAlgorithmState anomalyDetectionAlgorithmState = (AnomalyDetectionAlgorithmState)this.m_state.getStep(StepType.ALGORITHM_STEP);
        AlgorithmSettings algorithmSettings = this.buildAlgorithmSetting(anomalyDetectionAlgorithmState);
        classificationSettings.setAlgorithmSettings(algorithmSettings);
        this.m_settingName = DM4JStringUtils.trimDoubleQuotes(finishState.getMiningSettingsName());
        this.m_state.getJDMConnection().saveObject("\"" + this.m_settingName + "\"", classificationSettings, true);
        return this.m_settingName;
    }
}

