/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.dialogs;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.text.Collator;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.NumberInputHandler;
import oracle.bali.ewt.header.GeneralHeaderSelectionManager;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.header.StandardHeaderKeyHandler;
import oracle.bali.ewt.model.SortableTwoDModel;
import oracle.bali.ewt.table.TableEditListener;
import oracle.bali.ewt.table.TableEvent;
import oracle.bali.ewt.text.NumberTextField;
import oracle.bali.share.sort.NumberComparator;
import oracle.bali.share.sort.StringComparator;
import oracle.dmt.dm4j.DM4JNumberTextField;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.DM4JTruncatingNumberFormatPainter;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.datasources.TargetValueDataSource;
import oracle.dmt.dm4j.wizard.dialogs.DM4JDialog;
import oracle.dmt.dm4j.wizard.dialogs.DM4JEvent;
import oracle.dmt.dm4j.wizard.dialogs.DialogUtilities;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.miningsteps.ModelTargetValueState;
import oracle.dmt.dm4j.wizard.table.ComponentSpreadTable;
import oracle.dmt.dm4j.wizard.table.SortInputHandler;

public class PriorsSettingsPanel
extends GriddedPanel {
    DM4JDialog m_parentDialog;
    ModelTargetValueState m_state;
    Vector m_priorOrigDistValues;
    TargetValueDataSource m_ds;
    GridBagLayout gridBagLayout = new GridBagLayout();
    JLabel mlblStepDescription = new JLabel();
    JLabel lblTargetAttribute = new JLabel();
    JLabel lblTargetAttributeValue = new JLabel();
    JLabel lblGridName = new JLabel();
    JScrollPane paneSpread = new JScrollPane();
    ComponentSpreadTable spreadTable = new ComponentSpreadTable(null);
    IncludeAction includeAction = new IncludeAction();
    JButton butRestore = new JButton();
    JLabel lblPriorsTotal = new JLabel();
    JLabel lblFiller = new JLabel();
    private int[] m_colWidths = new int[]{25, 25, 25, 25};

    public PriorsSettingsPanel(DM4JDialog dM4JDialog, ModelTargetValueState modelTargetValueState) throws Exception {
        this.m_parentDialog = dM4JDialog;
        this.m_state = modelTargetValueState;
        this.jbInit();
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout);
        int n = 0;
        int n2 = 0;
        int n3 = 5;
        int n4 = 10;
        int n5 = 0;
        int n6 = 10;
        int n7 = 0;
        int n8 = 0;
        int n9 = 24;
        int n10 = 10;
        int n11 = 10;
        int n12 = 60;
        n2 = 0;
        if (this.m_state.getTargetWeightsIndicator()) {
            this.mlblStepDescription.setText("<html>" + ResourceUtilities.getUILabel("WEIGHTS_SETTINGS_DIALOG_DESCRIPTION_WEIGHT") + "</html>");
        } else {
            this.mlblStepDescription.setText("<html>" + ResourceUtilities.getUILabel("PRIORS_SETTINGS_DIALOG_DESCRIPTION_PRIOR") + "</html>");
        }
        this.add((Component)this.mlblStepDescription, new GridBagConstraints(n2, n, 3, 1, 1.0, 0.0, 17, 1, new Insets(n3, n4, n5, n6), n7, n8));
        n += 2;
        n2 = 0;
        if (this.m_state.getTargetWeightsIndicator()) {
            this.lblTargetAttribute.setText(ResourceUtilities.getUILabel("WEIGHTS_SETTINGS_WEIGHT_ATTRIBUTE"));
        } else {
            this.lblTargetAttribute.setText(ResourceUtilities.getUILabel("PRIORS_SETTINGS_TARGET_ATTRIBUTE"));
        }
        this.lblTargetAttribute.setLabelFor(this.lblTargetAttributeValue);
        this.add((Component)this.lblTargetAttribute, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(n3 + n11, n4, n5, n6), n7, n8));
        n2 = 1;
        this.add((Component)this.lblTargetAttributeValue, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(n3 + n11, n4, n5, n6), n7, n8));
        ++n;
        n2 = 0;
        if (this.m_state.getTargetWeightsIndicator()) {
            this.lblGridName.setText(ResourceUtilities.getUILabel("WEIGHTS_SETTINGS_TABLE_WEIGHT"));
        } else {
            this.lblGridName.setText(ResourceUtilities.getUILabel("PRIORS_SETTINGS_TABLE_PRIOR"));
        }
        this.addAnchoredComponent(this.lblGridName, new Insets(0, n4, n5, n6), n, 0, 2, 1, 16);
        this.lblGridName.setLabelFor(this.paneSpread);
        this.paneSpread.setToolTipText(this.lblGridName.getText());
        n2 = 2;
        this.butRestore.setText(ResourceUtilities.getUILabel("RESTORE_BUTTON"));
        this.butRestore.setMnemonic(ResourceUtilities.getUIMnemonic("RESTORE_BUTTON"));
        this.butRestore.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PriorsSettingsPanel.this.butRestore_actionPerformed(actionEvent);
            }
        });
        this.add((Component)this.butRestore, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 13, 0, new Insets(n3, n4, n5, n6), n7, n8));
        ++n;
        n2 = 0;
        this.paneSpread.getViewport().add((Component)this.spreadTable, null);
        this.paneSpread.setPreferredSize(null);
        this.add((Component)this.paneSpread, new GridBagConstraints(n2, n, 3, 1, 1.0, 1.0, 17, 1, new Insets(n3, n4, n5, n6), n7, n8));
        ++n;
        n2 = 2;
        this.add((Component)this.lblPriorsTotal, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 13, 0, new Insets(n3 + n11, n4, n5, n6), n7, n8));
        JButton[] jButtonArray = new JButton[]{this.butRestore};
        ResourceUtilities.setPreferredSize(jButtonArray, 100, 25);
        JComponent[] jComponentArray = new JComponent[]{this.lblTargetAttributeValue};
        ResourceUtilities.setTextBoxSize(jComponentArray, 150, 25);
        this.addOKHelpCancelListeners();
        this.setSpread();
        this.setTarget();
        this.setPriorsTotal();
        this.savePriorState();
    }

    protected void addOKHelpCancelListeners() {
        this.m_parentDialog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PriorsSettingsPanel.this.m_parentDialog_actionPerformed(actionEvent);
            }
        });
    }

    protected void m_parentDialog_actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("ok" == string) {
            Vector vector = null;
            try {
                this.m_state.setTargetValues(this.m_ds);
                vector = this.m_state.validatePriors();
                DM4JEvent dM4JEvent = (DM4JEvent)actionEvent;
                boolean bl = DialogUtilities.displayValidations(vector, dM4JEvent, this.m_parentDialog);
                if (!dM4JEvent.isCancelled()) {
                    this.spreadTable.removeEditListener(this.includeAction);
                }
            }
            catch (Exception exception) {
                this.m_state.getparentWizardState().doAbortCancel(exception);
            }
        } else if ("cancel" == string) {
            this.restorePriorState();
            this.spreadTable.removeEditListener(this.includeAction);
        }
    }

    protected void setPriorsTotal() {
        if (this.m_state.getPriorsIndicator()) {
            Double d = this.m_ds.getOriginalPriorsTotal();
            NumberFormat numberFormat = NumberFormat.getInstance();
            numberFormat.setMaximumIntegerDigits(3);
            String string = ResourceUtilities.getUILabel("PRIORS_TOTAL");
            this.lblPriorsTotal.setText(string + " " + numberFormat.format(d));
        }
    }

    protected void setTarget() {
        this.lblTargetAttributeValue.setText(this.m_state.getTargetAttribute());
    }

    protected void setSpread() throws Exception {
        this.m_ds = this.m_state.getTargetValuesDataSource();
        this.spreadTable.setModels2(this.m_ds, this.m_ds.getColumnDataSource(), null);
        this.spreadTable.setColumnWidths(this.m_colWidths, true);
        NumberFormat numberFormat = DM4JNumericFormat.getInstance(true, 4);
        DM4JTruncatingNumberFormatPainter dM4JTruncatingNumberFormatPainter = new DM4JTruncatingNumberFormatPainter(numberFormat);
        this.spreadTable.getGrid().setColumnPainter(1, dM4JTruncatingNumberFormatPainter);
        this.spreadTable.getGrid().setColumnPainter(2, dM4JTruncatingNumberFormatPainter);
        DM4JNumberTextField dM4JNumberTextField = new DM4JNumberTextField();
        dM4JNumberTextField.setLocale(Locale.getDefault());
        dM4JNumberTextField.setDataType(Double.class);
        dM4JNumberTextField.setDecimal(false, 4);
        this.spreadTable.getGrid().setColumnCellInputHandler(3, new NumberInputHandler(dM4JNumberTextField));
        DM4JTruncatingNumberFormatPainter dM4JTruncatingNumberFormatPainter2 = new DM4JTruncatingNumberFormatPainter(DM4JNumericFormat.getInstance(false, 4));
        this.spreadTable.getGrid().setColumnPainter(3, dM4JTruncatingNumberFormatPainter2);
        this.spreadTable.addEditListener(this.includeAction);
        Header header = this.spreadTable.getColumnHeader();
        header.setHeaderSelectionManager(GeneralHeaderSelectionManager.getNullHeaderSelectionManager());
        header.setCanMoveItems(false);
        header.setItemInputHandler(new SortInputHandler(this.m_ds));
        this.m_ds.setColumnComparator(0, new StringComparator(Collator.getInstance()));
        this.m_ds.setColumnComparator(1, NumberComparator.getComparator());
        this.m_ds.setColumnComparator(2, NumberComparator.getComparator());
        this.m_ds.setColumnComparator(3, NumberComparator.getComparator());
        header.setHeaderKeyHandler(new KeyHandler());
    }

    protected void butRestore_actionPerformed(ActionEvent actionEvent) {
        try {
            this.restorePriorState();
            this.setPriorsTotal();
        }
        catch (Exception exception) {
            this.m_state.getparentWizardState().doAbortCancel(exception);
        }
    }

    protected void savePriorState() {
        this.m_priorOrigDistValues = new Vector(this.m_ds.getRowCount());
        double d = 0.0;
        for (int i = 0; i < this.m_ds.getRowCount(); ++i) {
            if (this.m_state.getPriorsIndicator()) {
                d = (Double)this.m_ds.getData(3, i);
            } else if (this.m_state.getTargetWeightsIndicator()) {
                d = (Double)this.m_ds.getData(3, i);
            }
            this.m_priorOrigDistValues.add(i, new Double(d));
        }
    }

    protected void restorePriorState() {
        SortableTwoDModel sortableTwoDModel = (SortableTwoDModel)this.spreadTable.getGrid().getModel();
        int n = sortableTwoDModel.getRowCount();
        for (int i = 0; i < n; ++i) {
            if (this.m_state.getPriorsIndicator()) {
                sortableTwoDModel.setData(3, i, this.m_priorOrigDistValues.get(i));
                continue;
            }
            if (!this.m_state.getTargetWeightsIndicator()) continue;
            sortableTwoDModel.setData(3, i, this.m_priorOrigDistValues.get(i));
        }
    }

    private class IncludeAction
    implements TableEditListener {
        private IncludeAction() {
        }

        public void cellEditing(TableEvent tableEvent) {
        }

        public void cellEdited(TableEvent tableEvent) {
            PriorsSettingsPanel.this.setPriorsTotal();
        }
    }

    private class DistributionTextNumber
    extends NumberTextField {
        private char DECIMAL_POINT;

        public DistributionTextNumber(Double d) {
            super(d);
            this.DECIMAL_POINT = (char)46;
            this.setLocale(Locale.getDefault());
        }

        protected boolean validateNumber(Number number) {
            return !(number.doubleValue() > 100.0);
        }

        protected String findInteger(Double d) {
            String string = Double.toString(d);
            int n = string.indexOf(46);
            if (n != -1) {
                String string2 = string.substring(0, n);
                return string2;
            }
            return string;
        }
    }

    private class DistributionInputHandler
    extends NumberInputHandler {
        public DistributionInputHandler(DistributionTextNumber distributionTextNumber) {
            super(distributionTextNumber);
        }

        public Object commitEdit(Grid grid, int n, int n2) {
            Object object = grid.getModel().getData(n, n2);
            Number number = this.getNumberTextField().getNumber();
            if (number instanceof Double) {
                return super.commitEdit(grid, n, n2);
            }
            if (object instanceof Double) {
                return object;
            }
            return new Double(0.0);
        }

        public void startEdit(Grid grid, int n, int n2, Object object) {
            if (object != null && !(object instanceof Number)) {
                throw new IllegalArgumentException("data " + object + " must be a number");
            }
            NumberTextField numberTextField = this.getNumberTextField();
            if (object != null) {
                numberTextField.setDataType(object.getClass());
                numberTextField.setNumber((Number)object);
            }
            super.startEdit(grid, n, n2, object);
        }
    }

    private class KeyHandler
    extends StandardHeaderKeyHandler {
        private KeyHandler() {
        }

        public void handleKeyEvent(Header header, KeyEvent keyEvent) {
            if (keyEvent.getID() == 402 && keyEvent.getKeyCode() == 32) {
                SortInputHandler sortInputHandler = (SortInputHandler)header.getItemInputHandler();
                sortInputHandler.sort(header.getFocusItem());
            }
            super.handleKeyEvent(header, keyEvent);
        }
    }
}

