/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.PrintStream;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.dmt.dm4j.wizard.dialogs.DialogUtilities;
import oracle.dmt.dm4j.wizard.dialogs.ViewLogPanel;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;

public class FileImportErrorPanel
extends JPanel {
    GridBagLayout gridBagLayout = new GridBagLayout();
    MultiLineLabel lblErrorDetails = new MultiLineLabel();
    JScrollPane scrollPane = new JScrollPane();
    JTextArea textArea = new JTextArea();
    JLabel textLabel = new JLabel();
    Exception m_causeException;
    JButton bViewLogFile = new JButton();
    JButton bViewBadRecord = new JButton();
    File m_logFile = null;
    File m_badRecord = null;
    JFrame m_parentFrame;
    static int WIDTH = 500;
    static int HEIGHT = 400;
    String m_dialogTitle;
    int m_buttonMask;
    boolean m_isCancelled = false;

    public FileImportErrorPanel(JFrame jFrame, Exception exception, File file, File file2) {
        try {
            this.m_parentFrame = jFrame;
            this.commonInit(exception, file, file2);
            JEWTDialog jEWTDialog = DialogUtilities.createAndDisplayDialog(jFrame, this.m_dialogTitle, true, (JPanel)this, this.m_buttonMask, new Dimension(WIDTH, HEIGHT));
        }
        catch (Exception exception2) {
            // empty catch block
        }
    }

    public boolean getIsCancelled() {
        return this.m_isCancelled;
    }

    protected void commonInit(Exception exception, File file, File file2) throws Exception {
        this.m_causeException = exception;
        this.m_logFile = file;
        this.m_badRecord = file2;
        this.jbInit();
        this.m_dialogTitle = ResourceUtilities.getUILabel("SYSTEM_ERROR_DIALOG_TITLE");
        this.m_buttonMask = 1;
    }

    private void jbInit() {
        this.setLayout(this.gridBagLayout);
        int n = 5;
        int n2 = 10;
        int n3 = 0;
        int n4 = 10;
        int n5 = 0;
        int n6 = 0;
        this.bViewLogFile.setText("View Log File");
        this.bViewLogFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FileImportErrorPanel.this.bViewLogFile_actionPerformed(actionEvent);
            }
        });
        this.add((Component)this.bViewLogFile, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(n, n2, n3, n4), n5, n6));
        this.bViewLogFile.setEnabled(false);
        if (this.m_logFile != null && this.m_logFile.isFile()) {
            this.bViewLogFile.setEnabled(true);
        }
        this.bViewBadRecord.setEnabled(false);
        this.bViewBadRecord.setVisible(false);
        this.textLabel.setVisible(false);
        this.textArea.setEnabled(true);
        this.textArea.setVisible(true);
        boolean bl = true;
        if (this.m_badRecord != null && this.m_badRecord.isFile()) {
            bl = false;
            this.bViewBadRecord.setEnabled(true);
            this.bViewBadRecord.setVisible(true);
            this.textArea.setEnabled(false);
            this.textArea.setVisible(false);
            this.textLabel.setVisible(true);
            this.bViewBadRecord.setText("View Bad Record(s)");
            this.bViewBadRecord.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    FileImportErrorPanel.this.bViewBadRecord_actionPerformed(actionEvent);
                }
            });
            this.add((Component)this.bViewBadRecord, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(n, n2, n3, n4), n5, n6));
            WIDTH = 500;
            HEIGHT = 200;
            this.textLabel.setText("Some records cannot be loaded, please see log files for more information.");
            this.add((Component)this.textLabel, new GridBagConstraints(0, 1, 2, 2, 1.0, 1.0, 17, 1, new Insets(n, n2, n3, n4), n5, n6));
        }
        if (bl) {
            if (this.m_causeException == null) {
                this.lblErrorDetails.setText("Error Message: No exception processed, error unknown.");
            } else {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                PrintStream printStream = new PrintStream(byteArrayOutputStream);
                this.m_causeException.printStackTrace(printStream);
                this.lblErrorDetails.setTextWrapper(WordWrapper.getTextWrapper());
                this.lblErrorDetails.setText("Error Message: " + this.m_causeException.getLocalizedMessage() + '\n' + "Exception type: " + this.m_causeException.toString() + '\n' + "Stack trace: " + '\n' + byteArrayOutputStream.toString());
            }
            this.textArea.setText(this.lblErrorDetails.getText());
            this.textArea.setEnabled(true);
            this.scrollPane.getViewport().add((Component)this.textArea, null);
            this.add((Component)this.scrollPane, new GridBagConstraints(0, 1, 2, 2, 1.0, 1.0, 17, 1, new Insets(n, n2, n3, n4), n5, n6));
            if (this.m_causeException != null) {
                this.m_causeException.printStackTrace();
            }
        }
    }

    private void bViewLogFile_actionPerformed(ActionEvent actionEvent) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.m_logFile));
            String string = bufferedReader.readLine();
            String string2 = "";
            if (string != null) {
                string2 = string;
            }
            while (string != null) {
                string = bufferedReader.readLine();
                if (string == null) continue;
                string2 = string2 + "\n" + string;
            }
            ViewLogPanel viewLogPanel = new ViewLogPanel(this.m_parentFrame, string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void bViewBadRecord_actionPerformed(ActionEvent actionEvent) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.m_badRecord));
            String string = bufferedReader.readLine();
            String string2 = "";
            if (string != null) {
                string2 = string;
            }
            while (string != null) {
                string = bufferedReader.readLine();
                if (string == null) continue;
                string2 = string2 + "\n" + string;
            }
            ViewLogPanel viewLogPanel = new ViewLogPanel(this.m_parentFrame, string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

