/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.dialogs;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.dmt.dm4j.DM4JNumberTextField;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.wizard.dialogs.DM4JDialog;
import oracle.dmt.dm4j.wizard.dialogs.DM4JEvent;
import oracle.dmt.dm4j.wizard.dialogs.DialogUtilities;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.miningsteps.AdaptiveBayesNetworkAlgorithmState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ClassificationAlgorithmState;
import oracle.dmt.jdm.algorithm.abn.OraABNModelType;

public class AdaptiveBayesNetworkPanel
extends JPanel {
    private static int WIDTH = 450;
    private static int HEIGHT = 400;
    int tInd = 5;
    int lInd = 10;
    int bInd = 0;
    int rInd = 10;
    int wPad = 0;
    int hPad = 0;
    int l2Ind = 24;
    int bInstInd = 10;
    int tGroupInd = 10;
    int rowLength = 60;
    ClassificationAlgorithmState m_state;
    DM4JDialog m_parentDialog;
    GridBagLayout gridBagLayout = new GridBagLayout();
    MultiLineLabel mlblStepDescription = new MultiLineLabel();
    JLabel lblAttributeCount = new JLabel();
    JLabel lblAttributeCountValue = new JLabel();
    JLabel lblCaseCount = new JLabel();
    JLabel lblCaseCountValue = new JLabel();
    JButton butRestore = new JButton();
    JLabel lblModelBuildType = new JLabel();
    JComboBox comboModelBuildType = new JComboBox();
    DefaultComboBoxModel modelBuildTypeModel;
    JLabel lblModelBuildTypeHint1 = new JLabel();
    JLabel lblRunTimeQuestion = new JLabel();
    JRadioButton optRunTimeOverrideYes = new JRadioButton();
    JRadioButton optRunTimeOverrideNo = new JRadioButton();
    ButtonGroup groupRunTimeOverride = new ButtonGroup();
    JLabel lblRunTime = new JLabel();
    JLabel lblRunTimeHint1 = new JLabel();
    DM4JNumberTextField txtRunTime = new DM4JNumberTextField();
    JLabel lblNumberOfNetworkFeatures = new JLabel();
    JLabel lblNumberOfNetworkFeaturesHint1 = new JLabel();
    DM4JNumberTextField txtNumberOfNetworkFeatures = new DM4JNumberTextField();
    JLabel lblNumberOfNBNetworkFeatures = new JLabel();
    JLabel lblNumberOfNBNetworkFeaturesHint1 = new JLabel();
    DM4JNumberTextField txtNumberOfNBNetworkFeatures = new DM4JNumberTextField();
    JLabel lblFiller = new JLabel();
    boolean m_ignoreModelBuildTypeEvent = false;
    boolean priorRunTimeSelected;
    Integer priorPrunedNetworkFeatures;
    Integer priorRunTime;
    Integer priorNumberOfNetworkFeatures;
    Integer priorNetworkFeatureDepth;

    public AdaptiveBayesNetworkPanel(DM4JDialog dM4JDialog, ClassificationAlgorithmState classificationAlgorithmState) throws Exception {
        this.m_parentDialog = dM4JDialog;
        this.m_state = classificationAlgorithmState;
        this.jbInit();
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout);
        int n = 0;
        int n2 = 0;
        n2 = 0;
        this.mlblStepDescription.setText(ResourceUtilities.getUILabel("ALGORITHM_STEP_DESCRIPTION"));
        this.mlblStepDescription.setPreferredRows(2);
        this.mlblStepDescription.setMinimumRows(2);
        this.mlblStepDescription.setPreferredColumns(this.rowLength);
        this.mlblStepDescription.setTextWrapper(WordWrapper.getTextWrapper());
        this.add((Component)this.mlblStepDescription, new GridBagConstraints(n2, n, 3, 1, 1.0, 0.0, 17, 1, new Insets(this.tInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        ++n;
        n2 = 0;
        this.lblAttributeCount.setText(ResourceUtilities.getUILabel("ACTIVE_ATTRIBUTE_COUNT"));
        this.lblAttributeCount.setLabelFor(this.lblAttributeCountValue);
        this.add((Component)this.lblAttributeCount, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(this.tInd + this.tGroupInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        ++n2;
        this.add((Component)this.lblAttributeCountValue, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(this.tInd + this.tGroupInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        ++n;
        n2 = 0;
        this.lblCaseCount.setText(ResourceUtilities.getUILabel("SAMPLE_CASE_COUNT"));
        this.lblCaseCount.setLabelFor(this.lblCaseCountValue);
        this.add((Component)this.lblCaseCount, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(this.tInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        ++n2;
        this.add((Component)this.lblCaseCountValue, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(this.tInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        ++n;
        n2 = 0;
        this.butRestore.setText(ResourceUtilities.getUILabel("RESTORE_BUTTON"));
        this.butRestore.setMnemonic(ResourceUtilities.getUIMnemonic("RESTORE_BUTTON"));
        this.butRestore.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdaptiveBayesNetworkPanel.this.butRestore_actionPerformed(actionEvent);
            }
        });
        this.add((Component)this.butRestore, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(this.tInd + this.tGroupInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        ++n;
        n2 = 0;
        this.lblModelBuildType.setText(ResourceUtilities.getUILabel("ALGO_ABN_MODEL_BUILD_TYPE"));
        this.lblModelBuildType.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("ALGO_ABN_MODEL_BUILD_TYPE"));
        this.lblModelBuildType.setLabelFor(this.comboModelBuildType);
        this.add((Component)this.lblModelBuildType, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(this.tInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        n2 = 1;
        this.comboModelBuildType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdaptiveBayesNetworkPanel.this.comboModelBuildType_actionPerformed(actionEvent);
            }
        });
        this.add((Component)this.comboModelBuildType, new GridBagConstraints(n2, n, 2, 1, 1.0, 0.0, 17, 0, new Insets(this.tInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        ++n;
        n2 = 1;
        this.lblModelBuildTypeHint1.setText(ResourceUtilities.getUILabel("ALGO_ABN_MODEL_BUILD_TYPE_HINT1"));
        this.lblModelBuildTypeHint1.setLabelFor(this.comboModelBuildType);
        this.add((Component)this.lblModelBuildTypeHint1, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        n = this.addPredictorControls(n, n2);
        ++n;
        n2 = 0;
        this.lblRunTimeQuestion.setText(ResourceUtilities.getUILabel("ALGO_ABN_RUN_TIME_QUESTION"));
        this.lblRunTimeQuestion.setLabelFor(this.optRunTimeOverrideYes);
        this.add((Component)this.lblRunTimeQuestion, new GridBagConstraints(n2, n, 2, 1, 0.0, 0.0, 17, 2, new Insets(this.tInd + this.tGroupInd, this.lInd + this.l2Ind, this.bInd, this.rInd), this.wPad, this.hPad));
        ++n;
        n2 = 0;
        this.optRunTimeOverrideYes.setText(ResourceUtilities.getUILabel("YES"));
        this.groupRunTimeOverride.add(this.optRunTimeOverrideYes);
        this.optRunTimeOverrideYes.setMnemonic(ResourceUtilities.getUIMnemonic("YES"));
        this.optRunTimeOverrideYes.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdaptiveBayesNetworkPanel.this.optRunTimeOverride_actionPerformed(actionEvent);
            }
        });
        this.add((Component)this.optRunTimeOverrideYes, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(this.tInd, this.lInd + this.l2Ind + this.l2Ind, this.bInd, this.rInd), this.wPad, this.hPad));
        n2 = 1;
        this.optRunTimeOverrideNo.setText(ResourceUtilities.getUILabel("NO"));
        this.groupRunTimeOverride.add(this.optRunTimeOverrideNo);
        this.optRunTimeOverrideNo.setMnemonic(ResourceUtilities.getUIMnemonic("NO"));
        this.optRunTimeOverrideNo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdaptiveBayesNetworkPanel.this.optRunTimeOverride_actionPerformed(actionEvent);
            }
        });
        this.add((Component)this.optRunTimeOverrideNo, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(this.tInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        ++n;
        n2 = 0;
        this.lblRunTime.setText(ResourceUtilities.getUILabel("ALGO_ABN_RUN_TIME_LIMIT"));
        this.lblRunTime.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("ALGO_ABN_RUN_TIME_LIMIT"));
        this.lblRunTime.setLabelFor(this.txtRunTime);
        this.add((Component)this.lblRunTime, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 13, 0, new Insets(this.tInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        n2 = 1;
        this.txtRunTime.setLocale(Locale.getDefault());
        this.txtRunTime.setDataType(Integer.TYPE);
        this.txtRunTime.setSigned(false);
        this.add((Component)this.txtRunTime, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(this.tInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        ++n;
        n2 = 1;
        this.lblRunTimeHint1.setText(ResourceUtilities.getUILabel("ALGO_ABN_RUN_TIME_LIMIT_HINT1"));
        this.txtRunTime.getAccessibleContext().setAccessibleDescription(this.lblRunTimeHint1.getText());
        this.add((Component)this.lblRunTimeHint1, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        n = this.addNaiveBayesPredictorControls(n, n2);
        this.displayModelTypeRelatedControls();
        n2 = 0;
        ++n;
        this.add((Component)this.lblFiller, new GridBagConstraints(n2, n, 3, 1, 1.0, 1.0, 17, 1, new Insets(this.tInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        JButton[] jButtonArray = new JButton[]{this.butRestore};
        ResourceUtilities.setPreferredSize(jButtonArray, 100, 25);
        JComponent[] jComponentArray = new JComponent[]{this.txtRunTime, this.txtNumberOfNetworkFeatures, this.txtNumberOfNBNetworkFeatures};
        ResourceUtilities.setTextBoxSize(jComponentArray, 70, 20);
        JComponent[] jComponentArray2 = new JComponent[]{this.comboModelBuildType};
        ResourceUtilities.setTextBoxSize(jComponentArray2, 120, 20);
        this.addOKHelpCancelListeners();
        this.loadState();
    }

    protected void loadState() {
        this.setCounts();
        this.loadModelBuildTypeCombo();
        this.setABNSettings();
    }

    protected void setABNSettings() {
        if (this.m_state.getAdaptiveNetworkBayes().getModelBuildTypeSelected().equals(OraABNModelType.singleFeature)) {
            this.comboModelBuildType.setSelectedItem("Single Feature");
        } else if (this.m_state.getAdaptiveNetworkBayes().getModelBuildTypeSelected().equals(OraABNModelType.multiFeature)) {
            this.comboModelBuildType.setSelectedItem("Multi Feature");
        } else if (this.m_state.getAdaptiveNetworkBayes().getModelBuildTypeSelected().equals(OraABNModelType.naiveBayes)) {
            this.comboModelBuildType.setSelectedItem("Naive Bayes");
        }
        if (this.m_state.getAdaptiveNetworkBayes().isRunTimeSelected()) {
            this.optRunTimeOverrideYes.setSelected(true);
            this.optRunTimeOverrideNo.setSelected(false);
            this.txtRunTime.setEnabled(true);
        } else {
            this.optRunTimeOverrideYes.setSelected(false);
            this.optRunTimeOverrideNo.setSelected(true);
            this.txtRunTime.setEnabled(false);
        }
        this.txtRunTime.setNumber(this.m_state.getAdaptiveNetworkBayes().getRunTime());
        this.txtNumberOfNetworkFeatures.setNumber(this.m_state.getAdaptiveNetworkBayes().getNumberOfNetworkFeatures());
        this.txtNumberOfNBNetworkFeatures.setNumber(this.m_state.getAdaptiveNetworkBayes().getNumberOfNBNetworkFeatures());
    }

    protected void setCounts() {
        this.lblAttributeCountValue.setText(DM4JNumericFormat.format(this.m_state.getActiveAttributeCountExcludingTargetsInteger()));
        this.lblCaseCountValue.setText(DM4JNumericFormat.format(this.m_state.getCaseCountInteger()));
    }

    protected void processUserInput() {
        AdaptiveBayesNetworkAlgorithmState adaptiveBayesNetworkAlgorithmState = this.m_state.getAdaptiveNetworkBayes();
        if (this.optRunTimeOverrideYes.isSelected()) {
            adaptiveBayesNetworkAlgorithmState.setRunTime((Integer)this.txtRunTime.getNumber());
        }
        adaptiveBayesNetworkAlgorithmState.setNumberOfNetworkFeatures((Integer)this.txtNumberOfNetworkFeatures.getNumber());
        adaptiveBayesNetworkAlgorithmState.setNumberOfNBNetworkFeatures((Integer)this.txtNumberOfNBNetworkFeatures.getNumber());
    }

    protected void addOKHelpCancelListeners() {
        this.m_parentDialog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdaptiveBayesNetworkPanel.this.m_parentDialog_actionPerformed(actionEvent);
            }
        });
    }

    protected void m_parentDialog_actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("ok" == string) {
            Vector vector = null;
            try {
                this.processUserInput();
                vector = this.m_state.getAdaptiveNetworkBayes().validate();
                DM4JEvent dM4JEvent = (DM4JEvent)actionEvent;
                DialogUtilities.displayValidations(vector, dM4JEvent, this.m_parentDialog);
            }
            catch (Exception exception) {
                this.m_state.getparentWizardState().doAbortCancel(exception);
            }
        } else if ("cancel" == string) {
            // empty if block
        }
    }

    protected void butRestore_actionPerformed(ActionEvent actionEvent) {
        this.m_state.getAdaptiveNetworkBayes().restoreSettingsToDefault();
        this.setABNSettings();
        this.displayModelTypeRelatedControls();
    }

    protected void optRunTimeOverride_actionPerformed(ActionEvent actionEvent) {
        if (this.optRunTimeOverrideYes.isSelected()) {
            this.m_state.getAdaptiveNetworkBayes().setRunTimeSelected(true);
            this.txtRunTime.setEnabled(true);
        } else {
            this.m_state.getAdaptiveNetworkBayes().setRunTimeSelected(false);
            this.txtRunTime.setEnabled(false);
        }
    }

    protected void loadModelBuildTypeCombo() {
        this.m_ignoreModelBuildTypeEvent = true;
        Vector<String> vector = new Vector<String>();
        vector.add("Single Feature");
        vector.add("Multi Feature");
        vector.add("Naive Bayes");
        this.modelBuildTypeModel = new DefaultComboBoxModel(vector);
        this.comboModelBuildType.setModel(this.modelBuildTypeModel);
        this.m_ignoreModelBuildTypeEvent = false;
    }

    protected void comboModelBuildType_actionPerformed(ActionEvent actionEvent) {
        try {
            if (!this.m_ignoreModelBuildTypeEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                String string = (String)jComboBox.getSelectedItem();
                if (string.equals("Single Feature")) {
                    this.m_state.getAdaptiveNetworkBayes().setModelBuildTypeSelected(OraABNModelType.singleFeature);
                } else if (string.equals("Multi Feature")) {
                    this.m_state.getAdaptiveNetworkBayes().setModelBuildTypeSelected(OraABNModelType.multiFeature);
                } else if (string.equals("Naive Bayes")) {
                    this.m_state.getAdaptiveNetworkBayes().setModelBuildTypeSelected(OraABNModelType.naiveBayes);
                }
                this.displayModelTypeRelatedControls();
            }
        }
        catch (Exception exception) {
            this.m_state.getparentWizardState().doAbortCancel(exception);
        }
    }

    protected int addPredictorControls(int n, int n2) throws Exception {
        ++n;
        n2 = 0;
        this.lblNumberOfNetworkFeatures.setText(ResourceUtilities.getUILabel("ALGO_ABN_NUMBER_OF_NETWORK_FEATURES"));
        this.lblNumberOfNetworkFeatures.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("ALGO_ABN_NUMBER_OF_NETWORK_FEATURES"));
        this.lblNumberOfNetworkFeatures.setLabelFor(this.txtNumberOfNetworkFeatures);
        this.add((Component)this.lblNumberOfNetworkFeatures, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(this.tInd + this.tGroupInd, this.lInd + this.l2Ind, this.bInd, this.rInd), this.wPad, this.hPad));
        n2 = 1;
        this.txtNumberOfNetworkFeatures.setLocale(Locale.getDefault());
        this.txtNumberOfNetworkFeatures.setDataType(Integer.TYPE);
        this.txtNumberOfNetworkFeatures.setSigned(false);
        this.add((Component)this.txtNumberOfNetworkFeatures, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(this.tInd + this.tGroupInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        ++n;
        n2 = 1;
        this.lblNumberOfNetworkFeaturesHint1.setText(ResourceUtilities.getUILabel("ALGO_ABN_NUMBER_OF_NETWORK_FEATURES_HINT1"));
        this.lblNumberOfNetworkFeaturesHint1.setLabelFor(this.txtNumberOfNetworkFeatures);
        this.add((Component)this.lblNumberOfNetworkFeaturesHint1, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        return n;
    }

    protected int addNaiveBayesPredictorControls(int n, int n2) throws Exception {
        ++n;
        n2 = 0;
        this.lblNumberOfNBNetworkFeatures.setText(ResourceUtilities.getUILabel("ALGO_ABN_NB_NUMBER_OF_NETWORK_FEATURES"));
        this.lblNumberOfNBNetworkFeatures.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("ALGO_ABN_NB_NUMBER_OF_NETWORK_FEATURES"));
        this.lblNumberOfNBNetworkFeatures.setLabelFor(this.txtNumberOfNBNetworkFeatures);
        this.add((Component)this.lblNumberOfNBNetworkFeatures, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(this.tInd + this.tGroupInd, this.lInd + this.l2Ind, this.bInd, this.rInd), this.wPad, this.hPad));
        n2 = 1;
        this.txtNumberOfNBNetworkFeatures.setLocale(Locale.getDefault());
        this.txtNumberOfNBNetworkFeatures.setDataType(Integer.TYPE);
        this.txtNumberOfNBNetworkFeatures.setSigned(false);
        this.add((Component)this.txtNumberOfNBNetworkFeatures, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(this.tInd + this.tGroupInd, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        ++n;
        n2 = 1;
        this.lblNumberOfNBNetworkFeaturesHint1.setText(ResourceUtilities.getUILabel("ALGO_ABN_NB_NUMBER_OF_NETWORK_FEATURES_HINT1"));
        this.lblNumberOfNBNetworkFeaturesHint1.setLabelFor(this.txtNumberOfNBNetworkFeatures);
        this.add((Component)this.lblNumberOfNBNetworkFeaturesHint1, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, this.lInd, this.bInd, this.rInd), this.wPad, this.hPad));
        return n;
    }

    protected void displayModelTypeRelatedControls() {
        if (this.m_state.getAdaptiveNetworkBayes().getModelBuildTypeSelected().equals(OraABNModelType.multiFeature)) {
            this.lblNumberOfNetworkFeatures.setVisible(true);
            this.lblNumberOfNetworkFeaturesHint1.setVisible(true);
            this.txtNumberOfNetworkFeatures.setVisible(true);
            this.lblNumberOfNBNetworkFeatures.setVisible(true);
            this.lblNumberOfNBNetworkFeaturesHint1.setVisible(true);
            this.txtNumberOfNBNetworkFeatures.setVisible(true);
            this.lblRunTimeQuestion.setVisible(true);
            this.optRunTimeOverrideYes.setVisible(true);
            this.optRunTimeOverrideNo.setVisible(true);
            this.lblRunTime.setVisible(true);
            this.lblRunTimeHint1.setVisible(true);
            this.txtRunTime.setVisible(true);
            this.lblNumberOfNBNetworkFeatures.setVisible(true);
            this.txtNumberOfNBNetworkFeatures.setVisible(true);
            this.lblNumberOfNBNetworkFeaturesHint1.setVisible(true);
        }
        if (this.m_state.getAdaptiveNetworkBayes().getModelBuildTypeSelected().equals(OraABNModelType.singleFeature)) {
            this.lblNumberOfNetworkFeatures.setVisible(true);
            this.lblNumberOfNetworkFeaturesHint1.setVisible(true);
            this.txtNumberOfNetworkFeatures.setVisible(true);
            this.lblNumberOfNBNetworkFeatures.setVisible(true);
            this.lblNumberOfNBNetworkFeaturesHint1.setVisible(true);
            this.txtNumberOfNBNetworkFeatures.setVisible(true);
            this.lblRunTimeQuestion.setVisible(true);
            this.optRunTimeOverrideYes.setVisible(true);
            this.optRunTimeOverrideNo.setVisible(true);
            this.lblRunTime.setVisible(true);
            this.lblRunTimeHint1.setVisible(true);
            this.txtRunTime.setVisible(true);
            this.lblNumberOfNBNetworkFeatures.setVisible(false);
            this.txtNumberOfNBNetworkFeatures.setVisible(false);
            this.lblNumberOfNBNetworkFeaturesHint1.setVisible(false);
        }
        if (this.m_state.getAdaptiveNetworkBayes().getModelBuildTypeSelected().equals(OraABNModelType.naiveBayes)) {
            this.lblNumberOfNetworkFeatures.setVisible(false);
            this.lblNumberOfNetworkFeaturesHint1.setVisible(false);
            this.txtNumberOfNetworkFeatures.setVisible(false);
            this.lblNumberOfNBNetworkFeatures.setVisible(true);
            this.lblNumberOfNBNetworkFeaturesHint1.setVisible(true);
            this.txtNumberOfNBNetworkFeatures.setVisible(true);
            this.lblRunTimeQuestion.setVisible(false);
            this.optRunTimeOverrideYes.setVisible(false);
            this.optRunTimeOverrideNo.setVisible(false);
            this.lblRunTime.setVisible(false);
            this.lblRunTimeHint1.setVisible(false);
            this.txtRunTime.setVisible(false);
            this.lblNumberOfNBNetworkFeatures.setVisible(true);
            this.txtNumberOfNBNetworkFeatures.setVisible(true);
            this.lblNumberOfNBNetworkFeaturesHint1.setVisible(true);
        }
    }
}

