/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard;

import java.io.File;
import java.util.HashMap;
import java.util.StringTokenizer;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.wizard.Wizard;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.bali.ewt.wizard.WizardListener;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.UserPreferences;
import oracle.dmt.dm4j.wizard.DM4JWizardInterface;
import oracle.dmt.dm4j.wizard.DM4JWizardListenerAdapter;
import oracle.dmt.dm4j.wizard.dialogs.DialogUtilities;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.state.commonsteps.OpenFileState;
import oracle.dmt.dm4j.wizard.state.transforms.FileImportState;
import oracle.dmt.dm4j.wizard.steps.DM4JPage;
import oracle.dmt.dm4j.wizard.steps.StepType;

public abstract class DM4JWizard
extends Wizard
implements WizardListener,
DM4JWizardInterface {
    protected static final String WIZARD_PAGE_LABEL_COLON = ":";
    public static final int DEFAULT_WIZARD_HEIGHT = 500;
    public static final int DEFAULT_WIZARD_WIDTH = 600;
    HashMap m_steps = new HashMap();
    WizardState m_state;
    DM4JWizardListenerAdapter m_wizListener;

    public DM4JWizard(WizardState wizardState, String string) throws Exception {
        this.m_state = wizardState;
        this.m_wizListener = new DM4JWizardListenerAdapter(wizardState);
        this.createWizardPageImage(string);
        this.m_state.setWizard(this);
    }

    public void addPage(DM4JPage dM4JPage, StepType stepType) {
        super.addPage(dM4JPage);
        this.addStep(stepType, dM4JPage);
    }

    public DM4JPage getStep(StepType stepType) {
        DM4JPage dM4JPage = null;
        dM4JPage = (DM4JPage)this.m_steps.get(stepType);
        return dM4JPage;
    }

    public boolean addStep(StepType stepType, DM4JPage dM4JPage) {
        this.m_steps.put(stepType, dM4JPage);
        return true;
    }

    public void doAbortCancel(Exception exception) {
        if (this.m_state instanceof FileImportState) {
            String string = "\\";
            string = System.getProperty("os.name").startsWith("Windows") ? "\\" : "/";
            String string2 = UserPreferences.getInstance().getWorkingDirectory() + string + "fileimport.log";
            File file = new File(string2);
            OpenFileState openFileState = (OpenFileState)this.m_state.getStep(StepType.DATA_STEP);
            String string3 = openFileState.getFile().getName();
            StringTokenizer stringTokenizer = new StringTokenizer(string3, ".");
            if (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
            }
            String string4 = UserPreferences.getInstance().getWorkingDirectory() + string + string3.toLowerCase() + ".bad";
            File file2 = new File(string4);
            DialogUtilities.createFileImportErrorDialog(BrowserFrame.getMainFrame(), exception, file, file2);
        } else {
            DialogUtilities.createSystemErrorDialog(BrowserFrame.getMainFrame(), exception);
        }
        super.doCancel();
    }

    public void wizardApplyState(WizardEvent wizardEvent) {
        this.m_wizListener.wizardApplyState(wizardEvent);
    }

    public void wizardCanceled(WizardEvent wizardEvent) {
        this.m_wizListener.wizardCanceled(wizardEvent);
    }

    public void wizardFinished(WizardEvent wizardEvent) {
        this.m_wizListener.wizardFinished(wizardEvent);
    }

    public void wizardSelectionChanged(WizardEvent wizardEvent) {
        this.m_wizListener.wizardSelectionChanged(wizardEvent);
    }

    public void createWizardPageImage(String string) {
        if (string.length() != 0) {
            this.m_state.setImage(ImageUtils.getImageResource(this.getClass(), string));
        }
    }
}

