/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.sqlworksheet.db;

import java.sql.Connection;
import java.util.ArrayList;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.browser.viewer.table.db.JdbcDatabase;
import oracle.dmt.dm4j.sqlworksheet.db.GenericJdbcDatabase;

public abstract class DatabaseFactory {
    private static ArrayList _factories = new ArrayList();

    protected DatabaseFactory() {
    }

    protected abstract JdbcDatabase createDatabaseImpl(String var1, Connection var2);

    public static final void registerDatabaseFactory(DatabaseFactory databaseFactory) {
        if (!_factories.contains(databaseFactory)) {
            _factories.add(databaseFactory);
        }
    }

    public static final JdbcDatabase createDatabase(Connection connection) throws Exception {
        return DatabaseFactory.createDatabase(null, connection);
    }

    public static final JdbcDatabase createDatabase(String string) throws Exception {
        return DatabaseFactory.createDatabase(string, null);
    }

    public static final JdbcDatabase createDatabase(String string, Connection connection) throws Exception {
        JdbcDatabase jdbcDatabase = null;
        try {
            Connection connection2 = connection;
            if (connection2 == null) {
                connection2 = DatabaseFactory.getConnection(string);
            }
            return DatabaseFactory._createDatabaseImpl(string, connection2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return jdbcDatabase;
        }
    }

    private static final JdbcDatabase _createDatabaseImpl(String string, Connection connection) {
        for (DatabaseFactory databaseFactory : _factories) {
            JdbcDatabase jdbcDatabase = databaseFactory.createDatabaseImpl(string, connection);
            if (jdbcDatabase == null) continue;
            return jdbcDatabase;
        }
        return new GenericJdbcDatabase(string, connection);
    }

    private static final Connection getConnection(String string) throws Exception {
        try {
            Connection connection = DM4JConnectionManager.getDbConnection();
            return connection;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

