/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.sqlworksheet;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.Connection;
import java.sql.ResultSet;
import javax.swing.JEditorPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.browser.viewer.table.db.JdbcDatabase;
import oracle.dmt.dm4j.sqlworksheet.HistoryList;
import oracle.dmt.dm4j.sqlworksheet.SqlEditorHistoryDialog;
import oracle.dmt.dm4j.sqlworksheet.SqlEditorMainPanel;
import oracle.dmt.dm4j.sqlworksheet.SwingWorker;
import oracle.dmt.dm4j.sqlworksheet.db.DatabaseFactory;

public class SqlEditor {
    SqlEditorMainPanel view = null;
    JdbcDatabase _db = null;
    private boolean _isOracle = false;
    Component focusedComponent;
    private HistoryList _history = null;

    public final void executeSql() {
        final String string = this.view.getSqlStatement();
        if (string == null || string.length() < 1) {
            return;
        }
        this.getHistoryList().update(string);
        this.open();
        final SqlEditorMainPanel sqlEditorMainPanel = this.view;
        final JdbcDatabase jdbcDatabase = this._db;
        sqlEditorMainPanel.setEnabled(false);
        sqlEditorMainPanel.setResultSet(null, DM4JResourceUtilities.getUIString("SQLW_EDITOR_WORKING"), false, this._db.getConnection(), string);
        SwingWorker swingWorker = new SwingWorker(){

            public Object construct() {
                ResultSet resultSet = jdbcDatabase.executeQuery(string);
                String string2 = jdbcDatabase.getLastErrorText();
                return new ResultWrapper(resultSet, string2 != null ? string2 : jdbcDatabase.getLastResultString(), string2 == null);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void finished() {
                try {
                    ResultWrapper resultWrapper = (ResultWrapper)this.get();
                    if (resultWrapper != null) {
                        sqlEditorMainPanel.setResultSet(resultWrapper._resultSet, resultWrapper._resultString, resultWrapper._success, jdbcDatabase.getConnection(), string);
                    }
                    Object var3_2 = null;
                    sqlEditorMainPanel.setEnabled(true);
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    sqlEditorMainPanel.setEnabled(true);
                    throw throwable;
                }
            }
        };
        swingWorker.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void executeExplainPlan() {
        try {
            try {
                String string = this.view.getSqlStatement();
                this.view.explainPlan(this._db.getConnection(), string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Object var3_4 = null;
            }
            Object var3_3 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            throw throwable;
        }
    }

    public final void doHistoryList() {
        String string = SqlEditorHistoryDialog.runDialog(this.getHistoryList().getHistory(), this.view);
        if (string != null) {
            this.setText(string);
        }
    }

    public void setText(String string) {
        this.view.taSql.setText(string);
    }

    public String getText() {
        return this.view.taSql.getText();
    }

    public Component getGUI() {
        if (null == this.view) {
            this.view = new SqlEditorMainPanel(this);
            this.view.taSql.addKeyListener(new KeyAdapter(){

                public void keyTyped(KeyEvent keyEvent) {
                    if (keyEvent.getKeyChar() == '\n' && keyEvent.isControlDown()) {
                        SqlEditor.this.executeSql();
                    }
                }
            });
            this.view.tblResults.addMouseListener(new MouseListener(){

                public void mouseClicked(MouseEvent mouseEvent) {
                }

                public void mouseEntered(MouseEvent mouseEvent) {
                }

                public void mouseExited(MouseEvent mouseEvent) {
                }

                public void mousePressed(MouseEvent mouseEvent) {
                    SqlEditor.this._tryContextMenu(mouseEvent);
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                    SqlEditor.this._tryContextMenu(mouseEvent);
                }
            });
        }
        return this.view;
    }

    public Component getDefaultFocusComponent() {
        return this.view.taSql;
    }

    public void open() {
        try {
            Connection connection = DM4JConnectionManager.getDbConnection();
            connection.setAutoCommit(true);
            this._db = DatabaseFactory.createDatabase(connection);
            this._isOracle = true;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
    }

    boolean isExplainPlanAllowed() {
        return this._isOracle;
    }

    HistoryList getHistoryList() {
        if (this._history == null) {
            this._history = new HistoryList(this.getClass().getName());
        }
        return this._history;
    }

    public void close() {
        if (this._db != null) {
            this._db.close();
            this._db = null;
        }
    }

    public JEditorPane getFocusedEditorPane() {
        return this.view.taSql;
    }

    private void _tryContextMenu(MouseEvent mouseEvent) {
        Component component = mouseEvent.getComponent();
        component.requestFocus();
        if (mouseEvent.isPopupTrigger()) {
            // empty if block
        }
    }

    private final class FocusHelper
    implements CaretListener,
    DocumentListener,
    FocusListener {
        private JTextComponent caretComponent;

        private FocusHelper(Component component, Document document) {
            this.addFocusListenerRecurse(component);
            document.addDocumentListener(this);
        }

        private void addFocusListenerRecurse(Component component) {
            if (component instanceof Container) {
                Component[] componentArray = ((Container)component).getComponents();
                for (int i = 0; i < componentArray.length; ++i) {
                    this.addFocusListenerRecurse(componentArray[i]);
                }
            }
            component.addFocusListener(this);
        }

        public void focusGained(FocusEvent focusEvent) {
            if (this.caretComponent != null) {
                this.caretComponent.removeCaretListener(this);
                this.caretComponent = null;
            }
            SqlEditor.this.focusedComponent = (Component)focusEvent.getSource();
            this.updateCommandSensitivities();
            if (SqlEditor.this.focusedComponent instanceof JTextComponent) {
                this.caretComponent = (JTextComponent)SqlEditor.this.focusedComponent;
                this.caretComponent.addCaretListener(this);
            }
        }

        public void focusLost(FocusEvent focusEvent) {
        }

        public void caretUpdate(CaretEvent caretEvent) {
            this.updateCommandSensitivities();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.updateCommandSensitivities();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        private void updateCommandSensitivities() {
        }
    }

    private static class ResultWrapper {
        private ResultSet _resultSet;
        private String _resultString;
        private boolean _success;

        ResultWrapper(ResultSet resultSet, String string, boolean bl) {
            this._resultSet = resultSet;
            this._resultString = string;
            this._success = bl;
        }
    }
}

