/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.sqlworksheet;

import java.util.LinkedList;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import oracle.dmt.dm4j.sqlworksheet.PropertyAccess;

public class HistoryList {
    private String name;
    private LinkedList items;
    private int maxHistorySize;
    private PropertyAccess properties;
    private static final int defaultMaxHistorySize = 32;
    private static String KEY_SUFFIX_COUNT = "HistoryCount";
    private static String KEY_SUFFIX_ITEM = "HistoryItem";

    public HistoryList(String string) {
        this(string, null);
    }

    public HistoryList(String string, PropertyAccess propertyAccess) {
        this.name = string;
        this.items = new LinkedList();
        this.maxHistorySize = 32;
        if (propertyAccess != null) {
            this.load(propertyAccess);
        }
    }

    public synchronized int getMaxHistorySize() {
        return this.maxHistorySize;
    }

    public synchronized void setMaxHistorySize(int n) {
        this.maxHistorySize = n;
        while (this.items.size() > n) {
            this.items.removeLast();
        }
    }

    public synchronized void load(PropertyAccess propertyAccess) {
        this.properties = propertyAccess;
        try {
            String string = propertyAccess.getProperty(this.name + KEY_SUFFIX_COUNT, null);
            int n = Integer.parseInt(string);
            for (int i = 0; i < n; ++i) {
                string = propertyAccess.getProperty(this.name + KEY_SUFFIX_ITEM + i, null);
                if (string == null) continue;
                this.items.add(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void clear() {
        this.items.clear();
    }

    public synchronized String[] getHistory() {
        return this.items.toArray(new String[this.items.size()]);
    }

    public int getSize() {
        return this.items.size();
    }

    public void fill(String[] stringArray) {
        if (this.items.size() == 0) {
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                this.items.add(stringArray[i]);
            }
        } else {
            for (int i = stringArray.length; i >= 0; --i) {
                this.update(stringArray[i]);
            }
        }
    }

    public synchronized void update(String string) {
        int n = this.items.indexOf(string);
        if (n == -1) {
            this.items.add(0, string);
            int n2 = this.items.size();
            if (n2 > this.maxHistorySize) {
                this.items.remove(n2 - 1);
            }
        } else {
            this.items.remove(n);
            this.items.add(0, string);
        }
    }

    public synchronized boolean remove(String string) {
        return this.items.remove(string);
    }

    public synchronized void save() {
        this.saveAs(this.properties);
    }

    public synchronized void saveAs(PropertyAccess propertyAccess) {
        int n;
        this.properties = propertyAccess;
        int n2 = this.items.size();
        propertyAccess.setProperty(this.name + KEY_SUFFIX_COUNT, Integer.toString(n2));
        for (n = 0; n < n2; ++n) {
            propertyAccess.setProperty(this.name + KEY_SUFFIX_ITEM + n, (String)this.items.get(n));
        }
        for (n = n2; n < this.maxHistorySize; ++n) {
            propertyAccess.removeProperty(this.name + KEY_SUFFIX_ITEM + n);
        }
    }

    public String comboBoxGetSelectedItem(JComboBox jComboBox) {
        JTextField jTextField = (JTextField)jComboBox.getEditor().getEditorComponent();
        return this.comboBoxGetSelectedItem(jTextField);
    }

    public String comboBoxGetSelectedItem(JTextField jTextField) {
        String string = jTextField.getText();
        this.updateHistory(string);
        return string;
    }

    public void updateHistory(String string) {
        this.update(string);
        this.save();
    }
}

