/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.sql;

import oracle.dmt.dm4j.sql.PLSQLPackage;

public class PLSQLAnonymousBlock {
    StringBuffer m_result = new StringBuffer(3000);
    private String m_plsqlPart1A = "DECLARE \n";
    private String m_plsqlPart1B = "sql_command dbms_sql.VARCHAR2S; \ncursor_name INTEGER; \nret INTEGER; \nlowerBound INTEGER := 0; \nupperBound INTEGER := 0; \nlineFeed   BOOLEAN := FALSE; \nERR_MSG    VARCHAR2(100); \n";
    private String m_plsqlPart1C = " \nBEGIN \n\n cursor_name := DBMS_SQL.OPEN_CURSOR; \n ";
    private String m_plsqlPart2 = "  DBMS_SQL.CLOSE_CURSOR(cursor_name); \n ";
    private String m_plsqlReturn = "  ? := ERR_MSG;\n";
    private String m_plsqlEnd = "END; \n";

    public PLSQLAnonymousBlock(StringBuffer[] stringBufferArray, boolean bl) {
        this.m_result.append(this.m_plsqlPart1A);
        this.m_result.append(this.m_plsqlPart1B);
        this.m_result.append(this.m_plsqlPart1C);
        for (int i = 0; i < stringBufferArray.length; ++i) {
            String[] stringArray = PLSQLPackage.createSQLArray(stringBufferArray[i]);
            if (bl) {
                this.addSQLtoPLSQLParseOnly(this.m_result, stringArray);
                continue;
            }
            this.addSQLtoPLSQL(this.m_result, stringArray);
        }
        this.m_result.append(this.m_plsqlPart2);
        if (bl) {
            this.m_result.append(this.m_plsqlReturn);
        }
        this.m_result.append(this.m_plsqlEnd);
    }

    public PLSQLAnonymousBlock(StringBuffer[] stringBufferArray, boolean[] blArray) {
        this.m_result.append(this.m_plsqlPart1A);
        this.m_result.append(this.m_plsqlPart1B);
        this.m_result.append(this.m_plsqlPart1C);
        for (int i = 0; i < stringBufferArray.length; ++i) {
            if (blArray[i]) {
                this.addPLSQLtoPLSQL(this.m_result, stringBufferArray[i].toString());
                continue;
            }
            String[] stringArray = PLSQLPackage.createSQLArray(stringBufferArray[i]);
            this.addSQLtoPLSQL(this.m_result, stringArray);
        }
        this.m_result.append(this.m_plsqlPart2);
        this.m_result.append(this.m_plsqlEnd);
    }

    public PLSQLAnonymousBlock(StringBuffer[] stringBufferArray) {
        this(stringBufferArray, false);
    }

    public PLSQLAnonymousBlock(StringBuffer[] stringBufferArray, String[] stringArray, String[] stringArray2, boolean[] blArray, boolean bl) {
        this(stringBufferArray, stringArray, stringArray2, blArray, bl, null);
    }

    public PLSQLAnonymousBlock(StringBuffer[] stringBufferArray, String[] stringArray, String[] stringArray2, boolean[] blArray, boolean bl, boolean[] blArray2) {
        int n;
        if (!bl) {
            this.m_result.append(this.m_plsqlPart1A);
        }
        this.m_result.append(this.m_plsqlPart1B);
        for (n = 0; n < stringArray.length; ++n) {
            this.m_result.append(stringArray[n] + " \n");
        }
        this.m_result.append(this.m_plsqlPart1C);
        for (n = 0; n < stringBufferArray.length; ++n) {
            if (blArray2 != null && blArray2[n]) {
                this.addPLSQLtoPLSQL(this.m_result, stringBufferArray[n].toString());
                continue;
            }
            String[] stringArray3 = PLSQLPackage.createSQLArray(stringBufferArray[n]);
            if (blArray[n]) {
                this.addSQLtoPLSQL(this.m_result, stringArray3, stringArray2);
                continue;
            }
            this.addSQLtoPLSQL(this.m_result, stringArray3);
        }
        this.m_result.append(this.m_plsqlPart2);
    }

    public String getResult() {
        return this.m_result.toString();
    }

    private void addSQLtoPLSQL(StringBuffer stringBuffer, String[] stringArray) {
        this.addSQLtoPLSQL(stringBuffer, stringArray, null);
    }

    private void addSQLtoPLSQL(StringBuffer stringBuffer, String[] stringArray, String[] stringArray2) {
        int n;
        stringBuffer.append("upperBound := " + (stringArray.length - 1) + "; \n ");
        for (n = 0; n < stringArray.length; ++n) {
            stringBuffer.append("sql_command(" + n + ") := '" + stringArray[n] + "'; \n");
        }
        if (stringArray2 != null) {
            stringBuffer.append("BEGIN \n");
        }
        stringBuffer.append("DBMS_SQL.PARSE(cursor_name,sql_command,lowerBound ,upperBound ,lineFeed,dbms_sql.NATIVE); \n");
        stringBuffer.append("ret := DBMS_SQL.EXECUTE(cursor_name); \n");
        if (stringArray2 != null) {
            for (n = 0; n < stringArray2.length; ++n) {
                stringBuffer.append("Exception \n");
                stringBuffer.append("WHEN " + stringArray2[n] + " THEN NULL; \n");
            }
            stringBuffer.append("END; \n");
        }
    }

    private void addSQLtoPLSQLParseOnly(StringBuffer stringBuffer, String[] stringArray) {
        stringBuffer.append("upperBound := " + (stringArray.length - 1) + "; \n ");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append("sql_command(" + i + ") := '" + stringArray[i] + "'; \n");
        }
        stringBuffer.append("  DBMS_SQL.PARSE(cursor_name,sql_command,lowerBound ,upperBound ,lineFeed,dbms_sql.NATIVE); \n");
        stringBuffer.append("  EXCEPTION \n");
        stringBuffer.append("    WHEN OTHERS THEN \n");
        stringBuffer.append("      ERR_MSG := SUBSTR(SQLERRM, 1, 100); \n");
    }

    private void addPLSQLtoPLSQL(StringBuffer stringBuffer, String string) {
        stringBuffer.append(string + "; \n");
    }
}

