/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.querybuilder;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;
import oracle.bali.dbUI.db.Schema;
import oracle.bali.dbUI.util.jdbc.JDBCDatabase;
import oracle.dmt.dm4j.datasources.DatabaseMetadata;
import oracle.dmt.dm4j.querybuilder.DM4JJDBCSchema;

public class DM4JJDBCDatabase
extends JDBCDatabase {
    private static final int _SCHEMA_NAME = 1;
    private Connection _connection;
    private DM4JJDBCSchema[] _schemas;
    private String[] _schemaNames;

    public DM4JJDBCDatabase(Connection connection) {
        super(connection);
        this._connection = connection;
    }

    public int getSchemaCount() {
        if (this._schemaNames == null) {
            this._createSchemaNames();
        }
        return this._schemaNames == null ? 0 : this._schemaNames.length;
    }

    public Schema getSchema(int n) {
        if (this._schemas == null) {
            this._schemas = new DM4JJDBCSchema[this.getSchemaCount()];
        }
        if (this._schemas[n] == null) {
            this._schemas[n] = this._createSchema(n);
        }
        return this._schemas[n];
    }

    public String getSchemaName(int n) {
        if (this._schemaNames == null) {
            this._createSchemaNames();
        }
        return this._schemaNames == null ? null : this._schemaNames[n];
    }

    private DM4JJDBCSchema _createSchema(int n) {
        return new DM4JJDBCSchema(this._connection, this, this.getSchemaName(n));
    }

    private void _createSchemaNames() {
        try {
            Vector vector = DatabaseMetadata.getAccessibleSchemas(this._connection);
            this._schemaNames = new String[vector.size()];
            if (vector.size() != 0) {
                vector.copyInto(this._schemaNames);
            }
        }
        catch (SQLException sQLException) {
            System.err.println("A SQLException occured " + sQLException);
        }
    }
}

