/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.querybuilder;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.UpperCaseTextField;
import oracle.dmt.dm4j.querybuilder.CreateViewDialog;
import oracle.dmt.dm4j.querybuilder.CreateViewState;
import oracle.dmt.dm4j.wizard.dialogs.DM4JEvent;
import oracle.dmt.dm4j.wizard.dialogs.DialogUtilities;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;

public class CreateViewPanel
extends GriddedPanel {
    CreateViewDialog m_parentDialog;
    CreateViewState m_state;
    MultiLineLabel mlblStepDescription = new MultiLineLabel();
    JLabel lblViewName = new JLabel();
    JTextField txtViewName = new UpperCaseTextField();
    JLabel lblViewComment = new JLabel();
    JTextArea txtViewComment = new JTextArea();
    JScrollPane scrollViewComment = new JScrollPane();
    JLabel lblFiller = new JLabel();

    public CreateViewPanel(CreateViewDialog createViewDialog, CreateViewState createViewState) throws Exception {
        this.m_state = createViewState;
        this.m_parentDialog = createViewDialog;
        this.txtViewName = new JTextField();
        this.jbInit();
    }

    private void jbInit() throws Exception {
        int n = 0;
        this.mlblStepDescription.setText(ResourceUtilities.getUILabel("VIEW_NAME_STEP_DESCRIPTION"));
        this.mlblStepDescription.setPreferredRows(1);
        this.mlblStepDescription.setMinimumRows(1);
        this.mlblStepDescription.setTextWrapper(WordWrapper.getTextWrapper());
        this.addFilledComponent(this.mlblStepDescription, TOP_DESC, n++, 0, 2, 1, 1);
        this.lblViewName.setText(ResourceUtilities.getUILabel("NAME"));
        this.lblViewName.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("NAME"));
        this.lblViewName.setLabelFor(this.txtViewName);
        this.addComponent(this.lblViewName, COL1_LABEL, n, 0);
        this.addFilledComponent(this.txtViewName, COL_VALUE, n++, 1);
        this.lblViewComment.setText(ResourceUtilities.getUILabel("COMMENT"));
        this.lblViewComment.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("COMMENT"));
        this.lblViewComment.setLabelFor(this.txtViewComment);
        this.addComponent(this.lblViewComment, COL1_LABEL, n, 0);
        this.txtViewComment.setLineWrap(true);
        this.scrollViewComment.getViewport().add((Component)this.txtViewComment, null);
        this.scrollViewComment.setPreferredSize(new Dimension(250, 200));
        this.addFilledComponent(this.scrollViewComment, COL_VALUE, n++, 1);
        this.addFilledComponent(this.lblFiller, COL1_LABEL, n, 0, 2, 2, 1);
        JComponent[] jComponentArray = new JComponent[]{this.txtViewName};
        CreateViewPanel.setPreferredSize(jComponentArray, 260, 20);
        this.addOKHelpCancelListeners();
        this.loadDefaultValues();
        this.txtViewName.requestFocus();
    }

    protected void loadDefaultValues() throws Exception {
        if (this.m_state != null) {
            String string = this.m_state.getView();
            String string2 = this.m_state.getSchema();
            String[] stringArray = new String[]{ResourceUtilities.getUILabel("CREATE_VIEW_SAVE_DIALOG"), string2, string};
            this.txtViewName.setText(string);
        }
    }

    protected void processUserInput() {
        if (this.m_state != null) {
            this.m_state.setView(this.txtViewName.getText());
            this.m_state.setComment(this.txtViewComment.getText());
        }
    }

    protected void addOKHelpCancelListeners() {
        this.m_parentDialog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CreateViewPanel.this.m_parentDialog_actionPerformed(actionEvent);
            }
        });
    }

    protected void m_parentDialog_actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("ok" == string) {
            Vector vector = new Vector();
            try {
                this.processUserInput();
                this.m_state.validate(vector);
                DM4JEvent dM4JEvent = (DM4JEvent)actionEvent;
                DialogUtilities.displayValidations(vector, dM4JEvent, this.m_parentDialog);
                this.m_state.setSave(true);
            }
            catch (Exception exception) {}
        } else if ("cancel" == string) {
            this.m_state.setSave(false);
            DM4JEvent dM4JEvent = (DM4JEvent)actionEvent;
            dM4JEvent.cancel();
        }
    }
}

