/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.lineage;

import java.awt.Dimension;
import java.sql.Connection;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.datasources.DatabaseMetadata;
import oracle.dmt.dm4j.lineage.LineageTreeNode;

public class ViewDetailsPanel
extends GriddedPanel {
    private JTextField m_lblViewName = new JTextField();
    private JTextArea m_taViewDefition = new JTextArea();
    private LineageTreeNode m_node = null;

    public ViewDetailsPanel(LineageTreeNode lineageTreeNode) {
        try {
            this.m_node = lineageTreeNode;
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void jbInit() throws Exception {
        this.setPreferredSize(new Dimension(50, 50));
        JLabel jLabel = new JLabel();
        String string = null;
        string = this.m_node.isView() ? DM4JResourceUtilities.getUIString("COMMON_VIEW_NAME") : DM4JResourceUtilities.getUIString("COMMON_TABLE_NAME");
        jLabel.setText(string);
        int n = 0;
        this.m_lblViewName.setEditable(false);
        this.m_lblViewName.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.m_lblViewName.setText(this.m_node.getSchemaName() + "." + this.m_node.getViewName());
        this.addFilledComponent(jLabel, TOPLABELITEMINSETS, n, 0, 1, 1, 0);
        this.addFilledComponent(this.m_lblViewName, TOPVALUEITEMINSETS, n++, 1, 1, 1, 0);
        if (!this.m_node.isView()) {
            JLabel jLabel2 = new JLabel("");
            this.addFilledComponent(jLabel2, TOPLABELITEMINSETS, n, 0, 2, 4, 1);
            return;
        }
        JLabel jLabel3 = new JLabel();
        jLabel3.setText(DM4JResourceUtilities.getUIString("LINEAGE_VIEW_DEF"));
        jLabel3.setDisplayedMnemonic(DM4JResourceUtilities.getUIMnemonic("LINEAGE_VIEW_DEF"));
        this.addFilledComponent(jLabel3, TOPLABELITEMINSETS, n++, 0, 2, 1, 2);
        this.m_taViewDefition.setEditable(false);
        this.m_taViewDefition.setBackground(this.getBackground());
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(this.m_taViewDefition);
        jLabel3.setLabelFor(this.m_taViewDefition);
        this.addFilledComponent(jScrollPane, MIDLABELITEMINSETS, n++, 0, 2, 3, 1);
        Connection connection = null;
        connection = DM4JConnectionManager.getDbConnection();
        String string2 = DatabaseMetadata.getViewText(connection, this.m_node.getSchemaName(), this.m_node.getViewName());
        this.m_taViewDefition.setText(string2);
        Object var9_10 = null;
        if (connection == null) return;
        try {
            connection.close();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return;
        {
            catch (Exception exception) {
                this.m_taViewDefition.setText(DM4JResourceUtilities.getUIString("LINEAGE_ERROR_NODEF"));
                Object var9_11 = null;
                if (connection == null) return;
                try {
                    connection.close();
                    return;
                }
                catch (Exception exception2) {
                    exception2.printStackTrace();
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            throw throwable;
        }
    }

    public String getSchemaName() {
        return this.m_node.getSchemaName();
    }

    public String getViewName() {
        return this.m_node.getViewName();
    }
}

