/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.lineage;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.browser.tree.TreeIconManager;
import oracle.dmt.dm4j.lineage.LineageTreeNode;

public class LineageTreeCellRenderer
extends JLabel
implements TreeCellRenderer {
    private Color m_textSelectionColor = UIManager.getColor("Tree.selectionForeground");
    private Color m_textNonSelectionColor = UIManager.getColor("Tree.textForeground");
    private Color m_bkSelectionColor = UIManager.getColor("Tree.selectionBackground");
    private Color m_bkNonSelectionColor = UIManager.getColor("Tree.textBackground");
    private Color m_borderSelectionColor = UIManager.getColor("Tree.selectionBorderColor");
    private boolean m_bSelected;

    public LineageTreeCellRenderer() {
        this.setOpaque(false);
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
        if (defaultMutableTreeNode instanceof LineageTreeNode) {
            LineageTreeNode lineageTreeNode = (LineageTreeNode)defaultMutableTreeNode;
            String string = lineageTreeNode.getSchemaName() + "." + lineageTreeNode.getViewName();
            this.setText(string);
            TreeIconManager treeIconManager = TreeIconManager.getInstance();
            String string2 = null;
            if (lineageTreeNode.getType().equalsIgnoreCase("TABLE")) {
                string2 = "TABLE";
            } else if (lineageTreeNode.getType().equalsIgnoreCase("VIEW")) {
                string2 = "VIEW";
            }
            Icon icon = treeIconManager.getIcon(string2);
            this.setIcon(icon);
            this.setToolTipText(string);
        } else {
            this.setText(DM4JResourceUtilities.getUIString("COMMON_LOADING"));
            this.setIcon(null);
        }
        this.setForeground(bl ? this.m_textSelectionColor : this.m_textNonSelectionColor);
        this.setBackground(bl ? this.m_bkSelectionColor : this.m_bkNonSelectionColor);
        this.m_bSelected = bl;
        return this;
    }

    public void paintComponent(Graphics graphics) {
        Color color = this.getBackground();
        Icon icon = this.getIcon();
        graphics.setColor(color);
        int n = 0;
        if (icon != null && this.getText() != null) {
            n = icon.getIconWidth() + this.getIconTextGap();
        }
        graphics.fillRect(n, 0, this.getWidth() - 1 - n, this.getHeight() - 1);
        if (this.m_bSelected) {
            graphics.setColor(this.m_borderSelectionColor);
            graphics.drawRect(n, 0, this.getWidth() - 1 - n, this.getHeight() - 1);
        }
        super.paintComponent(graphics);
    }
}

