/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.expressionbuilder;

import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.sql.Connection;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.datasources.DatabaseMetadata;
import oracle.dmt.dm4j.expressionbuilder.AbstractExpressionBuilderContext;
import oracle.dmt.dm4j.expressionbuilder.AggregateContext;
import oracle.dmt.dm4j.expressionbuilder.ComputeFieldContext;
import oracle.dmt.dm4j.expressionbuilder.ExpressionBuilderDialog;
import oracle.dmt.dm4j.expressionbuilder.SQLExpressionItemData;

public class ExpressionBuilderMainPanel
extends GriddedPanel {
    private AbstractExpressionBuilderContext m_ebc = null;
    private ExpressionBuilderDialog m_parent = null;
    private boolean m_expressionDirty = false;
    private JTabbedPane m_tpExprAssist = new JTabbedPane();
    private JTree m_treeAttributeList = new JTree();
    private JTree m_treeFunctionList = new JTree();
    private JTextField m_txtAttributeName = null;
    private JTextArea m_taExpressionEditor = null;
    private JTextArea m_taValidationResults = new JTextArea();
    private JButton m_btnValidate = new JButton();
    private final JButton[] btnFunctions = new JButton[]{new JButton("<"), new JButton(">"), new JButton("<="), new JButton(">="), new JButton("!="), new JButton("="), new JButton("Or"), new JButton("And"), new JButton("("), new JButton(")"), new JButton("||"), new JButton("+"), new JButton("-"), new JButton("*"), new JButton("/"), new JButton("%")};

    public ExpressionBuilderMainPanel(AbstractExpressionBuilderContext abstractExpressionBuilderContext, ExpressionBuilderDialog expressionBuilderDialog) {
        try {
            this.m_ebc = abstractExpressionBuilderContext;
            this.m_parent = expressionBuilderDialog;
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        int n;
        Serializable serializable;
        Object object;
        Object object2;
        int n2 = 0;
        this.loadAttributeList();
        this.loadFunctionList();
        JScrollPane jScrollPane = new JScrollPane();
        JScrollPane jScrollPane2 = new JScrollPane();
        jScrollPane.getViewport().add(this.m_treeAttributeList);
        jScrollPane2.getViewport().add(this.m_treeFunctionList);
        jScrollPane.setMinimumSize(new Dimension(250, 50));
        this.m_tpExprAssist.add(DM4JResourceUtilities.getUIString("EXPBLDR_TAB_ATTRIBUTES"), jScrollPane);
        this.m_tpExprAssist.add(DM4JResourceUtilities.getUIString("EXPBLDR_TAB_FUNCTIONS"), jScrollPane2);
        this.addFilledComponent(this.m_tpExprAssist, TOPLABELITEMINSETS, n2, 0, 1, 8, 1);
        JLabel jLabel = new JLabel(DM4JResourceUtilities.getUIString("EXPBLDR_EXPRESSION"));
        if (this.m_ebc instanceof ComputeFieldContext) {
            object2 = (ComputeFieldContext)this.m_ebc;
            object = ((ComputeFieldContext)object2).getAttributeName();
            this.m_txtAttributeName = new JTextField((String)object);
            serializable = new JLabel(DM4JResourceUtilities.getUIString("EXPBLDR_COLUMN_NAME"));
            n = DM4JResourceUtilities.getUIMnemonic("EXPBLDR_COLUMN_NAME");
            ((JLabel)serializable).setDisplayedMnemonic(n);
            ((JLabel)serializable).setLabelFor(this.m_txtAttributeName);
            this.addFilledComponent((JComponent)serializable, TOPLABELITEMINSETS, n2, 1, 1, 1, 2);
            this.addFilledComponent(this.m_txtAttributeName, TOPLABELITEMINSETS, n2++, 2, 2, 1, 2);
            this.addFilledComponent(jLabel, TOPLABELITEMINSETS, n2++, 1, 3, 1, 2);
        } else {
            this.addFilledComponent(jLabel, TOPLABELITEMINSETS, n2++, 1, 3, 1, 2);
        }
        this.m_taExpressionEditor = new JTextArea(this.m_ebc.getExpression());
        this.m_taExpressionEditor.setEditable(true);
        this.m_taExpressionEditor.setLineWrap(true);
        this.m_taExpressionEditor.setWrapStyleWord(true);
        this.m_taExpressionEditor.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                ExpressionBuilderMainPanel.this.setExpressionDirty(true);
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                ExpressionBuilderMainPanel.this.setExpressionDirty(true);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                ExpressionBuilderMainPanel.this.setExpressionDirty(true);
            }
        });
        object2 = new JScrollPane();
        ((JScrollPane)object2).getViewport().add(this.m_taExpressionEditor);
        this.addFilledComponent((JComponent)object2, MIDLABELITEMINSETS, n2, 1, 4, 2, 1);
        n2 += 2;
        object = new JPanel();
        serializable = new GridLayout(2, 8);
        ((GridLayout)serializable).setHgap(2);
        ((GridLayout)serializable).setVgap(2);
        ((Container)object).setLayout((LayoutManager)((Object)serializable));
        ((JComponent)object).setMinimumSize(new Dimension(500, 50));
        ((JComponent)object).setPreferredSize(new Dimension(500, 50));
        ((JComponent)object).setMaximumSize(new Dimension(500, 50));
        for (n = 0; n < this.btnFunctions.length; ++n) {
            this.btnFunctions[n].setMinimumSize(new Dimension(50, 30));
            ((Container)object).add(this.btnFunctions[n]);
            final int n3 = n;
            this.btnFunctions[n].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = ExpressionBuilderMainPanel.this.m_taExpressionEditor.getCaretPosition();
                    String string = " " + ExpressionBuilderMainPanel.this.btnFunctions[n3].getText() + " ";
                    ExpressionBuilderMainPanel.this.m_taExpressionEditor.insert(string, n);
                    ExpressionBuilderMainPanel.this.m_taExpressionEditor.setCaretPosition(n + string.length());
                    ExpressionBuilderMainPanel.this.m_taExpressionEditor.requestFocus();
                }
            });
        }
        this.addFilledComponent((JComponent)object, TOPLABELITEMINSETS, n2++, 1, 4, 1, 0);
        JLabel jLabel2 = new JLabel(DM4JResourceUtilities.getUIString("EXPBLDR_PANEL_VALIDATION_RESULTS"));
        this.addFilledComponent(jLabel2, TOPLABELITEMINSETS, n2++, 1, 3, 1, 2);
        this.m_taValidationResults.setEditable(false);
        this.m_taValidationResults.setLineWrap(true);
        this.m_taValidationResults.setWrapStyleWord(true);
        JScrollPane jScrollPane3 = new JScrollPane();
        jScrollPane3.getViewport().add(this.m_taValidationResults);
        this.addFilledComponent(jScrollPane3, MIDLABELITEMINSETS, n2, 1, 3, 2, 1);
        this.addFilledComponent(this.m_btnValidate, MIDLABELITEMINSETS, n2, 4, 2);
        this.m_btnValidate.setText(DM4JResourceUtilities.getUIString("EXPBLDR_PANEL_VALIDATE"));
        int n4 = DM4JResourceUtilities.getUIMnemonic("EXPBLDR_PANEL_VALIDATE");
        this.m_btnValidate.setMnemonic(n4);
        this.m_btnValidate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExpressionBuilderMainPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                boolean bl = false;
                try {
                    if (ExpressionBuilderMainPanel.this.m_parent.validateExpression()) {
                        bl = true;
                    }
                }
                catch (Exception exception) {
                    ExpressionBuilderMainPanel.this.setValidationAreaText(exception.getLocalizedMessage());
                }
                ExpressionBuilderMainPanel.this.setCursor(Cursor.getPredefinedCursor(0));
                if (bl) {
                    ExpressionBuilderMainPanel.this.setValidationAreaText(DM4JResourceUtilities.getUIString("EXPBLDR_PANEL_VALIDATE_SUCCESS"));
                    ExpressionBuilderMainPanel.this.setExpressionDirty(false);
                }
            }
        });
    }

    public Vector getSourceAttributeNames() {
        Vector<String> vector = new Vector<String>();
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.m_treeAttributeList.getModel();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)defaultTreeModel.getRoot();
        int n = defaultMutableTreeNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            vector.add((String)defaultMutableTreeNode2.getUserObject());
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void loadAttributeList() {
        block9: {
            Object object;
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(new String(this.m_ebc.getSchemaName() + "." + this.m_ebc.getTableName()));
            Connection connection = null;
            connection = DM4JConnectionManager.getDbConnection();
            Vector vector = DatabaseMetadata.getColumnNames(connection, this.m_ebc.getSchemaName(), this.m_ebc.getTableName());
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(object));
            }
            object = new DefaultTreeModel(defaultMutableTreeNode);
            this.m_treeAttributeList.setModel((TreeModel)object);
            KeyAdapter keyAdapter = new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 10) {
                        TreePath treePath = ExpressionBuilderMainPanel.this.m_treeAttributeList.getSelectionPath();
                        if (treePath != null) {
                            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                            if (ExpressionBuilderMainPanel.this.m_treeAttributeList.getModel().isLeaf(defaultMutableTreeNode)) {
                                Object object = defaultMutableTreeNode.getUserObject();
                                String string = "\"" + ExpressionBuilderMainPanel.this.m_ebc.getTableName() + "\".\"" + object.toString() + "\" ";
                                ExpressionBuilderMainPanel.this.insertText(ExpressionBuilderMainPanel.this.m_taExpressionEditor, string);
                            }
                            keyEvent.consume();
                        }
                    } else {
                        super.keyPressed(keyEvent);
                    }
                }
            };
            this.m_treeAttributeList.addKeyListener(keyAdapter);
            MouseAdapter mouseAdapter = new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    int n = ExpressionBuilderMainPanel.this.m_treeAttributeList.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                    TreePath treePath = ExpressionBuilderMainPanel.this.m_treeAttributeList.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                    if (n != -1 && mouseEvent.getClickCount() == 2) {
                        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                        Object object = defaultMutableTreeNode.getUserObject();
                        String string = "\"" + ExpressionBuilderMainPanel.this.m_ebc.getTableName() + "\".\"" + object.toString() + "\" ";
                        ExpressionBuilderMainPanel.this.insertText(ExpressionBuilderMainPanel.this.m_taExpressionEditor, string);
                    }
                }
            };
            this.m_treeAttributeList.addMouseListener(mouseAdapter);
            Object var9_11 = null;
            try {
                connection.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            break block9;
            {
                catch (Exception exception) {
                    String string = DM4JResourceUtilities.getUIString("DMS_CONNECTION_NOCREATE");
                    String string2 = DM4JResourceUtilities.getUIString("APPLICATION_TITLE");
                    JOptionPane.showMessageDialog(BrowserFrame.getMainFrame(), string, string2, 0);
                    Object var9_12 = null;
                    try {
                        connection.close();
                    }
                    catch (Exception exception2) {
                        exception2.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                try {
                    connection.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                throw throwable;
            }
        }
    }

    private void loadFunctionList() {
        this.m_treeFunctionList.setRootVisible(false);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(DM4JResourceUtilities.getUIString("EXPBLDR_TAB_FUNCTIONS"));
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(DM4JResourceUtilities.getUIString("EXPBLDR_TAB_FUNCTIONS_CHARACTER"));
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(DM4JResourceUtilities.getUIString("EXPBLDR_TAB_FUNCTIONS_CONVERSION"));
        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(DM4JResourceUtilities.getUIString("EXPBLDR_TAB_FUNCTIONS_DATE"));
        DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode(DM4JResourceUtilities.getUIString("EXPBLDR_TAB_FUNCTIONS_NUMERIC"));
        DefaultMutableTreeNode defaultMutableTreeNode6 = new DefaultMutableTreeNode(DM4JResourceUtilities.getUIString("EXPBLDR_TAB_FUNCTIONS_ANALYTICAL"));
        DefaultMutableTreeNode defaultMutableTreeNode7 = new DefaultMutableTreeNode(DM4JResourceUtilities.getUIString("EXPBLDR_TAB_FUNCTIONS_AGGREGATE"));
        DefaultMutableTreeNode defaultMutableTreeNode8 = new DefaultMutableTreeNode(DM4JResourceUtilities.getUIString("EXPBLDR_TAB_FUNCTIONS_NVS"));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
        defaultMutableTreeNode.add(defaultMutableTreeNode4);
        defaultMutableTreeNode.add(defaultMutableTreeNode5);
        if (this.m_ebc instanceof ComputeFieldContext) {
            defaultMutableTreeNode.add(defaultMutableTreeNode6);
        } else {
            defaultMutableTreeNode.add(defaultMutableTreeNode7);
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode8);
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(defaultMutableTreeNode);
        Vector vector = null;
        vector = SQLExpressionItemData.getCharacterFunctions();
        this.loadFunctionTreeNode(defaultMutableTreeNode2, vector);
        vector = SQLExpressionItemData.getConversionFunctions();
        this.loadFunctionTreeNode(defaultMutableTreeNode3, vector);
        vector = SQLExpressionItemData.getDateFunctions();
        this.loadFunctionTreeNode(defaultMutableTreeNode4, vector);
        vector = SQLExpressionItemData.getNumericFunctions();
        this.loadFunctionTreeNode(defaultMutableTreeNode5, vector);
        if (this.m_ebc instanceof ComputeFieldContext) {
            vector = SQLExpressionItemData.getAnalyticalFunctions();
            this.loadFunctionTreeNode(defaultMutableTreeNode6, vector);
        } else if (this.m_ebc instanceof AggregateContext) {
            vector = SQLExpressionItemData.getAggregateFunctions();
            this.loadFunctionTreeNode(defaultMutableTreeNode7, vector);
        }
        vector = SQLExpressionItemData.getNullValueSubstitutionFunctions();
        this.loadFunctionTreeNode(defaultMutableTreeNode8, vector);
        this.m_treeFunctionList.setModel(defaultTreeModel);
        KeyAdapter keyAdapter = new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    TreePath treePath = ExpressionBuilderMainPanel.this.m_treeFunctionList.getSelectionPath();
                    if (treePath != null) {
                        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                        if (ExpressionBuilderMainPanel.this.m_treeAttributeList.getModel().isLeaf(defaultMutableTreeNode)) {
                            Object object = defaultMutableTreeNode.getUserObject();
                            if (object instanceof SQLExpressionItemData) {
                                SQLExpressionItemData sQLExpressionItemData = (SQLExpressionItemData)object;
                                String string = ExpressionBuilderMainPanel.this.getSqlTemplate(sQLExpressionItemData);
                                ExpressionBuilderMainPanel.this.insertText(ExpressionBuilderMainPanel.this.m_taExpressionEditor, string);
                            }
                        } else if (ExpressionBuilderMainPanel.this.m_treeAttributeList.isExpanded(treePath)) {
                            ExpressionBuilderMainPanel.this.m_treeFunctionList.collapsePath(treePath);
                        } else {
                            ExpressionBuilderMainPanel.this.m_treeFunctionList.expandPath(treePath);
                        }
                        keyEvent.consume();
                    }
                } else {
                    super.keyPressed(keyEvent);
                }
            }
        };
        this.m_treeFunctionList.addKeyListener(keyAdapter);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                DefaultMutableTreeNode defaultMutableTreeNode;
                Object object;
                int n = ExpressionBuilderMainPanel.this.m_treeFunctionList.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                TreePath treePath = ExpressionBuilderMainPanel.this.m_treeFunctionList.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (n != -1 && mouseEvent.getClickCount() == 2 && (object = (defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject()) instanceof SQLExpressionItemData) {
                    SQLExpressionItemData sQLExpressionItemData = (SQLExpressionItemData)object;
                    String string = ExpressionBuilderMainPanel.this.getSqlTemplate(sQLExpressionItemData);
                    ExpressionBuilderMainPanel.this.insertText(ExpressionBuilderMainPanel.this.m_taExpressionEditor, string);
                }
            }
        };
        this.m_treeFunctionList.addMouseListener(mouseAdapter);
    }

    private String getSqlTemplate(SQLExpressionItemData sQLExpressionItemData) {
        return sQLExpressionItemData.getTemplate();
    }

    private void insertText(JTextArea jTextArea, String string) {
        int n;
        int n2 = jTextArea.getCaretPosition();
        int n3 = jTextArea.getSelectionStart();
        if (n3 < (n = jTextArea.getSelectionEnd())) {
            jTextArea.replaceRange(string, n3, n);
            jTextArea.setCaretPosition(n3 + string.length());
        } else {
            jTextArea.insert(string, n2);
            jTextArea.setCaretPosition(n2 + string.length());
        }
        jTextArea.requestFocus();
    }

    private void loadFunctionTreeNode(DefaultMutableTreeNode defaultMutableTreeNode, Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            SQLExpressionItemData sQLExpressionItemData = (SQLExpressionItemData)enumeration.nextElement();
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(sQLExpressionItemData));
        }
    }

    public String getAttributeName() {
        return this.m_txtAttributeName.getText();
    }

    public String getExpression() {
        return this.m_taExpressionEditor.getText();
    }

    public void setValidationAreaText(String string) {
        this.m_taValidationResults.setText(string);
    }

    private void setExpressionDirty(boolean bl) {
        this.m_expressionDirty = bl;
    }

    public boolean isExpressionDirty() {
        return this.m_expressionDirty;
    }
}

