/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.expressionbuilder;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import oracle.bali.ewt.util.WindowUtils;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JVersion;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.expressionbuilder.AbstractExpressionBuilderContext;
import oracle.dmt.dm4j.expressionbuilder.AggregateContext;
import oracle.dmt.dm4j.expressionbuilder.ComputeFieldContext;
import oracle.dmt.dm4j.expressionbuilder.ExpressionBuilderMainPanel;
import oracle.dmt.dm4j.expressionbuilder.Filter2DContext;
import oracle.dmt.dm4j.sql.PLSQLAnonymousBlock;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.help.CSHManager;
import oracle.help.Help;
import oracle.jdbc.OracleCallableStatement;

public class ExpressionBuilderDialog
extends JDialog {
    private AbstractExpressionBuilderContext m_ebc = null;
    private boolean m_isOk = false;
    private String m_origAttribName = null;
    private ExpressionBuilderMainPanel m_dialogPanel = null;
    private static final String newAttributeQuery = "SELECT {0} AS \"{1}\" FROM \"{2}\".\"{3}\"";
    private static final String aggregateQuery = "SELECT {0} FROM \"{1}\".\"{2}\"";
    private static final String filter2DQuery = "SELECT * FROM \"{0}\".\"{1}\" WHERE {2}";

    public ExpressionBuilderDialog(AbstractExpressionBuilderContext abstractExpressionBuilderContext) {
        super((Frame)BrowserFrame.getMainFrame(), true);
        try {
            this.m_ebc = abstractExpressionBuilderContext;
            if (this.m_ebc instanceof ComputeFieldContext) {
                this.m_origAttribName = ((ComputeFieldContext)abstractExpressionBuilderContext).getAttributeName();
            }
            this.setTitle(DM4JVersion.getFullBrowserName() + " - " + DM4JResourceUtilities.getUIString("EXPBLDR_TITLE"));
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setSize(new Dimension(735, 532));
        WindowUtils.centerWindow(this);
        this.m_dialogPanel = new ExpressionBuilderMainPanel(this.m_ebc, this);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.m_dialogPanel, "Center");
        GriddedPanel griddedPanel = new GriddedPanel();
        JButton jButton = new JButton(DM4JResourceUtilities.getUIString("COMMON_OK"));
        JButton jButton2 = new JButton(DM4JResourceUtilities.getUIString("COMMON_CANCEL"));
        JButton jButton3 = new JButton(DM4JResourceUtilities.getUIString("COMMON_HELP"));
        JLabel jLabel = new JLabel();
        griddedPanel.addFilledComponent(jButton3, GriddedPanel.DIALOG_BOTTOM_LEFTMOST_BUTTON, 0, 0, 1, 1, 2);
        griddedPanel.addFilledComponent(jLabel, GriddedPanel.DIALOG_BOTTOM_MID_BUTTONS, 0, 1, 4, 1, 2);
        griddedPanel.addFilledComponent(jButton, GriddedPanel.DIALOG_BOTTOM_MID_BUTTONS, 0, 5, 1, 1, 2);
        griddedPanel.addFilledComponent(jButton2, GriddedPanel.DIALOG_BOTTOM_RIGHTMOST_BUTTON, 0, 6, 1, 1, 2);
        this.getContentPane().add((Component)griddedPanel, "South");
        this.getRootPane().setDefaultButton(jButton);
        this.getRootPane().registerKeyboardAction(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExpressionBuilderDialog.this.cancel_actionPerformed(actionEvent);
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExpressionBuilderDialog.this.ok_actionPerformed(actionEvent);
            }
        });
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExpressionBuilderDialog.this.cancel_actionPerformed(actionEvent);
            }
        });
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExpressionBuilderDialog.this.help_actionPerformed(actionEvent);
            }
        });
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ExpressionBuilderDialog.this.setVisible(false);
                ExpressionBuilderDialog.this.dispose();
            }
        });
    }

    private void ok_actionPerformed(ActionEvent actionEvent) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (this.m_ebc instanceof ComputeFieldContext) {
            try {
                if (!this.validateAttributeName()) {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    return;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (this.m_dialogPanel.isExpressionDirty()) {
            boolean bl = false;
            try {
                if (this.validateExpression()) {
                    bl = true;
                }
            }
            catch (Exception exception) {
                this.m_dialogPanel.setValidationAreaText(exception.getLocalizedMessage());
                String string = DM4JResourceUtilities.getUIString("EXPBLDR_ERROR_PARSE");
                this.showMessage(string, -1, 0);
            }
            if (!bl) {
                this.setCursor(Cursor.getPredefinedCursor(0));
                return;
            }
        }
        this.m_isOk = true;
        this.setVisible(false);
        this.dispose();
    }

    protected void help_actionPerformed(ActionEvent actionEvent) {
        Help.registerClientWindow(this);
        CSHManager cSHManager = BrowserFrame.getCSHManager();
        try {
            cSHManager.addComponent(this, "EXPRESSION_EDITOR_DLG", true, false);
            cSHManager.showTopic("EXPRESSION_EDITOR_DLG");
        }
        catch (Exception exception) {
            JOptionPane.showOptionDialog(BrowserFrame.getMainFrame(), DM4JResourceUtilities.getUIString("COMMON_ERROR_NO_HELP"), DM4JVersion.getFullBrowserName(), -1, 0, null, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean validateAttributeName() throws Exception {
        block18: {
            var1_1 = this.getAttributeName();
            var2_2 = null;
            if (!(this.m_ebc instanceof ComputeFieldContext)) {
                throw new Exception("Unexpected usage context.");
            }
            var3_3 = (ComputeFieldContext)this.m_ebc;
            if (null == var1_1 || var1_1.equalsIgnoreCase("")) {
                var2_2 = DM4JResourceUtilities.getUIString("EXPBLDR_ERROR_ATTRIBUTE_EMPTY");
                this.showMessage(var2_2, -1, 0);
                return false;
            }
            if (!ValidationUtil.checkStringLength(var1_1, 30)) {
                var2_2 = DM4JResourceUtilities.getUIString("EXPBLDR_ERROR_ATTRIBUTE_TOOLONG");
                this.showMessage(var2_2, -1, 0);
                return false;
            }
            if (ValidationUtil.containsDoubleQuote(var1_1)) {
                var2_2 = DM4JResourceUtilities.getUIString("EXPBLDR_ERROR_ATTRIBUTE_HASDBLQUOTE");
                this.showMessage(var2_2, -1, 0);
                return false;
            }
            if (ValidationUtil.isEqualToROWID(var1_1)) {
                var2_2 = DM4JResourceUtilities.getUIString("EXPBLDR_ERROR_ATTRIBUTE_NAME_RESERVED");
                this.showMessage(var2_2, -1, 0);
                return false;
            }
            var4_4 = null;
            try {
                var4_4 = DM4JConnectionManager.getDbConnection();
                if (!ValidationUtil.isGreater32BytesInDB(var1_1, var4_4)) ** GOTO lbl66
                var2_2 = DM4JResourceUtilities.getUIString("EXPBLDR_ERROR_ATTRIBUTE_32");
                this.showMessage(var2_2, -1, 0);
                var5_5 = false;
                var7_8 = null;
                if (null == var4_4) return var5_5;
                ** GOTO lbl-1000
            }
            catch (Exception var5_6) {
                var5_6.printStackTrace();
                var7_9 /* !! */  = null;
                if (null == var4_4) break block18;
                try {
                    var4_4.close();
                }
                catch (Exception var8_12) {
                    var8_12.printStackTrace();
                }
                break block18;
            }
            {
                catch (Throwable var6_15) {
                    var7_10 = null;
                    if (null == var4_4) throw var6_15;
                    ** try [egrp 2[TRYBLOCK] [5 : 211->221)] { 
lbl55:
                    // 1 sources

                    var4_4.close();
                    throw var6_15;
lbl57:
                    // 1 sources

                    catch (Exception var8_13) {
                        var8_13.printStackTrace();
                    }
                    throw var6_15;
                }
lbl-1000:
                // 1 sources

                try {}
                catch (Exception var8_11) {
                    var8_11.printStackTrace();
                    return var5_5;
                }
                var4_4.close();
                return var5_5;
lbl66:
                // 1 sources

                var7_9 /* !! */  = null;
                if (null == var4_4) break block18;
                ** try [egrp 2[TRYBLOCK] [5 : 211->221)] { 
lbl69:
                // 1 sources

                var4_4.close();
lbl71:
                // 1 sources

                catch (Exception var8_12) {}
                var8_12.printStackTrace();
            }
        }
        var5_7 = this.m_dialogPanel.getSourceAttributeNames();
        var6_16 = var5_7.elements();
        while (var6_16.hasMoreElements()) {
            var7_9 /* !! */  = (String)var6_16.nextElement();
            if (!var1_1.equals(var7_9 /* !! */ ) || var1_1.equals(this.m_origAttribName)) continue;
            var2_2 = DM4JResourceUtilities.getUIString("EXPBLDR_ERROR_ATTRIBUTE_EXISTS_IN_SOURCE");
            this.showMessage(var2_2, -1, 0);
            return false;
        }
        var7_9 /* !! */  = var3_3.getDefinedFieldNames();
        var8_14 = 0;
        while (var8_14 < var7_9 /* !! */ .length) {
            if (var1_1.equals(var7_9 /* !! */ [var8_14]) && !var1_1.equals(this.m_origAttribName)) {
                var2_2 = DM4JResourceUtilities.getUIString("EXPBLDR_ERROR_ATTRIBUTE_NOT_UNIQUE");
                this.showMessage(var2_2, -1, 0);
                return false;
            }
            ++var8_14;
        }
        return true;
    }

    /*
     * Loose catch block
     */
    public boolean validateExpression() throws Exception {
        block17: {
            String string = this.getExpression();
            String string2 = null;
            if (null == string || string.equalsIgnoreCase("")) {
                string2 = DM4JResourceUtilities.getUIString("EXPBLDR_ERROR_EXPRESSION_EMPTY");
                this.showMessage(string2, -1, 0);
                return false;
            }
            StringBuffer stringBuffer = new StringBuffer(100);
            if (this.m_ebc instanceof ComputeFieldContext) {
                stringBuffer.append(this.formNewAttributeQuery());
            } else if (this.m_ebc instanceof AggregateContext) {
                stringBuffer.append(this.formAggregateQuery());
            } else if (this.m_ebc instanceof Filter2DContext) {
                stringBuffer.append(this.formFilter2DQuery());
            } else {
                throw new Exception("Unexpected ExpressionBuilderContext type encountered");
            }
            StringBuffer stringBuffer2 = new StringBuffer(stringBuffer.toString());
            StringBuffer[] stringBufferArray = new StringBuffer[]{stringBuffer2};
            PLSQLAnonymousBlock pLSQLAnonymousBlock = new PLSQLAnonymousBlock(stringBufferArray, true);
            String string3 = pLSQLAnonymousBlock.getResult();
            Connection connection = null;
            String string4 = null;
            connection = DM4JConnectionManager.getDbConnection();
            OracleCallableStatement oracleCallableStatement = (OracleCallableStatement)connection.prepareCall(string3);
            oracleCallableStatement.registerOutParameter(1, 12);
            oracleCallableStatement.execute();
            string4 = oracleCallableStatement.getString(1);
            if (null != string4 && string4.length() > 0) {
                throw new Exception(string4);
            }
            Object var12_12 = null;
            try {
                if (connection != null) {
                    connection.close();
                }
                break block17;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            break block17;
            {
                catch (SQLException sQLException) {
                    throw sQLException;
                }
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                throw throwable;
            }
        }
        return true;
    }

    private String formNewAttributeQuery() {
        Object[] objectArray = new Object[]{this.getExpression(), this.getAttributeName(), this.m_ebc.getSchemaName(), this.m_ebc.getTableName()};
        return MessageFormat.format(newAttributeQuery, objectArray);
    }

    private String formAggregateQuery() {
        String string = aggregateQuery;
        AggregateContext aggregateContext = (AggregateContext)this.m_ebc;
        String string2 = null;
        String string3 = null;
        if (aggregateContext.isGroupBy()) {
            string2 = this.getExpression();
            string3 = aggregateContext.getHavingExpression();
        } else {
            string2 = aggregateContext.getGroupByExpression();
            string3 = this.getExpression();
        }
        boolean bl = false;
        boolean bl2 = false;
        if (null != string2 && string2.length() > 0) {
            bl = true;
        }
        if (null != string3 && string3.length() > 0) {
            bl2 = true;
        }
        Object[] objectArray = new Object[]{aggregateContext.getSelectClause(), aggregateContext.getSchemaName(), aggregateContext.getTableName()};
        string = MessageFormat.format(aggregateQuery, objectArray);
        if (bl) {
            string = string + " GROUP BY " + string2;
        }
        if (bl2) {
            string = string + " HAVING " + string3;
        }
        return string;
    }

    private String formFilter2DQuery() {
        Filter2DContext filter2DContext = (Filter2DContext)this.m_ebc;
        Object[] objectArray = new Object[]{filter2DContext.getSchemaName(), filter2DContext.getTableName(), this.getExpression()};
        String string = MessageFormat.format(filter2DQuery, objectArray);
        return string;
    }

    private void cancel_actionPerformed(ActionEvent actionEvent) {
        this.m_isOk = false;
        this.setVisible(false);
        this.dispose();
    }

    public String getAttributeName() {
        return this.m_dialogPanel.getAttributeName();
    }

    public String getExpression() {
        return this.m_dialogPanel.getExpression();
    }

    public boolean isOk() {
        return this.m_isOk;
    }

    private int showMessage(String string, int n, int n2) {
        return JOptionPane.showOptionDialog(this, string, DM4JVersion.getFullBrowserName(), n, n2, null, null, null);
    }
}

