/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.diag;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import oracle.dmt.dm4j.activity.AbstractActivity;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.tree.node.LeafNodeData;
import oracle.dmt.dm4j.browser.viewer.activity.ActivityViewer;
import oracle.dmt.dm4j.wizard.steps.commonsteps.TableSorter;

public class ActivityDiagViewer
extends JTabbedPane {
    ActivityViewer _activityPanel;
    GriddedPanel _diagPanel = new GriddedPanel();
    LeafNodeData _nd = null;

    public ActivityDiagViewer(LeafNodeData leafNodeData, ActivityViewer activityViewer) {
        try {
            this._nd = leafNodeData;
            this._activityPanel = activityViewer;
            this.runTimePanelLoad(leafNodeData);
            this.setMinimumSize(BrowserFrame.m_prefRightPaneSize);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getHelpId() {
        return "APPLY_RESULT";
    }

    private void jbInit() throws Exception {
        this.addTab("Activity", null, this._activityPanel, "Activity");
        this.addTab("Diagnostics", null, this._diagPanel, "Diagnostics Information");
        this.loadDiagPanel();
        this.setSelectedIndex(0);
    }

    private void loadDiagPanel() {
        class DiagTable
        extends JTable {
            DiagTable() {
            }

            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        }
        DiagTable diagTable = new DiagTable();
        Vector vector = new Vector();
        Vector<String> vector2 = new Vector<String>();
        Vector<Object> vector3 = null;
        AbstractActivity abstractActivity = this._activityPanel.getActivity();
        vector2.add("Name");
        vector2.add("Value");
        vector3 = new Vector<Object>();
        vector3.add("Unique identifier");
        vector3.add(abstractActivity.getUniqueIdentifier());
        vector.add(vector3);
        vector3 = new Vector();
        vector3.add("Sampled case table");
        vector3.add(abstractActivity.getSampledCaseTable());
        vector.add(vector3);
        vector3 = new Vector();
        vector3.add("Case table");
        vector3.add(abstractActivity.getCaseTable());
        vector.add(vector3);
        vector3 = new Vector();
        vector3.add("Case count");
        vector3.add(Integer.toString(abstractActivity.getCaseCount()));
        vector.add(vector3);
        vector3 = new Vector();
        vector3.add("Build cost matrix table");
        vector3.add(abstractActivity.getCurBuildCostMatrix());
        vector.add(vector3);
        vector3 = new Vector();
        vector3.add("Test cost matrix table");
        vector3.add(abstractActivity.getCurTestCostMatrix());
        vector.add(vector3);
        vector3 = new Vector();
        vector3.add("Persisted case table");
        vector3.add(abstractActivity.getPersistedCaseTable());
        vector.add(vector3);
        vector3 = new Vector();
        vector3.add("Target column");
        vector3.add(abstractActivity.getTargetColumn());
        vector.add(vector3);
        vector3 = new Vector();
        vector3.add("Target table");
        vector3.add(abstractActivity.getTargetTable());
        vector.add(vector3);
        vector3 = new Vector();
        vector3.add("Target value");
        vector3.add(abstractActivity.getTargetValue());
        vector.add(vector3);
        vector3 = new Vector();
        vector3.add("Text column");
        vector3.add(abstractActivity.getTextColumn());
        vector.add(vector3);
        vector3 = new Vector();
        vector3.add("Text table");
        vector3.add(abstractActivity.getTextTable());
        vector.add(vector3);
        vector3 = new Vector();
        vector3.add("Timestamp");
        vector3.add(abstractActivity.getTimestamp());
        vector.add(vector3);
        vector3 = new Vector();
        vector3.add("2D Data source");
        vector3.add(abstractActivity.getTwodDataSource());
        vector.add(vector3);
        vector3 = new Vector();
        vector3.add("Boolean: use build cost matrix");
        vector3.add(Boolean.toString(abstractActivity.getUseBuildCostMatrix()));
        vector.add(vector3);
        vector3 = new Vector();
        vector3.add("Boolean: use test cost matrix");
        vector3.add(Boolean.toString(abstractActivity.getUseTestCostMatrix()));
        vector.add(vector3);
        vector3 = new Vector();
        vector3.add("Version");
        vector3.add(Integer.toString(abstractActivity.getVersion()));
        vector.add(vector3);
        try {
            vector3 = new Vector();
            vector3.add("Input data descriptor: attribute name column");
            vector3.add(abstractActivity.getInputDataDescriptor().getAttributeNameColumn());
            vector.add(vector3);
            vector3 = new Vector();
            vector3.add("Input data descriptor: case id");
            vector3.add(abstractActivity.getInputDataDescriptor().getCaseId());
            vector.add(vector3);
            vector3 = new Vector();
            vector3.add("Input data descriptor: case id column");
            vector3.add(abstractActivity.getInputDataDescriptor().getCaseIdColumn());
            vector.add(vector3);
            vector3 = new Vector();
            vector3.add("Input data descriptor: case schema");
            vector3.add(abstractActivity.getInputDataDescriptor().getCaseSchema());
            vector.add(vector3);
            vector3 = new Vector();
            vector3.add("Input data descriptor: case table");
            vector3.add(abstractActivity.getInputDataDescriptor().getCaseTable());
            vector.add(vector3);
            vector3 = new Vector();
            vector3.add("Input data descriptor: case schema");
            vector3.add(abstractActivity.getInputDataDescriptor().getCaseSchema());
            vector.add(vector3);
            vector3 = new Vector();
            vector3.add("Input data descriptor: data location");
            vector3.add(abstractActivity.getInputDataDescriptor().getDataLocation());
            vector.add(vector3);
            vector3 = new Vector();
            vector3.add("Input data descriptor: name");
            vector3.add(abstractActivity.getInputDataDescriptor().getName());
            vector.add(vector3);
            vector3 = new Vector();
            vector3.add("Input data descriptor: SQL case query");
            vector3.add(abstractActivity.getInputDataDescriptor().getSQLCaseQuery());
            vector.add(vector3);
            vector3 = new Vector();
            vector3.add("Input data descriptor: sampled case table");
            vector3.add(abstractActivity.getInputDataDescriptor().getSampledCaseTable());
            vector.add(vector3);
            vector3 = new Vector();
            vector3.add("Input data descriptor: TXColumn");
            vector3.add(abstractActivity.getInputDataDescriptor().getTXColumn());
            vector.add(vector3);
            vector3 = new Vector();
            vector3.add("Input data descriptor: table name");
            vector3.add(abstractActivity.getInputDataDescriptor().getTableName());
            vector.add(vector3);
            vector3 = new Vector();
            vector3.add("Input data descriptor: value column");
            vector3.add(abstractActivity.getInputDataDescriptor().getValueColumn());
            vector.add(vector3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        DefaultTableModel defaultTableModel = new DefaultTableModel(vector, vector2);
        TableSorter tableSorter = new TableSorter(defaultTableModel);
        diagTable.setModel(tableSorter);
        diagTable.getTableHeader().setReorderingAllowed(false);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(diagTable);
        this._diagPanel.add((Component)jScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 9, 10), 540, 365));
    }

    private void runTimePanelLoad(LeafNodeData leafNodeData) throws Exception {
        Thread thread = new Thread(new LoadPanel(leafNodeData));
        thread.setPriority(5);
        thread.start();
    }

    class LoadPanel
    implements Runnable {
        GriddedPanel panel;
        Exception exception = null;
        LeafNodeData nd = null;

        public LoadPanel(LeafNodeData leafNodeData) {
            this.nd = leafNodeData;
        }

        public Exception getException() {
            return this.exception;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                ActivityDiagViewer.this.jbInit();
            }
            catch (Exception exception) {
                this.exception = exception;
                exception.printStackTrace();
            }
        }
    }
}

