/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.datasources;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.dmt.dm4j.datasources.TargetValueDataSource;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;

public class TargetValueWeightDataSource
extends TargetValueDataSource {
    private boolean m_activeLearning = true;
    private static final int SVM_ACTIVE_LEARNING_COUNT_LMT = 10000;
    private static final int SVM_NON_ACTIVE_LEARNING_COUNT_LMT = 50000;
    public static final int TARGET_WEIGHT = 3;

    public TargetValueWeightDataSource(javax.datamining.resource.Connection connection, String string, String string2, String string3) {
        this(connection, string, string2, string3, true);
    }

    public TargetValueWeightDataSource(javax.datamining.resource.Connection connection, String string, String string2, String string3, boolean bl) {
        super(connection, string, string2, string3);
        this.m_activeLearning = bl;
    }

    public TargetValueWeightDataSource(HashMap hashMap) {
        this(hashMap, null);
    }

    public TargetValueWeightDataSource(HashMap hashMap, HashMap hashMap2) {
        this(hashMap, hashMap2, true);
    }

    public TargetValueWeightDataSource(HashMap hashMap, boolean bl) {
        this(hashMap, null, bl);
    }

    public TargetValueWeightDataSource(HashMap hashMap, HashMap hashMap2, boolean bl) {
        super(hashMap, hashMap2);
        this.m_activeLearning = bl;
    }

    public HashMap getWeights() throws Exception {
        HashMap<String, Double> hashMap = new HashMap<String, Double>();
        for (int i = 0; i < this.getRowCount(); ++i) {
            String string = (String)this.getData(0, i);
            Double d = (Double)this.getData(3, i);
            hashMap.put(string, d);
        }
        return hashMap;
    }

    protected ArrayOneDModel createColumns() throws Exception {
        this.addColumns(0, 4);
        this.m_columns = new String[4];
        this.m_columns[0] = ResourceUtilities.getUILabel("PRIORS_SETTINGS_VALUE");
        this.m_columns[1] = ResourceUtilities.getUILabel("PRIORS_SETTINGS_CURRENT_COUNT");
        this.m_columns[2] = ResourceUtilities.getUILabel("PRIORS_SETTINGS_CURRENT_DISTRIBUTION");
        this.m_columns[3] = ResourceUtilities.getUILabel("WEIGHTS_SETTINGS_TARGET_WEIGHT");
        return new ArrayOneDModel(this.m_columns);
    }

    protected void createDataFromPrior() throws SQLException {
        Object k;
        int n = 0;
        int n2 = 0;
        Iterator iterator = this.m_targetPriorCnt.keySet().iterator();
        int n3 = 0;
        while (iterator.hasNext()) {
            k = iterator.next();
            int n4 = (Integer)this.m_targetPriorCnt.get(k);
            n += n4;
            n4 = this.m_activeLearning ? (n4 > 10000 ? 10000 : n4) : (n4 > 50000 ? 50000 : n4);
            n2 += n4;
            ++n3;
        }
        iterator = this.m_targetPriorCnt.keySet().iterator();
        n3 = 0;
        while (iterator.hasNext()) {
            k = iterator.next();
            String string = (String)k;
            int n5 = (Integer)this.m_targetPriorCnt.get(k);
            this.addRows(n3, 1);
            this.setData(0, n3, string);
            this.setData(1, n3, new Integer(n5));
            this.setData(2, n3, new Double((double)n5 / (double)n * 100.0));
            double d = 0.0;
            if (this.m_targetPriorPct != null) {
                d = (Double)this.m_targetPriorPct.get(k);
            } else {
                n5 = this.m_activeLearning ? (n5 > 10000 ? 10000 : n5) : (n5 > 50000 ? 50000 : n5);
                d = n5 > 0 ? (double)n2 / (double)n5 : 0.0;
            }
            this.setData(3, n3, new Double(d));
            ++n3;
        }
        this.fudgePercentageTo100(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createDataFromDB() throws SQLException {
        ResultSet resultSet;
        block6: {
            Connection connection = this.m_conn;
            String string = this.m_table;
            String string2 = this.m_schema;
            String string3 = this.m_targetAttributeName;
            int n = 0;
            n = this.m_activeLearning ? 10000 : 50000;
            String string4 = "select  \"" + string3 + "\" as VALUE, " + "COUNT(*) as VALUE_COUNT, " + "CASE " + "  WHEN COUNT(*) > " + n + " THEN " + n + " " + "  ELSE COUNT(*) " + "END AS LMT_VALUE_COUNT " + "from \"" + string2 + "\".\"" + string + "\" " + "group by \"" + string3 + "\" " + "having \"" + string3 + "\" is not null ";
            String string5 = "select SUM(VALUE_COUNT) TOTAL, SUM(LMT_VALUE_COUNT) LMT_TOTAL from ( select   COUNT(*) as VALUE_COUNT,   CASE   WHEN COUNT(*) > " + n + " THEN " + n + " " + "    ELSE COUNT(*) " + "  END AS LMT_VALUE_COUNT " + "from \"" + string2 + "\".\"" + string + "\" " + "group by \"" + string3 + "\" " + "having \"" + string3 + "\" is not null " + ") ";
            String string6 = "select  e.VALUE as VALUE, e.VALUE_COUNT as VALUE_COUNT, ROUND((e.VALUE_COUNT/TOTAL)*100,4) as CURRENT_DISTRIBUTION, ROUND((f.LMT_TOTAL/e.LMT_VALUE_COUNT),4) as WEIGHT from (" + string4 + ") e, " + "     (" + string5 + ") f ";
            CallableStatement callableStatement = null;
            resultSet = null;
            try {
                callableStatement = connection.prepareCall(string6);
                resultSet = callableStatement.executeQuery();
                int n2 = 0;
                double d = 0.0;
                double d2 = 0.0;
                while (resultSet.next()) {
                    this.addRows(n2, 1);
                    String string7 = resultSet.getString("VALUE");
                    this.setData(0, n2, string7);
                    int n3 = resultSet.getInt("VALUE_COUNT");
                    this.setData(1, n2, new Integer(n3));
                    d = resultSet.getDouble("CURRENT_DISTRIBUTION");
                    Double d3 = new Double(d);
                    this.setData(2, n2, d3);
                    d2 = resultSet.getDouble("WEIGHT");
                    Double d4 = new Double(d2);
                    this.setData(3, n2, d4);
                    ++n2;
                }
                this.fudgePercentageTo100(2);
                Object var21_18 = null;
                if (callableStatement == null) break block6;
            }
            catch (Throwable throwable) {
                Object var21_19 = null;
                if (callableStatement != null) {
                    callableStatement.close();
                }
                if (resultSet != null) {
                    resultSet.close();
                }
                throw throwable;
            }
            callableStatement.close();
        }
        if (resultSet != null) {
            resultSet.close();
        }
    }

    public Double getTargetWeightsTotal() {
        double d = 0.0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            Object object = this.getData(3, i);
            if (!(object instanceof Double)) continue;
            d += ((Double)this.getData(3, i)).doubleValue();
        }
        return new Double(d);
    }

    public void clone(TargetValueWeightDataSource targetValueWeightDataSource) throws Exception {
        super.clone(targetValueWeightDataSource);
    }
}

