/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.datasources;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.dmt.dm4j.DM4JUnableToFindTargetAttributeException;
import oracle.dmt.dm4j.datasources.DM4JDataSource;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;

public class TargetValueDataSource
extends DM4JDataSource {
    protected String[] m_columns = null;
    protected static final int COLUMN_COUNT = 4;
    protected HashMap m_targetPriorCnt = null;
    protected HashMap m_targetPriorPct = null;
    public static final int TARGET_VALUE = 0;
    public static final int TARGET_VALUE_COUNT = 1;
    public static final int CURRENT_DISTRIBUTION = 2;
    public static final int ORIGINAL_DISTRIBUTION = 3;
    protected String m_targetAttributeName;
    private int m_caseCount = 0;

    public TargetValueDataSource() {
        this(null);
    }

    public TargetValueDataSource(javax.datamining.resource.Connection connection, String string, String string2, String string3) {
        super(connection, string, string2);
        this.m_targetAttributeName = string3;
    }

    public TargetValueDataSource(HashMap hashMap) {
        this(hashMap, null);
    }

    public TargetValueDataSource(HashMap hashMap, HashMap hashMap2) {
        super(null);
        if (hashMap != null) {
            this.m_targetPriorCnt = new HashMap(hashMap);
        }
        if (hashMap2 != null) {
            this.m_targetPriorPct = new HashMap(hashMap2);
        }
    }

    public HashMap getTargetPriorPct() throws Exception {
        HashMap<String, Double> hashMap = new HashMap<String, Double>();
        for (int i = 0; i < this.getRowCount(); ++i) {
            String string = (String)this.getData(0, i);
            Double d = (Double)this.getData(3, i);
            hashMap.put(string, d);
        }
        return hashMap;
    }

    public HashMap getTargetPriorCnt() throws Exception {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (int i = 0; i < this.getRowCount(); ++i) {
            String string = (String)this.getData(0, i);
            Integer n = (Integer)this.getData(1, i);
            hashMap.put(string, n);
        }
        return hashMap;
    }

    protected void createData() throws SQLException {
        if (this.m_targetPriorCnt == null) {
            this.createDataFromDB();
        } else {
            this.createDataFromPrior();
        }
    }

    protected void createDataFromPrior() throws SQLException {
        Object k;
        int n = 0;
        boolean bl = false;
        Iterator iterator = this.m_targetPriorCnt.keySet().iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            k = iterator.next();
            int n3 = (Integer)this.m_targetPriorCnt.get(k);
            n += n3;
            ++n2;
        }
        iterator = this.m_targetPriorCnt.keySet().iterator();
        n2 = 0;
        while (iterator.hasNext()) {
            k = iterator.next();
            String string = (String)k;
            int n4 = (Integer)this.m_targetPriorCnt.get(k);
            this.addRows(n2, 1);
            this.setData(0, n2, string);
            this.setData(1, n2, new Integer(n4));
            double d = 0.0;
            d = this.m_targetPriorPct != null && this.m_targetPriorPct.size() > 0 ? (Double)this.m_targetPriorPct.get(k) : (double)n4 / (double)n * 100.0;
            this.setData(3, n2, new Double(d));
            this.setData(2, n2, new Double((double)n4 / (double)n * 100.0));
            ++n2;
        }
        if (this.m_targetPriorPct == null) {
            this.fudgePercentageTo100(3);
        }
        this.fudgePercentageTo100(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void createDataFromDB() throws SQLException {
        ResultSet resultSet;
        block10: {
            Connection connection = this.m_conn;
            String string = this.m_table;
            String string2 = this.m_schema;
            String string3 = this.m_targetAttributeName;
            String string4 = "select  \"" + string3 + "\" as VALUE, " + "COUNT(*) as VALUE_COUNT " + "from \"" + string2 + "\".\"" + string + "\" " + "group by \"" + string3 + "\" " + "having \"" + string3 + "\" is not null ";
            String string5 = "select  COUNT(*) as TOTAL from \"" + string2 + "\".\"" + string + "\" " + "where \"" + string3 + "\" is not null ";
            String string6 = "select  COUNT(*) as ROWCOUNT from \"" + string2 + "\".\"" + string + "\" ";
            String string7 = "select  e.VALUE, e.VALUE_COUNT, ROUND((e.VALUE_COUNT/TOTAL)*100,4) as CURRENT_DISTRIBUTION, f.TOTAL, g.ROWCOUNT from (" + string4 + ") e, " + "     (" + string5 + ") f, " + "     (" + string6 + ") g ";
            CallableStatement callableStatement = null;
            resultSet = null;
            try {
                try {
                    callableStatement = connection.prepareCall(string7);
                    resultSet = callableStatement.executeQuery();
                    int n = 0;
                    double d = 0.0;
                    int n2 = 0;
                    while (resultSet.next()) {
                        if (n2 == 0) {
                            n2 = resultSet.getInt("TOTAL");
                        }
                        if (this.m_caseCount == 0) {
                            this.m_caseCount = resultSet.getInt("ROWCOUNT");
                        }
                        this.addRows(n, 1);
                        String string8 = resultSet.getString(1);
                        this.setData(0, n, string8);
                        int n3 = resultSet.getInt(2);
                        this.setData(1, n, new Integer(n3));
                        d = resultSet.getDouble(3);
                        Double d2 = new Double(d);
                        Double d3 = new Double(d);
                        this.setData(2, n, d2);
                        this.setData(3, n, d3);
                        ++n;
                    }
                    this.fudgePercentageTo100(2);
                    this.fudgePercentageTo100(3);
                }
                catch (Exception exception) {
                    this.setException(new DM4JUnableToFindTargetAttributeException("Failure querying for counts for models target attribute."));
                    Object var20_20 = null;
                    if (callableStatement != null) {
                        callableStatement.close();
                    }
                    if (resultSet == null) return;
                    resultSet.close();
                    return;
                }
                Object var20_19 = null;
                if (callableStatement == null) break block10;
            }
            catch (Throwable throwable) {
                Object var20_21 = null;
                if (callableStatement != null) {
                    callableStatement.close();
                }
                if (resultSet == null) throw throwable;
                resultSet.close();
                throw throwable;
            }
            callableStatement.close();
        }
        if (resultSet == null) return;
        resultSet.close();
    }

    protected ArrayOneDModel createColumns() throws Exception {
        this.addColumns(0, 4);
        this.m_columns = new String[4];
        this.m_columns[0] = ResourceUtilities.getUILabel("PRIORS_SETTINGS_VALUE");
        this.m_columns[1] = ResourceUtilities.getUILabel("PRIORS_SETTINGS_CURRENT_COUNT");
        this.m_columns[2] = ResourceUtilities.getUILabel("PRIORS_SETTINGS_CURRENT_DISTRIBUTION");
        this.m_columns[3] = ResourceUtilities.getUILabel("PRIORS_SETTINGS_PRIOR_DISTRIBUTION");
        return new ArrayOneDModel(this.m_columns);
    }

    public int getCaseCount() {
        return this.m_caseCount;
    }

    public Double getOriginalPriorsTotal() {
        double d = 0.0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            Object object = this.getData(3, i);
            if (!(object instanceof Double)) continue;
            d += ((Double)this.getData(3, i)).doubleValue();
        }
        return new Double(d);
    }

    protected void fudgePercentageTo100(int n) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n2 = 0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            d = (Double)this.getData(n, i);
            if (d > d3) {
                d3 = d;
                n2 = i;
            }
            d2 += d;
        }
        if (d2 <= 0.0) {
            return;
        }
        double d4 = 100.0 - d2;
        if (d4 > 0.0 || d4 < 0.0) {
            Double d5 = new Double(d3 + d4);
            this.setData(n, n2, d5);
        }
    }

    public int getTargetCountTotal() {
        int n = 0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            Integer n2 = (Integer)this.getData(1, i);
            n += n2.intValue();
        }
        return n;
    }

    public void clone(TargetValueDataSource targetValueDataSource) throws Exception {
        int n;
        int n2 = targetValueDataSource.getColumnCount();
        int n3 = targetValueDataSource.getRowCount();
        this.addColumns(0, n2);
        this.m_columns = new String[n2];
        ArrayOneDModel arrayOneDModel = targetValueDataSource.getColumnDataSource();
        for (n = 0; n < n2; ++n) {
            this.m_columns[n] = (String)arrayOneDModel.getData(n);
        }
        this.addRows(0, n3);
        for (n = 0; n < n3; ++n) {
            for (int i = 0; i < n2; ++i) {
                Object object = targetValueDataSource.getData(i, n);
                this.setData(i, n, object);
            }
        }
    }

    public String getLowestCardinalityAttribute() {
        double d = Double.MAX_VALUE;
        String string = null;
        for (int i = 0; i < this.getRowCount(); ++i) {
            double d2 = Double.MAX_VALUE;
            Object object = this.getData(3, i);
            if (object instanceof Double) {
                d2 = (Double)this.getData(3, i);
            }
            if (!(d2 <= d)) continue;
            string = (String)this.getData(0, i);
            d = d2;
        }
        return string;
    }

    public void syncrhonizePriors(TargetValueDataSource targetValueDataSource) {
    }
}

